/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.ext.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Rectangle;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.util.UnitConv;
import org.dromara.pdf.fop.doc.page.XEasyPdfTemplatePageRectangle;
import org.dromara.pdf.fop.util.XEasyPdfTemplateFontStyleUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XEasyPdfTemplateBarCodeConfig {
    private BarcodeFormat type;
    private Double scaleRate;
    private Integer width;
    private Integer height;
    private String content;
    private Integer codeMargin;
    private ErrorCorrectionLevel errorLevel;
    private Color onColor;
    private Color offColor;
    private String words;
    private Color wordsColor;
    private String wordsFamily;
    private Integer wordsStyle;
    private Integer wordsSize;
    private Integer wordsOffsetX;
    private Integer wordsOffsetY;
    private Double radians;
    private final Map<EncodeHintType, Object> encodeHints = new HashMap<EncodeHintType, Object>(8);

    static XEasyPdfTemplateBarCodeConfig init(NamedNodeMap attributes) {
        XEasyPdfTemplateBarCodeConfig config = new XEasyPdfTemplateBarCodeConfig();
        config.initParams(attributes);
        config.initEncodeHints();
        return config;
    }

    static XEasyPdfTemplateBarCodeConfig onlyInitRectangle(NamedNodeMap attributes) {
        XEasyPdfTemplateBarCodeConfig config = new XEasyPdfTemplateBarCodeConfig();
        config.onlyInitRectangleParams(attributes);
        return config;
    }

    boolean isRotate() {
        return this.radians != null;
    }

    Rectangle getRotateRectangle() {
        return XEasyPdfTemplatePageRectangle.getRotateRectangle(this.width, this.height, this.radians);
    }

    private void initParams(NamedNodeMap attributes) {
        this.type = this.resolveValue(attributes, "type", null, v -> BarcodeFormat.valueOf((String)v.toUpperCase()));
        this.scaleRate = this.resolveValue(attributes, "scale-rate", "2", Double::parseDouble);
        this.width = this.resolveValue(attributes, "width", null, this::parseUnit);
        this.height = this.resolveValue(attributes, "height", null, this::parseUnit);
        this.content = this.resolveValue(attributes, "content", null, v -> v);
        this.codeMargin = this.resolveValue(attributes, "code-margin", "1", Integer::parseInt);
        this.errorLevel = this.resolveValue(attributes, "error-level", "M", v -> ErrorCorrectionLevel.valueOf((String)v.toUpperCase()));
        this.onColor = this.resolveValue(attributes, "on-color", "BLACK", this::parseColor);
        this.offColor = this.resolveValue(attributes, "off-color", "WHITE", this::parseColor);
        this.words = Optional.ofNullable(attributes.getNamedItem("words")).map(Node::getNodeValue).orElse(null);
        this.wordsColor = this.resolveValue(attributes, "words-color", "BLACK", this::parseColor);
        this.wordsFamily = Optional.ofNullable(attributes.getNamedItem("words-family")).map(Node::getNodeValue).orElse(null);
        this.wordsStyle = this.resolveValue(attributes, "words-style", "NORMAL", XEasyPdfTemplateFontStyleUtil::getStyle);
        this.wordsSize = this.resolveValue(attributes, "words-size", "12pt", this::parseUnit);
        this.wordsOffsetX = this.resolveValue(attributes, "words-offset-x", "0pt", this::parseUnit);
        this.wordsOffsetY = this.resolveValue(attributes, "words-offset-y", "2pt", this::parseUnit);
        this.radians = this.resolveValue(attributes, "radians", "0", Double::parseDouble);
    }

    private void onlyInitRectangleParams(NamedNodeMap attributes) {
        this.width = this.resolveValue(attributes, "width", null, v -> UnitConv.convert((String)v) / 1000);
        this.height = this.resolveValue(attributes, "height", null, v -> UnitConv.convert((String)v) / 1000);
        this.radians = this.resolveValue(attributes, "radians", "0", Double::parseDouble);
        this.words = Optional.ofNullable(attributes.getNamedItem("words")).map(Node::getNodeValue).orElse(null);
        this.wordsSize = this.resolveValue(attributes, "words-size", "12pt", v -> UnitConv.convert((String)v) / 1000);
        if (this.isRotate()) {
            Rectangle rectangle = this.getRotateRectangle();
            this.width = rectangle.width;
            this.height = rectangle.height;
        }
    }

    private void initEncodeHints() {
        this.initErrorLevel();
        this.encodeHints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
        this.encodeHints.put(EncodeHintType.MARGIN, this.codeMargin);
    }

    private void initErrorLevel() {
        if (BarcodeFormat.AZTEC == this.type || BarcodeFormat.PDF_417 == this.type) {
            this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, this.errorLevel.getBits());
        } else {
            this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, this.errorLevel);
        }
    }

    private <R> R resolveValue(NamedNodeMap attributes, String attributeName, String defaultValue, Function<String, R> function) {
        return (R)Optional.ofNullable(Optional.ofNullable(attributes.getNamedItem(attributeName)).map(Node::getNodeValue).orElse(defaultValue)).map(v -> {
            try {
                return function.apply((String)v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("the barcode attribute['" + attributeName + "'] is error");
            }
        }).orElseThrow(() -> new IllegalArgumentException("the barcode attribute['" + attributeName + "'] can not be null"));
    }

    private Color parseColor(String color) {
        return ColorUtil.parseColorString(null, (String)color);
    }

    private int parseUnit(String unit) {
        return (int)((double)(UnitConv.convert((String)unit) / 1000) * this.scaleRate);
    }

    public BarcodeFormat getType() {
        return this.type;
    }

    public Double getScaleRate() {
        return this.scaleRate;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getCodeMargin() {
        return this.codeMargin;
    }

    public ErrorCorrectionLevel getErrorLevel() {
        return this.errorLevel;
    }

    public Color getOnColor() {
        return this.onColor;
    }

    public Color getOffColor() {
        return this.offColor;
    }

    public String getWords() {
        return this.words;
    }

    public Color getWordsColor() {
        return this.wordsColor;
    }

    public String getWordsFamily() {
        return this.wordsFamily;
    }

    public Integer getWordsStyle() {
        return this.wordsStyle;
    }

    public Integer getWordsSize() {
        return this.wordsSize;
    }

    public Integer getWordsOffsetX() {
        return this.wordsOffsetX;
    }

    public Integer getWordsOffsetY() {
        return this.wordsOffsetY;
    }

    public Double getRadians() {
        return this.radians;
    }

    public Map<EncodeHintType, Object> getEncodeHints() {
        return this.encodeHints;
    }

    public XEasyPdfTemplateBarCodeConfig setType(BarcodeFormat type) {
        this.type = type;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setScaleRate(Double scaleRate) {
        this.scaleRate = scaleRate;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setContent(String content) {
        this.content = content;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setCodeMargin(Integer codeMargin) {
        this.codeMargin = codeMargin;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setErrorLevel(ErrorCorrectionLevel errorLevel) {
        this.errorLevel = errorLevel;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setOnColor(Color onColor) {
        this.onColor = onColor;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setOffColor(Color offColor) {
        this.offColor = offColor;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setWords(String words) {
        this.words = words;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setWordsColor(Color wordsColor) {
        this.wordsColor = wordsColor;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setWordsFamily(String wordsFamily) {
        this.wordsFamily = wordsFamily;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setWordsStyle(Integer wordsStyle) {
        this.wordsStyle = wordsStyle;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setWordsSize(Integer wordsSize) {
        this.wordsSize = wordsSize;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setWordsOffsetX(Integer wordsOffsetX) {
        this.wordsOffsetX = wordsOffsetX;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setWordsOffsetY(Integer wordsOffsetY) {
        this.wordsOffsetY = wordsOffsetY;
        return this;
    }

    public XEasyPdfTemplateBarCodeConfig setRadians(Double radians) {
        this.radians = radians;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfTemplateBarCodeConfig)) {
            return false;
        }
        XEasyPdfTemplateBarCodeConfig other = (XEasyPdfTemplateBarCodeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$scaleRate = this.getScaleRate();
        Double other$scaleRate = other.getScaleRate();
        if (this$scaleRate == null ? other$scaleRate != null : !((Object)this$scaleRate).equals(other$scaleRate)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$codeMargin = this.getCodeMargin();
        Integer other$codeMargin = other.getCodeMargin();
        if (this$codeMargin == null ? other$codeMargin != null : !((Object)this$codeMargin).equals(other$codeMargin)) {
            return false;
        }
        Integer this$wordsStyle = this.getWordsStyle();
        Integer other$wordsStyle = other.getWordsStyle();
        if (this$wordsStyle == null ? other$wordsStyle != null : !((Object)this$wordsStyle).equals(other$wordsStyle)) {
            return false;
        }
        Integer this$wordsSize = this.getWordsSize();
        Integer other$wordsSize = other.getWordsSize();
        if (this$wordsSize == null ? other$wordsSize != null : !((Object)this$wordsSize).equals(other$wordsSize)) {
            return false;
        }
        Integer this$wordsOffsetX = this.getWordsOffsetX();
        Integer other$wordsOffsetX = other.getWordsOffsetX();
        if (this$wordsOffsetX == null ? other$wordsOffsetX != null : !((Object)this$wordsOffsetX).equals(other$wordsOffsetX)) {
            return false;
        }
        Integer this$wordsOffsetY = this.getWordsOffsetY();
        Integer other$wordsOffsetY = other.getWordsOffsetY();
        if (this$wordsOffsetY == null ? other$wordsOffsetY != null : !((Object)this$wordsOffsetY).equals(other$wordsOffsetY)) {
            return false;
        }
        Double this$radians = this.getRadians();
        Double other$radians = other.getRadians();
        if (this$radians == null ? other$radians != null : !((Object)this$radians).equals(other$radians)) {
            return false;
        }
        BarcodeFormat this$type = this.getType();
        BarcodeFormat other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        ErrorCorrectionLevel this$errorLevel = this.getErrorLevel();
        ErrorCorrectionLevel other$errorLevel = other.getErrorLevel();
        if (this$errorLevel == null ? other$errorLevel != null : !this$errorLevel.equals(other$errorLevel)) {
            return false;
        }
        Color this$onColor = this.getOnColor();
        Color other$onColor = other.getOnColor();
        if (this$onColor == null ? other$onColor != null : !((Object)this$onColor).equals(other$onColor)) {
            return false;
        }
        Color this$offColor = this.getOffColor();
        Color other$offColor = other.getOffColor();
        if (this$offColor == null ? other$offColor != null : !((Object)this$offColor).equals(other$offColor)) {
            return false;
        }
        String this$words = this.getWords();
        String other$words = other.getWords();
        if (this$words == null ? other$words != null : !this$words.equals(other$words)) {
            return false;
        }
        Color this$wordsColor = this.getWordsColor();
        Color other$wordsColor = other.getWordsColor();
        if (this$wordsColor == null ? other$wordsColor != null : !((Object)this$wordsColor).equals(other$wordsColor)) {
            return false;
        }
        String this$wordsFamily = this.getWordsFamily();
        String other$wordsFamily = other.getWordsFamily();
        if (this$wordsFamily == null ? other$wordsFamily != null : !this$wordsFamily.equals(other$wordsFamily)) {
            return false;
        }
        Map<EncodeHintType, Object> this$encodeHints = this.getEncodeHints();
        Map<EncodeHintType, Object> other$encodeHints = other.getEncodeHints();
        return !(this$encodeHints == null ? other$encodeHints != null : !((Object)this$encodeHints).equals(other$encodeHints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfTemplateBarCodeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $scaleRate = this.getScaleRate();
        result = result * 59 + ($scaleRate == null ? 43 : ((Object)$scaleRate).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $codeMargin = this.getCodeMargin();
        result = result * 59 + ($codeMargin == null ? 43 : ((Object)$codeMargin).hashCode());
        Integer $wordsStyle = this.getWordsStyle();
        result = result * 59 + ($wordsStyle == null ? 43 : ((Object)$wordsStyle).hashCode());
        Integer $wordsSize = this.getWordsSize();
        result = result * 59 + ($wordsSize == null ? 43 : ((Object)$wordsSize).hashCode());
        Integer $wordsOffsetX = this.getWordsOffsetX();
        result = result * 59 + ($wordsOffsetX == null ? 43 : ((Object)$wordsOffsetX).hashCode());
        Integer $wordsOffsetY = this.getWordsOffsetY();
        result = result * 59 + ($wordsOffsetY == null ? 43 : ((Object)$wordsOffsetY).hashCode());
        Double $radians = this.getRadians();
        result = result * 59 + ($radians == null ? 43 : ((Object)$radians).hashCode());
        BarcodeFormat $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        ErrorCorrectionLevel $errorLevel = this.getErrorLevel();
        result = result * 59 + ($errorLevel == null ? 43 : $errorLevel.hashCode());
        Color $onColor = this.getOnColor();
        result = result * 59 + ($onColor == null ? 43 : ((Object)$onColor).hashCode());
        Color $offColor = this.getOffColor();
        result = result * 59 + ($offColor == null ? 43 : ((Object)$offColor).hashCode());
        String $words = this.getWords();
        result = result * 59 + ($words == null ? 43 : $words.hashCode());
        Color $wordsColor = this.getWordsColor();
        result = result * 59 + ($wordsColor == null ? 43 : ((Object)$wordsColor).hashCode());
        String $wordsFamily = this.getWordsFamily();
        result = result * 59 + ($wordsFamily == null ? 43 : $wordsFamily.hashCode());
        Map<EncodeHintType, Object> $encodeHints = this.getEncodeHints();
        result = result * 59 + ($encodeHints == null ? 43 : ((Object)$encodeHints).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfTemplateBarCodeConfig(type=" + this.getType() + ", scaleRate=" + this.getScaleRate() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", content=" + this.getContent() + ", codeMargin=" + this.getCodeMargin() + ", errorLevel=" + this.getErrorLevel() + ", onColor=" + this.getOnColor() + ", offColor=" + this.getOffColor() + ", words=" + this.getWords() + ", wordsColor=" + this.getWordsColor() + ", wordsFamily=" + this.getWordsFamily() + ", wordsStyle=" + this.getWordsStyle() + ", wordsSize=" + this.getWordsSize() + ", wordsOffsetX=" + this.getWordsOffsetX() + ", wordsOffsetY=" + this.getWordsOffsetY() + ", radians=" + this.getRadians() + ", encodeHints=" + this.getEncodeHints() + ")";
    }
}

