/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.doc.bookmark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.doc.bookmark.XEasyPdfTemplateBookmarkComponent;
import org.dromara.pdf.fop.doc.bookmark.XEasyPdfTemplateBookmarkParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XEasyPdfTemplateBookmark
implements XEasyPdfTemplateBookmarkComponent {
    private final XEasyPdfTemplateBookmarkParam param = new XEasyPdfTemplateBookmarkParam();

    public XEasyPdfTemplateBookmark setInitialCapacity(int initialCapacity) {
        this.param.setChildren(new ArrayList<XEasyPdfTemplateBookmark>(initialCapacity));
        return this;
    }

    public XEasyPdfTemplateBookmark setInternalDestination(String destination) {
        this.param.setInternalDestination(destination);
        return this;
    }

    public XEasyPdfTemplateBookmark setTitle(String title) {
        this.param.setTitle(title);
        return this;
    }

    public XEasyPdfTemplateBookmark setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public XEasyPdfTemplateBookmark setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public XEasyPdfTemplateBookmark setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public XEasyPdfTemplateBookmark setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public XEasyPdfTemplateBookmark setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public XEasyPdfTemplateBookmark setFontColor(String color) {
        this.param.setFontColor(color);
        return this;
    }

    public XEasyPdfTemplateBookmark setStartingState(String state) {
        this.param.setStartingState(state);
        return this;
    }

    public XEasyPdfTemplateBookmark addChild(XEasyPdfTemplateBookmark ... bookmarks) {
        Optional.ofNullable(bookmarks).ifPresent(v -> Collections.addAll(this.param.getChildren(), v));
        return this;
    }

    public XEasyPdfTemplateBookmark addChild(List<XEasyPdfTemplateBookmark> bookmarks) {
        Optional.ofNullable(bookmarks).ifPresent(this.param.getChildren()::addAll);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element bookmark = document.createElement("fo:bookmark");
        Optional.ofNullable(this.param.getInternalDestination()).ifPresent(v -> bookmark.setAttribute("internal-destination", v.intern()));
        Optional.ofNullable(this.param.getTitle()).ifPresent(v -> bookmark.appendChild(this.createTitle(document)));
        Optional.ofNullable(this.param.getStartingState()).ifPresent(v -> bookmark.setAttribute("starting-state", v.intern()));
        Optional.ofNullable(this.param.getChildren()).ifPresent(v -> v.forEach(e -> bookmark.appendChild(e.createElement(document))));
        return bookmark;
    }

    private Element createTitle(Document document) {
        Element title = document.createElement("fo:bookmark-title");
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> title.setAttribute("font-family", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> title.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> title.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> title.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> title.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontColor()).ifPresent(v -> title.setAttribute("color", v.intern().toLowerCase()));
        title.setTextContent(this.param.getTitle());
        return title;
    }
}

