/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.doc.component.link;

import java.util.Optional;
import org.dromara.pdf.fop.doc.component.XEasyPdfTemplateComponent;
import org.dromara.pdf.fop.doc.component.link.XEasyPdfTemplateLinkParam;
import org.dromara.pdf.fop.doc.component.text.XEasyPdfTemplateText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XEasyPdfTemplateLink
implements XEasyPdfTemplateComponent {
    private final XEasyPdfTemplateLinkParam param = new XEasyPdfTemplateLinkParam();

    public XEasyPdfTemplateLink setId(String id) {
        this.param.setId(id);
        return this;
    }

    public XEasyPdfTemplateLink setText(XEasyPdfTemplateText text) {
        this.param.setComponent(text);
        return this;
    }

    public XEasyPdfTemplateLink setInternalDestination(String destination) {
        this.param.setInternalDestination(destination);
        return this;
    }

    public XEasyPdfTemplateLink setExternalDestination(String destination) {
        this.param.setExternalDestination(destination);
        return this;
    }

    public XEasyPdfTemplateLink setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public XEasyPdfTemplateLink setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public XEasyPdfTemplateLink enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public XEasyPdfTemplateLink enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public XEasyPdfTemplateLink enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element block = this.createBlockElement(document, this.param);
        block.appendChild(this.createLink(document));
        return block;
    }

    private Element createLink(Document document) {
        Element link = document.createElement("fo:basic-link");
        Optional.ofNullable(this.param.getInternalDestination()).ifPresent(v -> link.setAttribute("internal-destination", v.intern()));
        Optional.ofNullable(this.param.getExternalDestination()).ifPresent(v -> link.setAttribute("external-destination", v.intern()));
        Optional.ofNullable(this.param.getComponent()).ifPresent(v -> link.appendChild(v.createElement(document)));
        return link;
    }
}

