/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.doc.component.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.doc.component.text.XEasyPdfTemplateText;
import org.dromara.pdf.fop.doc.component.text.XEasyPdfTemplateTextBase;
import org.dromara.pdf.fop.doc.component.text.XEasyPdfTemplateTextExtendParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XEasyPdfTemplateTextExtend
extends XEasyPdfTemplateTextBase {
    private final XEasyPdfTemplateTextExtendParam param = new XEasyPdfTemplateTextExtendParam();

    private XEasyPdfTemplateTextExtend setInitialCapacity(int initialCapacity) {
        this.param.setTextList(new ArrayList<XEasyPdfTemplateText>(initialCapacity));
        return this;
    }

    public XEasyPdfTemplateTextExtend setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public XEasyPdfTemplateTextExtend setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public XEasyPdfTemplateTextExtend setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public XEasyPdfTemplateTextExtend setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public XEasyPdfTemplateTextExtend setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public XEasyPdfTemplateTextExtend setId(String id) {
        this.param.setId(id);
        return this;
    }

    public XEasyPdfTemplateTextExtend setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public XEasyPdfTemplateTextExtend setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public XEasyPdfTemplateTextExtend setLetterSpacing(String letterSpacing) {
        this.param.setLetterSpacing(letterSpacing);
        return this;
    }

    public XEasyPdfTemplateTextExtend setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public XEasyPdfTemplateTextExtend setTextIndent(String indent) {
        this.param.setTextIndent(indent);
        return this;
    }

    public XEasyPdfTemplateTextExtend setStartIndent(String indent) {
        this.param.setStartIndent(indent);
        return this;
    }

    public XEasyPdfTemplateTextExtend setEndIndent(String indent) {
        this.param.setEndIndent(indent);
        return this;
    }

    public XEasyPdfTemplateTextExtend setSpaceBefore(String space) {
        this.param.setSpaceBefore(space);
        return this;
    }

    public XEasyPdfTemplateTextExtend setSpaceAfter(String space) {
        this.param.setSpaceAfter(space);
        return this;
    }

    public XEasyPdfTemplateTextExtend setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public XEasyPdfTemplateTextExtend setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public XEasyPdfTemplateTextExtend setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public XEasyPdfTemplateTextExtend setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public XEasyPdfTemplateTextExtend setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public XEasyPdfTemplateTextExtend setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public XEasyPdfTemplateTextExtend setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public XEasyPdfTemplateTextExtend setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public XEasyPdfTemplateTextExtend setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public XEasyPdfTemplateTextExtend setTextSpacing(String spacing) {
        this.param.setTextSpacing(spacing);
        return this;
    }

    public XEasyPdfTemplateTextExtend setBackgroundColor(String color) {
        this.param.setBackgroundColor(color);
        return this;
    }

    public XEasyPdfTemplateTextExtend enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public XEasyPdfTemplateTextExtend enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public XEasyPdfTemplateTextExtend enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public XEasyPdfTemplateTextExtend enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplateTextExtend addText(XEasyPdfTemplateText ... texts) {
        Optional.ofNullable(texts).ifPresent(v -> Collections.addAll(this.param.getTextList(), v));
        return this;
    }

    public XEasyPdfTemplateTextExtend addText(List<XEasyPdfTemplateText> texts) {
        Optional.ofNullable(texts).ifPresent(this.param.getTextList()::addAll);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        if (this.param.getTextList() == null) {
            return null;
        }
        Element block = this.initBlock(document, this.param);
        List<XEasyPdfTemplateText> textList = this.param.getTextList();
        int lastIndex = textList.size() - 1;
        int size = textList.size();
        for (int i = 0; i < size; ++i) {
            int index = i;
            Optional.ofNullable(textList.get(i).init(this.param).createElement(document)).ifPresent(e -> {
                block.appendChild(e.getFirstChild());
                if (index < lastIndex) {
                    Optional.ofNullable(this.param.getTextSpacing()).ifPresent(l -> {
                        Element leader = document.createElement("fo:leader");
                        leader.setAttribute("leader-length", l.intern().toLowerCase());
                        block.appendChild(leader);
                    });
                }
            });
        }
        return block;
    }
}

