/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.datasource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collections;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dromara.pdf.fop.core.datasource.AbstractDataSource;
import org.dromara.pdf.fop.core.doc.DocumentComponent;

public class DocumentDataSource
extends AbstractDataSource {
    private DocumentComponent document;

    public DocumentDataSource() {
        this.templateData = Collections.singletonMap("", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected InputStream processTemplate() {
        if (this.document == null) {
            throw new IllegalArgumentException("the document can not be null");
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.document.getDocument()), new StreamResult(outputStream));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
            return bufferedInputStream;
        }
    }

    public DocumentDataSource setDocument(DocumentComponent document) {
        this.document = document;
        return this;
    }
}

