/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.dromara.pdf.fop.core.datasource.DataSource;

public class XMLDataSource
implements DataSource {
    private String templatePath;
    private String xmlPath;
    private InputStream xmlInputStream;

    @Override
    public Reader getSourceReader() {
        if (this.isNotEmptyData()) {
            try {
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xmlPath);
                this.xmlInputStream = inputStream != null ? inputStream : Files.newInputStream(Paths.get(this.xmlPath, new String[0]), new OpenOption[0]);
                return new InputStreamReader(this.xmlInputStream, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("the xml can not be loaded\uff0cthe path['" + this.xmlPath + "'] is error");
            }
        }
        return null;
    }

    @Override
    public void transform(FopFactory fopFactory, FOUserAgent foAgent, OutputStream outputStream) {
        this.domTransform(fopFactory, foAgent, this.templatePath, outputStream);
        Optional.ofNullable(this.xmlInputStream).ifPresent(v -> {
            try {
                v.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getDocumentContent() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isNotEmptyData() {
        return this.xmlPath != null && this.xmlPath.length() > 0 || this.xmlInputStream != null;
    }

    public XMLDataSource setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
        return this;
    }

    public XMLDataSource setXmlPath(String xmlPath) {
        this.xmlPath = xmlPath;
        return this;
    }

    public XMLDataSource setXmlInputStream(InputStream xmlInputStream) {
        this.xmlInputStream = xmlInputStream;
        return this;
    }
}

