/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dromara.pdf.fop.core.base.Template;
import org.dromara.pdf.fop.core.doc.DocumentComponent;
import org.dromara.pdf.fop.core.doc.DocumentParam;
import org.dromara.pdf.fop.core.doc.bookmark.BookmarkComponent;
import org.dromara.pdf.fop.core.doc.page.PageComponent;
import org.dromara.pdf.fop.handler.TemplateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Document
implements DocumentComponent {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    private final DocumentParam param = new DocumentParam();

    public Document setConfigPath(String configPath) {
        this.param.setConfigPath(configPath);
        return this;
    }

    public Document setTitle(String title) {
        this.param.setTitle(title);
        return this;
    }

    public Document setAuthor(String author) {
        this.param.setAuthor(author);
        return this;
    }

    public Document setSubject(String subject) {
        this.param.setSubject(subject);
        return this;
    }

    public Document setKeywords(String keywords) {
        this.param.setKeywords(keywords);
        return this;
    }

    public Document setCreator(String creator) {
        this.param.setCreator(creator);
        return this;
    }

    public Document setCreationDate(Date date) {
        this.param.setCreationDate(date);
        return this;
    }

    public Document addPage(PageComponent ... pages) {
        Optional.ofNullable(pages).ifPresent(v -> Collections.addAll(this.param.getPageList(), v));
        return this;
    }

    public Document addBookmark(BookmarkComponent ... bookmarks) {
        Optional.ofNullable(bookmarks).ifPresent(v -> Collections.addAll(this.param.getBookmarkList(), v));
        return this;
    }

    public Document addBookmark(List<BookmarkComponent> bookmarks) {
        Optional.ofNullable(bookmarks).ifPresent(this.param.getBookmarkList()::addAll);
        return this;
    }

    public void save(String path) {
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            this.save(outputStream);
        }
    }

    public void save(OutputStream outputStream) {
        String content = this.getContent();
        if (log.isInfoEnabled()) {
            log.info("XSL-FO ==> \n" + content);
        }
        outputStream.write(content.getBytes());
    }

    public org.dromara.pdf.pdfbox.core.base.Document transform() {
        return this.initTemplate().transform();
    }

    @Override
    public void transform(OutputStream outputStream) {
        this.initTemplate().transform(outputStream);
    }

    @Override
    public org.w3c.dom.Document getDocument() {
        org.w3c.dom.Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/dromara/pdf/fop/template.fo"));
        this.addPage(document);
        return document;
    }

    public String getContent() {
        return TemplateHandler.DataSource.Document.build().setDocument(this).getDocumentContent();
    }

    private Template initTemplate() {
        return TemplateHandler.Template.build().setConfigPath(this.param.getConfigPath()).setTitle(this.param.getTitle()).setAuthor(this.param.getAuthor()).setSubject(this.param.getSubject()).setKeywords(this.param.getKeywords()).setCreator(this.param.getCreator()).setCreationDate(this.param.getCreationDate()).setDataSource(TemplateHandler.DataSource.Document.build().setDocument(this));
    }

    private void addPage(org.w3c.dom.Document document) {
        Element root = document.getDocumentElement();
        int index = 0;
        List<PageComponent> pageList = this.param.getPageList();
        for (PageComponent page : pageList) {
            root.appendChild(page.createElement(++index, document, this.createBookmark(document, index)));
        }
    }

    private Element createBookmark(org.w3c.dom.Document document, int index) {
        if (index > 1) {
            return null;
        }
        if (!this.param.getBookmarkList().isEmpty()) {
            Element tree = document.createElement("fo:bookmark-tree");
            this.param.getBookmarkList().forEach(v -> tree.appendChild(v.createElement(document)));
            return tree;
        }
        return null;
    }
}

