/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.table.TableRow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableBody {
    private List<TableRow> rows = new ArrayList<TableRow>(10);
    private String minColumnWidth;
    private String minRowHeight;

    private TableBody setInitialCapacity(int initialCapacity) {
        this.rows = new ArrayList<TableRow>(initialCapacity);
        return this;
    }

    public TableBody setMinRowHeight(String minRowHeight) {
        if (this.minRowHeight == null) {
            this.minRowHeight = minRowHeight;
        }
        return this;
    }

    public TableBody setMinColumnWidth(String minColumnWidth) {
        if (this.minColumnWidth == null) {
            this.minColumnWidth = minColumnWidth;
        }
        return this;
    }

    public TableBody addRow(TableRow ... rows) {
        Optional.ofNullable(rows).ifPresent(v -> Collections.addAll(this.rows, v));
        return this;
    }

    public TableBody addRow(List<TableRow> rows) {
        Optional.ofNullable(rows).ifPresent(this.rows::addAll);
        return this;
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public Element createElement(Document document) {
        Element tableBody = document.createElement("fo:table-body");
        for (TableRow row : this.rows) {
            tableBody.appendChild(row.setMinColumnWidth(this.minColumnWidth).setMinRowHeight(this.minRowHeight).createElement(document));
        }
        return tableBody;
    }
}

