/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.text;

import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.text.TextBase;
import org.dromara.pdf.fop.core.doc.component.text.TextBaseParam;
import org.dromara.pdf.fop.core.doc.component.text.TextParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Text
extends TextBase {
    private final TextParam param = new TextParam();

    public Text setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public Text setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public Text setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public Text setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public Text setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public Text setPadding(String padding) {
        this.param.setPadding(padding);
        return this;
    }

    public Text setPaddingTop(String paddingTop) {
        this.param.setPaddingTop(paddingTop);
        return this;
    }

    public Text setPaddingBottom(String paddingBottom) {
        this.param.setPaddingBottom(paddingBottom);
        return this;
    }

    public Text setPaddingLeft(String paddingLeft) {
        this.param.setPaddingLeft(paddingLeft);
        return this;
    }

    public Text setPaddingRight(String paddingRight) {
        this.param.setPaddingRight(paddingRight);
        return this;
    }

    public Text setId(String id) {
        this.param.setId(id);
        return this;
    }

    public Text setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public Text setText(String text) {
        this.param.setText(text);
        return this;
    }

    public Text setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public Text setLetterSpacing(String spacing) {
        this.param.setLetterSpacing(spacing);
        return this;
    }

    public Text setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public Text setWhiteSpace(String whiteSpace) {
        this.param.setWhiteSpace(whiteSpace);
        return this;
    }

    public Text setWhiteSpaceCollapse(String whiteSpaceCollapse) {
        this.param.setWhiteSpaceCollapse(whiteSpaceCollapse);
        return this;
    }

    public Text setTextIndent(String indent) {
        this.param.setTextIndent(indent);
        return this;
    }

    public Text setStartIndent(String indent) {
        this.param.setStartIndent(indent);
        return this;
    }

    public Text setEndIndent(String indent) {
        this.param.setEndIndent(indent);
        return this;
    }

    public Text setSpaceBefore(String space) {
        this.param.setSpaceBefore(space);
        return this;
    }

    public Text setSpaceAfter(String space) {
        this.param.setSpaceAfter(space);
        return this;
    }

    public Text setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public Text setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public Text setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public Text setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public Text setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public Text setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public Text setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public Text setVerticalStyle(String style) {
        this.param.setVerticalAlign(style);
        return this;
    }

    public Text setLinkInternalDestination(String destination) {
        this.param.setLinkInternalDestination(destination);
        return this;
    }

    public Text setLinkExternalDestination(String destination) {
        this.param.setLinkExternalDestination(destination);
        return this;
    }

    public Text setDeleteLineColor(String color) {
        this.param.setDeleteLineColor(color);
        return this;
    }

    public Text setUnderLineColor(String color) {
        this.param.setUnderLineColor(color);
        return this;
    }

    public Text setUnderLineWidth(String width) {
        this.param.setUnderLineWidth(width);
        return this;
    }

    public Text setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public Text setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public Text setBackgroundColor(String color) {
        this.param.setBackgroundColor(color);
        return this;
    }

    public Text enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public Text enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public Text enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public Text enableLink() {
        this.param.setHasLink(Boolean.TRUE);
        return this;
    }

    public Text enableDeleteLine() {
        this.param.setHasDeleteLine(Boolean.TRUE);
        return this;
    }

    public Text enableUnderLine() {
        this.param.setHasUnderLine(Boolean.TRUE);
        return this;
    }

    public Text enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        if (this.param.getText() == null) {
            return null;
        }
        Element block = this.initBlock(document, this.param);
        if (this.param.getHasLink().booleanValue()) {
            Element link = this.createLink(document);
            link.appendChild(this.createInline(document));
            block.appendChild(link);
        } else {
            block.appendChild(this.createInline(document));
        }
        return block;
    }

    Text init(TextBaseParam param) {
        this.param.init(param);
        return this;
    }

    private Element createLink(Document document) {
        Element link = document.createElement("fo:basic-link");
        Optional.ofNullable(this.param.getLinkInternalDestination()).ifPresent(v -> link.setAttribute("internal-destination", v.intern()));
        Optional.ofNullable(this.param.getLinkExternalDestination()).ifPresent(v -> link.setAttribute("external-destination", v.intern()));
        return link;
    }

    private Element createInline(Document document) {
        Element inline = document.createElement("fo:inline");
        Optional.ofNullable(this.param.getPadding()).ifPresent(v -> inline.setAttribute("padding", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPaddingTop()).ifPresent(v -> inline.setAttribute("padding-top", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPaddingBottom()).ifPresent(v -> inline.setAttribute("padding-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPaddingLeft()).ifPresent(v -> inline.setAttribute("padding-left", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPaddingRight()).ifPresent(v -> inline.setAttribute("padding-right", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getTextIndent()).ifPresent(v -> inline.setAttribute("text-indent", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLanguage()).ifPresent(v -> inline.setAttribute("language", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> inline.setAttribute("font-family", v.intern()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> inline.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> inline.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> inline.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> inline.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getColor()).ifPresent(v -> inline.setAttribute("color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getVerticalAlign()).ifPresent(v -> inline.setAttribute("vertical-align", v.intern().toLowerCase()));
        if (this.param.hasUnderLine.booleanValue()) {
            String borderBottom = Optional.ofNullable(this.param.getUnderLineWidth()).orElse("1pt") + " solid " + Optional.ofNullable(this.param.getUnderLineColor()).orElse("");
            inline.setAttribute("border-bottom", borderBottom.intern());
        }
        Optional.ofNullable(this.param.getBackgroundColor()).ifPresent(v -> inline.setAttribute("background-color", v.intern().toLowerCase()));
        inline.setTextContent(this.param.getText());
        return inline;
    }
}

