/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.page;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.Component;
import org.dromara.pdf.fop.core.doc.page.PageComponent;
import org.dromara.pdf.fop.core.doc.page.PageParam;
import org.dromara.pdf.fop.core.doc.page.RegionBaseParam;
import org.dromara.pdf.fop.core.doc.watermark.WatermarkComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Page
implements PageComponent {
    private final PageParam param = new PageParam();

    public Page setWidth(String width) {
        Optional.ofNullable(width).ifPresent(this.param::setWidth);
        return this;
    }

    public Page setHeight(String height) {
        Optional.ofNullable(height).ifPresent(this.param::setHeight);
        return this;
    }

    public Page setMargin(String margin) {
        this.param.setMarginTop(margin).setMarginBottom(margin).setMarginLeft(margin).setMarginRight(margin);
        return this;
    }

    public Page setMarginTop(String margin) {
        this.param.setMarginTop(margin);
        return this;
    }

    public Page setMarginBottom(String margin) {
        this.param.setMarginBottom(margin);
        return this;
    }

    public Page setMarginLeft(String margin) {
        this.param.setMarginLeft(margin);
        return this;
    }

    public Page setMarginRight(String margin) {
        this.param.setMarginRight(margin);
        return this;
    }

    public Page setBodyMargin(String margin) {
        this.param.getRegionBodyParam().setMarginTop(margin).setMarginBottom(margin).setMarginLeft(margin).setMarginRight(margin);
        return this;
    }

    public Page setBodyMarginTop(String margin) {
        this.param.getRegionBodyParam().setMarginTop(margin);
        return this;
    }

    public Page setBodyMarginBottom(String margin) {
        this.param.getRegionBodyParam().setMarginBottom(margin);
        return this;
    }

    public Page setBodyMarginLeft(String margin) {
        this.param.getRegionBodyParam().setMarginLeft(margin);
        return this;
    }

    public Page setBodyMarginRight(String margin) {
        this.param.getRegionBodyParam().setMarginRight(margin);
        return this;
    }

    public Page setStartWidth(String width) {
        this.param.getRegionStartParam().setWidth(width);
        return this;
    }

    public Page setEndWidth(String width) {
        this.param.getRegionEndParam().setWidth(width);
        return this;
    }

    public Page setHeaderHeight(String height) {
        this.param.getRegionBeforeParam().setHeight(height);
        return this;
    }

    public Page setFooterHeight(String height) {
        this.param.getRegionAfterParam().setHeight(height);
        return this;
    }

    public Page setId(String id) {
        this.param.setId(id);
        return this;
    }

    public Page setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public Page setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public Page setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public Page setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public Page setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public Page setFontColor(String color) {
        this.param.setFontColor(color);
        return this;
    }

    public Page setBodyBackground(String background) {
        this.param.getRegionBodyParam().setBackground(background);
        return this;
    }

    public Page setBodyBackgroundImage(String image) {
        this.param.getRegionBodyParam().setBackgroundImage(image);
        return this;
    }

    public Page setBodyBackgroundImageWidth(String width) {
        this.param.getRegionBodyParam().setBackgroundImageWidth(width);
        return this;
    }

    public Page setBodyBackgroundImageHeight(String height) {
        this.param.getRegionBodyParam().setBackgroundImageHeight(height);
        return this;
    }

    public Page setBodyBackgroundAttachment(String attachment) {
        this.param.getRegionBodyParam().setBackgroundAttachment(attachment);
        return this;
    }

    public Page setBodyBackgroundColor(String color) {
        this.param.getRegionBodyParam().setBackgroundColor(color);
        return this;
    }

    public Page setBodyBackgroundPosition(String position) {
        this.param.getRegionBodyParam().setBackgroundPosition(position);
        return this;
    }

    public Page setBodyBackgroundHorizontalPosition(String position) {
        this.param.getRegionBodyParam().setBackgroundPositionHorizontal(position);
        return this;
    }

    public Page setBodyBackgroundVerticalPosition(String position) {
        this.param.getRegionBodyParam().setBackgroundPositionVertical(position);
        return this;
    }

    public Page setBodyBackgroundRepeat(String repeat) {
        this.param.getRegionBodyParam().setBackgroundRepeat(repeat);
        return this;
    }

    public Page setBodyWatermark(WatermarkComponent watermark) {
        this.param.getRegionBodyParam().setWatermark(watermark);
        return this;
    }

    public Page setStartBackground(String background) {
        this.param.getRegionStartParam().setBackground(background);
        return this;
    }

    public Page setStartBackgroundImage(String image) {
        this.param.getRegionStartParam().setBackgroundImage(image);
        return this;
    }

    public Page setStartBackgroundImageWidth(String width) {
        this.param.getRegionStartParam().setBackgroundImageWidth(width);
        return this;
    }

    public Page setStartBackgroundImageHeight(String height) {
        this.param.getRegionStartParam().setBackgroundImageHeight(height);
        return this;
    }

    public Page setStartBackgroundAttachment(String attachment) {
        this.param.getRegionStartParam().setBackgroundAttachment(attachment);
        return this;
    }

    public Page setStartBackgroundColor(String color) {
        this.param.getRegionStartParam().setBackgroundColor(color);
        return this;
    }

    public Page setStartBackgroundPosition(String position) {
        this.param.getRegionStartParam().setBackgroundPosition(position);
        return this;
    }

    public Page setStartBackgroundHorizontalPosition(String position) {
        this.param.getRegionStartParam().setBackgroundPositionHorizontal(position);
        return this;
    }

    public Page setStartBackgroundVerticalPosition(String position) {
        this.param.getRegionStartParam().setBackgroundPositionVertical(position);
        return this;
    }

    public Page setStartBackgroundRepeat(String repeat) {
        this.param.getRegionStartParam().setBackgroundRepeat(repeat);
        return this;
    }

    public Page setStartWatermark(WatermarkComponent watermark) {
        this.param.getRegionStartParam().setWatermark(watermark);
        return this;
    }

    public Page setEndBackground(String background) {
        this.param.getRegionEndParam().setBackground(background);
        return this;
    }

    public Page setEndBackgroundImage(String image) {
        this.param.getRegionEndParam().setBackgroundImage(image);
        return this;
    }

    public Page setEndBackgroundImageWidth(String width) {
        this.param.getRegionEndParam().setBackgroundImageWidth(width);
        return this;
    }

    public Page setEndBackgroundImageHeight(String height) {
        this.param.getRegionEndParam().setBackgroundImageHeight(height);
        return this;
    }

    public Page setEndBackgroundAttachment(String attachment) {
        this.param.getRegionEndParam().setBackgroundAttachment(attachment);
        return this;
    }

    public Page setEndBackgroundColor(String color) {
        this.param.getRegionEndParam().setBackgroundColor(color);
        return this;
    }

    public Page setEndBackgroundPosition(String position) {
        this.param.getRegionEndParam().setBackgroundPosition(position);
        return this;
    }

    public Page setEndBackgroundHorizontalPosition(String position) {
        this.param.getRegionEndParam().setBackgroundPositionHorizontal(position);
        return this;
    }

    public Page setEndBackgroundVerticalPosition(String position) {
        this.param.getRegionEndParam().setBackgroundPositionVertical(position);
        return this;
    }

    public Page setEndBackgroundRepeat(String repeat) {
        this.param.getRegionEndParam().setBackgroundRepeat(repeat);
        return this;
    }

    public Page setEndWatermark(WatermarkComponent watermark) {
        this.param.getRegionEndParam().setWatermark(watermark);
        return this;
    }

    public Page setHeaderBackground(String background) {
        this.param.getRegionBeforeParam().setBackground(background);
        return this;
    }

    public Page setHeaderBackgroundImage(String image) {
        this.param.getRegionBeforeParam().setBackgroundImage(image);
        return this;
    }

    public Page setHeaderBackgroundAttachment(String attachment) {
        this.param.getRegionBeforeParam().setBackgroundAttachment(attachment);
        return this;
    }

    public Page setHeaderBackgroundColor(String color) {
        this.param.getRegionBeforeParam().setBackgroundColor(color);
        return this;
    }

    public Page setHeaderBackgroundPosition(String position) {
        this.param.getRegionBeforeParam().setBackgroundPosition(position);
        return this;
    }

    public Page setHeaderBackgroundHorizontalPosition(String position) {
        this.param.getRegionBeforeParam().setBackgroundPositionHorizontal(position);
        return this;
    }

    public Page setHeaderBackgroundVerticalPosition(String position) {
        this.param.getRegionBeforeParam().setBackgroundPositionVertical(position);
        return this;
    }

    public Page setHeaderBackgroundRepeat(String repeat) {
        this.param.getRegionBeforeParam().setBackgroundRepeat(repeat);
        return this;
    }

    public Page setHeaderWatermark(WatermarkComponent watermark) {
        this.param.getRegionBeforeParam().setWatermark(watermark);
        return this;
    }

    public Page setFooterBackground(String background) {
        this.param.getRegionAfterParam().setBackground(background);
        return this;
    }

    public Page setFooterBackgroundImage(String image) {
        this.param.getRegionAfterParam().setBackgroundImage(image);
        return this;
    }

    public Page setFooterBackgroundAttachment(String attachment) {
        this.param.getRegionAfterParam().setBackgroundAttachment(attachment);
        return this;
    }

    public Page setFooterBackgroundColor(String color) {
        this.param.getRegionAfterParam().setBackgroundColor(color);
        return this;
    }

    public Page setFooterBackgroundPosition(String position) {
        this.param.getRegionAfterParam().setBackgroundPosition(position);
        return this;
    }

    public Page setFooterBackgroundHorizontalPosition(String position) {
        this.param.getRegionAfterParam().setBackgroundPositionHorizontal(position);
        return this;
    }

    public Page setFooterBackgroundVerticalPosition(String position) {
        this.param.getRegionAfterParam().setBackgroundPositionVertical(position);
        return this;
    }

    public Page setFooterBackgroundRepeat(String repeat) {
        this.param.getRegionAfterParam().setBackgroundRepeat(repeat);
        return this;
    }

    public Page setFooterWatermark(WatermarkComponent watermark) {
        this.param.getRegionAfterParam().setWatermark(watermark);
        return this;
    }

    public Page changeLandscape() {
        this.param.changeLandscape();
        return this;
    }

    public Page addBodyComponent(Component ... components) {
        Optional.ofNullable(components).ifPresent(v -> Collections.addAll(this.param.getRegionBodyParam().getComponents(), v));
        return this;
    }

    public Page addBodyComponent(List<Component> components) {
        Optional.ofNullable(components).ifPresent(this.param.getRegionBodyParam().getComponents()::addAll);
        return this;
    }

    public Page addHeaderComponent(Component ... components) {
        Optional.ofNullable(components).ifPresent(v -> Collections.addAll(this.param.getRegionBeforeParam().getComponents(), v));
        return this;
    }

    public Page addHeaderComponent(List<Component> components) {
        Optional.ofNullable(components).ifPresent(this.param.getRegionBeforeParam().getComponents()::addAll);
        return this;
    }

    public Page addFooterComponent(Component ... components) {
        Optional.ofNullable(components).ifPresent(v -> Collections.addAll(this.param.getRegionAfterParam().getComponents(), v));
        return this;
    }

    public Page addFooterComponent(List<Component> components) {
        Optional.ofNullable(components).ifPresent(this.param.getRegionAfterParam().getComponents()::addAll);
        return this;
    }

    @Override
    public Element createElement(int index, Document document, Element bookmark) {
        Element root = document.getDocumentElement();
        String masterName = this.addLayoutMasterSet(index, document, root);
        Optional.ofNullable(bookmark).ifPresent(root::appendChild);
        return this.addPageSequence(document, masterName);
    }

    private String addLayoutMasterSet(int index, Document document, Element root) {
        String masterName = "page" + index;
        Node layoutMasterSet = root.getElementsByTagName("fo:layout-master-set").item(0);
        layoutMasterSet.appendChild(this.createSimplePageMaster(document, masterName));
        return masterName;
    }

    private Element createSimplePageMaster(Document document, String masterName) {
        Element simplePageMaster = document.createElement("fo:simple-page-master");
        simplePageMaster.setAttribute("master-name", masterName);
        Optional.ofNullable(this.param.getWidth()).ifPresent(v -> simplePageMaster.setAttribute("page-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getHeight()).ifPresent(v -> simplePageMaster.setAttribute("page-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getMarginTop()).ifPresent(v -> simplePageMaster.setAttribute("margin-top", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getMarginBottom()).ifPresent(v -> simplePageMaster.setAttribute("margin-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getMarginLeft()).ifPresent(v -> simplePageMaster.setAttribute("margin-left", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getMarginRight()).ifPresent(v -> simplePageMaster.setAttribute("margin-right", v.intern().toLowerCase()));
        simplePageMaster.appendChild(this.createRegionBody(document));
        simplePageMaster.appendChild(this.createRegionBefore(document));
        simplePageMaster.appendChild(this.createRegionAfter(document));
        simplePageMaster.appendChild(this.createRegionStart(document));
        simplePageMaster.appendChild(this.createRegionEnd(document));
        return simplePageMaster;
    }

    private Element createRegionBody(Document document) {
        Element regionBody = document.createElement("fo:region-body");
        Optional.ofNullable(this.param.getRegionBodyParam().getMarginTop()).ifPresent(v -> regionBody.setAttribute("margin-top", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getRegionBodyParam().getMarginBottom()).ifPresent(v -> regionBody.setAttribute("margin-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getRegionBodyParam().getMarginLeft()).ifPresent(v -> regionBody.setAttribute("margin-left", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getRegionBodyParam().getMarginRight()).ifPresent(v -> regionBody.setAttribute("margin-right", v.intern().toLowerCase()));
        this.initRegion(document, regionBody, this.param.getRegionBodyParam());
        return regionBody;
    }

    private Element createRegionStart(Document document) {
        Element regionStart = document.createElement("fo:region-start");
        Optional.ofNullable(this.param.getRegionStartParam().getWidth()).ifPresent(v -> regionStart.setAttribute("extent", v.intern().toLowerCase()));
        this.initRegion(document, regionStart, this.param.getRegionStartParam());
        return regionStart;
    }

    private Element createRegionEnd(Document document) {
        Element regionEnd = document.createElement("fo:region-end");
        Optional.ofNullable(this.param.getRegionEndParam().getWidth()).ifPresent(v -> regionEnd.setAttribute("extent", v.intern().toLowerCase()));
        this.initRegion(document, regionEnd, this.param.getRegionEndParam());
        return regionEnd;
    }

    private Element createRegionBefore(Document document) {
        Element regionBefore = document.createElement("fo:region-before");
        Optional.ofNullable(this.param.getRegionBeforeParam().getHeight()).ifPresent(v -> regionBefore.setAttribute("extent", v.intern().toLowerCase()));
        this.initRegion(document, regionBefore, this.param.getRegionBeforeParam());
        return regionBefore;
    }

    private Element createRegionAfter(Document document) {
        Element regionAfter = document.createElement("fo:region-after");
        Optional.ofNullable(this.param.getRegionAfterParam().getHeight()).ifPresent(v -> regionAfter.setAttribute("extent", v.intern().toLowerCase()));
        this.initRegion(document, regionAfter, this.param.getRegionAfterParam());
        return regionAfter;
    }

    private void initRegion(Document document, Element region, RegionBaseParam param) {
        Optional.ofNullable(param.getBackgroundColor()).ifPresent(v -> region.setAttribute("background-color", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBackground()).ifPresent(v -> region.setAttribute("background", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBackgroundImage()).ifPresent(v -> region.setAttribute("background-image", v.intern()));
        Optional.ofNullable(param.getBackgroundImageWidth()).ifPresent(v -> region.setAttribute("fox:background-image-width", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBackgroundImageHeight()).ifPresent(v -> region.setAttribute("fox:background-image-height", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBackgroundAttachment()).ifPresent(v -> region.setAttribute("background-attachment", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBackgroundPosition()).ifPresent(v -> region.setAttribute("background-position", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBackgroundPositionHorizontal()).ifPresent(v -> region.setAttribute("background-position-horizontal", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBackgroundPositionVertical()).ifPresent(v -> region.setAttribute("background-position-vertical", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBackgroundRepeat()).ifPresent(v -> region.setAttribute("background-repeat", v.intern().toLowerCase()));
        Optional.ofNullable(param.getWatermark()).ifPresent(v -> v.createWatermark(document, region));
    }

    private Element addPageSequence(Document document, String masterName) {
        Element pageSequence = document.createElement("fo:page-sequence");
        pageSequence.setAttribute("master-reference", masterName);
        Optional.ofNullable(this.param.getId()).ifPresent(v -> pageSequence.setAttribute("id", v.intern()));
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> pageSequence.setAttribute("font-family", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> pageSequence.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> pageSequence.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> pageSequence.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> pageSequence.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontColor()).ifPresent(v -> pageSequence.setAttribute("color", v.intern().toLowerCase()));
        if (this.param.hasHeader()) {
            pageSequence.appendChild(this.addRegionBefore(document));
        }
        if (this.param.hasFooter()) {
            pageSequence.appendChild(this.addRegionAfter(document));
        }
        pageSequence.appendChild(this.addRegionBody(document));
        return pageSequence;
    }

    private Element addRegionBody(Document document) {
        Element element = this.addRegion(document, "fo:flow", "xsl-region-body", this.param.getRegionBodyParam());
        if (!this.param.hasBody()) {
            element.appendChild(document.createElement("fo:block"));
        }
        return element;
    }

    private Element addRegionStart(Document document) {
        return this.addRegion(document, "fo:flow", "xsl-region-start", this.param.getRegionStartParam());
    }

    private Element addRegionEnd(Document document) {
        return this.addRegion(document, "fo:flow", "xsl-region-end", this.param.getRegionEndParam());
    }

    private Element addRegionBefore(Document document) {
        return this.addRegion(document, "fo:static-content", "xsl-region-before", this.param.getRegionBeforeParam());
    }

    private Element addRegionAfter(Document document) {
        return this.addRegion(document, "fo:static-content", "xsl-region-after", this.param.getRegionAfterParam());
    }

    private Element addRegion(Document document, String tagName, String flowName, RegionBaseParam param) {
        Element element = document.createElement(tagName);
        element.setAttribute("flow-name", flowName);
        param.getComponents().forEach(v -> element.appendChild(v.transform(document)));
        return element;
    }
}

