package org.dromara.pdf.fop.core.base;

/**
 * pdf模板属性
 *
 * @author xsx
 * @date 2022/8/27
 * @since 1.8
 * <p>
 * Copyright (c) 2020 xsx All Rights Reserved.
 * x-easypdf-fop is licensed under the Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 * </p>
 */
public class TemplateAttributes {
    /**
     * 页面名称
     */
    public static final String MASTER_NAME = "master-name";
    /**
     * 页面参考
     */
    public static final String MASTER_REFERENCE = "master-reference";
    /**
     * 页面初始页码
     */
    public static final String INITIAL_PAGE_NUMBER = "initial-page-number";
    /**
     * 强制页面计数
     */
    public static final String FORCE_PAGE_COUNT = "force-page-count";
    /**
     * 页面流向
     */
    public static final String FLOW_NAME = "flow-name";
    /**
     * 页面宽度
     */
    public static final String PAGE_WIDTH = "page-width";
    /**
     * 页面高度
     */
    public static final String PAGE_HEIGHT = "page-height";
    /**
     * 区域范围
     */
    public static final String EXTENT = "extent";
    /**
     * id
     */
    public static final String ID = "id";
    /**
     * 引用id
     */
    public static final String REF_ID = "ref-id";
    /**
     * 边距（上下左右）
     */
    public static final String MARGIN = "margin";
    /**
     * 上边距
     */
    public static final String MARGIN_TOP = "margin-top";
    /**
     * 下边距
     */
    public static final String MARGIN_BOTTOM = "margin-bottom";
    /**
     * 左边距
     */
    public static final String MARGIN_LEFT = "margin-left";
    /**
     * 右边距
     */
    public static final String MARGIN_RIGHT = "margin-right";
    /**
     * 填充（上下左右）
     */
    public static final String PADDING = "padding";
    /**
     * 上填充
     */
    public static final String PADDING_TOP = "padding-top";
    /**
     * 下填充
     */
    public static final String PADDING_BOTTOM = "padding-bottom";
    /**
     * 左填充
     */
    public static final String PADDING_LEFT = "padding-left";
    /**
     * 右填充
     */
    public static final String PADDING_RIGHT = "padding-right";
    /**
     * 宽度
     */
    public static final String WIDTH = "width";
    /**
     * 高度
     */
    public static final String HEIGHT = "height";
    /**
     * 文本对齐
     */
    public static final String TEXT_ALIGN = "text-align";
    /**
     * 垂直对齐
     */
    public static final String VERTICAL_ALIGN = "vertical-align";
    /**
     * 上下对齐
     */
    public static final String DISPLAY_ALIGN = "display-align";
    /**
     * 边框
     */
    public static final String BORDER = "border";
    /**
     * 边框样式
     */
    public static final String BORDER_STYLE = "border-style";
    /**
     * 边框颜色
     */
    public static final String BORDER_COLOR = "border-color";
    /**
     * 边框宽度
     */
    public static final String BORDER_WIDTH = "border-width";
    /**
     * 边框折叠
     */
    public static final String BORDER_COLLAPSE = "border-collapse";
    /**
     * 边框间距
     */
    public static final String BORDER_SPACING = "border-spacing";
    /**
     * 上边框
     */
    public static final String BORDER_TOP = "border-top";
    /**
     * 上边框样式
     */
    public static final String BORDER_TOP_STYLE = "border-top-style";
    /**
     * 上边框颜色
     */
    public static final String BORDER_TOP_COLOR = "border-top-color";
    /**
     * 上边框宽度
     */
    public static final String BORDER_TOP_WIDTH = "border-top-width";
    /**
     * 下边框
     */
    public static final String BORDER_BOTTOM = "border-bottom";
    /**
     * 下边框样式
     */
    public static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    /**
     * 下边框颜色
     */
    public static final String BORDER_BOTTOM_COLOR = "border-bottom-color";
    /**
     * 下边框宽度
     */
    public static final String BORDER_BOTTOM_WIDTH = "border-bottom-width";
    /**
     * 左边框
     */
    public static final String BORDER_LEFT = "border-left";
    /**
     * 左边框样式
     */
    public static final String BORDER_LEFT_STYLE = "border-left-style";
    /**
     * 左边框颜色
     */
    public static final String BORDER_LEFT_COLOR = "border-left-color";
    /**
     * 左边框宽度
     */
    public static final String BORDER_LEFT_WIDTH = "border-left-width";
    /**
     * 右边框
     */
    public static final String BORDER_RIGHT = "border-right";
    /**
     * 右边框样式
     */
    public static final String BORDER_RIGHT_STYLE = "border-right-style";
    /**
     * 右边框颜色
     */
    public static final String BORDER_RIGHT_COLOR = "border-right-color";
    /**
     * 右边框宽度
     */
    public static final String BORDER_RIGHT_WIDTH = "border-right-width";
    /**
     * 合并行
     */
    public static final String NUMBER_ROWS_SPANNED = "number-rows-spanned";
    /**
     * 合并列
     */
    public static final String NUMBER_COLUMNS_SPANNED = "number-columns-spanned";
    /**
     * 颜色
     */
    public static final String COLOR = "color";
    /**
     * 文本语言
     */
    public static final String LANGUAGE = "language";
    /**
     * 字体家族
     */
    public static final String FONT_FAMILY = "font-family";
    /**
     * 字体样式
     */
    public static final String FONT_STYLE = "font-style";
    /**
     * 字体大小
     */
    public static final String FONT_SIZE = "font-size";
    /**
     * 字体大小调整
     */
    public static final String FONT_SIZE_ADJUST = "font-size-adjust";
    /**
     * 字体重量
     */
    public static final String FONT_WEIGHT = "font-weight";
    /**
     * 行间距
     */
    public static final String LINE_HEIGHT = "line-height";
    /**
     * 字符间距
     */
    public static final String LETTER_SPACING = "letter-spacing";
    /**
     * 单词间距
     */
    public static final String WORD_SPACING = "word-spacing";
    /**
     * 空白空间
     */
    public static final String WHITE_SPACE = "white-space";
    /**
     * 空白空间折叠
     */
    public static final String WHITE_SPACE_COLLAPSE = "white-space-collapse";
    /**
     * 文本装饰
     */
    public static final String TEXT_DECORATION = "text-decoration";
    /**
     * 来源
     */
    public static final String SRC = "src";
    /**
     * 图像宽度
     */
    public static final String CONTENT_WIDTH = "content-width";
    /**
     * 图像高度
     */
    public static final String CONTENT_HEIGHT = "content-height";
    /**
     * 分割线样式
     */
    public static final String LEADER_PATTERN = "leader-pattern";
    /**
     * 分割线长度
     */
    public static final String LEADER_LENGTH = "leader-length";
    /**
     * 规则样式
     */
    public static final String RULE_STYLE = "rule-style";
    /**
     * 命名空间
     */
    public static final String NAMESPACE = "xmlns:fo";
    /**
     * 开始状态
     */
    public static final String STARTING_STATE = "starting-state";
    /**
     * 类型
     */
    public static final String TYPE = "type";
    /**
     * 内容
     */
    public static final String CONTENT = "content";
    /**
     * 条形码边距
     */
    public static final String CODE_MARGIN = "code-margin";
    /**
     * 纠错级别
     */
    public static final String ERROR_LEVEL = "error-level";
    /**
     * 文字
     */
    public static final String WORDS = "words";
    /**
     * 文字颜色
     */
    public static final String WORDS_COLOR = "words-color";
    /**
     * 文字名称
     */
    public static final String WORDS_FAMILY = "words-family";
    /**
     * 文字样式
     */
    public static final String WORDS_STYLE = "words-style";
    /**
     * 文字大小
     */
    public static final String WORDS_SIZE = "words-size";
    /**
     * 文字偏移量-X轴
     */
    public static final String WORDS_OFFSET_X = "words-offset-x";
    /**
     * 文字偏移量-Y轴
     */
    public static final String WORDS_OFFSET_Y = "words-offset-y";
    /**
     * 旋转弧度
     */
    public static final String RADIANS = "radians";
    /**
     * 前景色
     */
    public static final String ON_COLOR = "on-color";
    /**
     * 背景色
     */
    public static final String OFF_COLOR = "off-color";
    /**
     * 缩放比例
     */
    public static final String SCALE_RATE = "scale-rate";
    /**
     * 内部地址
     */
    public static final String INTERNAL_DESTINATION = "internal-destination";
    /**
     * 外部地址
     */
    public static final String EXTERNAL_DESTINATION = "external-destination";
    /**
     * 文本缩进
     */
    public static final String TEXT_INDENT = "text-indent";
    /**
     * 段前缩进
     */
    public static final String START_INDENT = "start-indent";
    /**
     * 段后缩进
     */
    public static final String END_INDENT = "end-indent";
    /**
     * 段前空白
     */
    public static final String SPACE_BEFORE = "space-before";
    /**
     * 段后空白
     */
    public static final String SPACE_AFTER = "space-after";
    /**
     * 表格样式
     */
    public static final String TABLE_LAYOUT = "table-layout";
    /**
     * 分页表头
     */
    public static final String TABLE_OMIT_HEADER_AT_BREAK = "table-omit-header-at-break";
    /**
     * 分页表尾
     */
    public static final String TABLE_OMIT_FOOTER_AT_BREAK = "table-omit-footer-at-break";
    /**
     * 分页符-前
     */
    public static final String BREAK_BEFORE = "break-before";
    /**
     * 分页符-后
     */
    public static final String BREAK_AFTER = "break-after";
    /**
     * 分页时保持一起
     * <p>auto：自动</p>
     * <p>always：总是</p>
     */
    public static final String KEEP_TOGETHER = "keep-together";
    /**
     * 分页时与上一个保持一起
     * <p>auto：自动</p>
     * <p>always：总是</p>
     */
    public static final String KEEP_WITH_PREVIOUS = "keep-with-previous";
    /**
     * 分页时与下一个保持一起
     * <p>auto：自动</p>
     * <p>always：总是</p>
     */
    public static final String KEEP_WITH_NEXT = "keep-with-next";
    /**
     * 背景
     */
    public static final String BACKGROUND = "background";
    /**
     * 背景图片
     */
    public static final String BACKGROUND_IMAGE = "background-image";
    /**
     * 背景图片宽度
     */
    public static final String BACKGROUND_IMAGE_WIDTH = "fox:background-image-width";
    /**
     * 背景图片高度
     */
    public static final String BACKGROUND_IMAGE_HEIGHT = "fox:background-image-height";
    /**
     * 背景附件
     * <p>scroll：滚动</p>
     * <p>fixed：固定</p>
     */
    public static final String BACKGROUND_ATTACHMENT = "background-attachment";
    /**
     * 背景颜色
     * <p>color：颜色（名称或16进制颜色）</p>
     * <p>transparent：透明</p>
     */
    public static final String BACKGROUND_COLOR = "background-color";
    /**
     * 背景图片定位
     * <p>第一个参数为X轴</p>
     * <p>第二个参数为Y轴</p>
     */
    public static final String BACKGROUND_POSITION = "background-position";
    /**
     * 背景图片水平定位
     */
    public static final String BACKGROUND_POSITION_HORIZONTAL = "background-position-horizontal";
    /**
     * 背景图片垂直定位
     */
    public static final String BACKGROUND_POSITION_VERTICAL = "background-position-vertical";
    /**
     * 背景图片重复
     * <p>repeat：水平垂直重复</p>
     * <p>repeat-x：水平重复</p>
     * <p>repeat-y：垂直重复</p>
     * <p>no-repeat：不重复</p>
     */
    public static final String BACKGROUND_REPEAT = "background-repeat";
}
