/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.bookmark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.core.doc.bookmark.BookmarkComponent;
import org.dromara.pdf.fop.core.doc.bookmark.BookmarkParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Bookmark
implements BookmarkComponent {
    private final BookmarkParam param = new BookmarkParam();

    public Bookmark setInitialCapacity(int initialCapacity) {
        this.param.setChildren(new ArrayList<Bookmark>(initialCapacity));
        return this;
    }

    public Bookmark setInternalDestination(String destination) {
        this.param.setInternalDestination(destination);
        return this;
    }

    public Bookmark setTitle(String title) {
        this.param.setTitle(title);
        return this;
    }

    public Bookmark setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public Bookmark setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public Bookmark setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public Bookmark setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public Bookmark setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public Bookmark setFontColor(String color) {
        this.param.setFontColor(color);
        return this;
    }

    public Bookmark setStartingState(String state) {
        this.param.setStartingState(state);
        return this;
    }

    public Bookmark addChild(Bookmark ... bookmarks) {
        Optional.ofNullable(bookmarks).ifPresent(v -> Collections.addAll(this.param.getChildren(), v));
        return this;
    }

    public Bookmark addChild(List<Bookmark> bookmarks) {
        Optional.ofNullable(bookmarks).ifPresent(this.param.getChildren()::addAll);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element bookmark = document.createElement("fo:bookmark");
        Optional.ofNullable(this.param.getInternalDestination()).ifPresent(v -> bookmark.setAttribute("internal-destination", v.intern()));
        Optional.ofNullable(this.param.getTitle()).ifPresent(v -> bookmark.appendChild(this.createTitle(document)));
        Optional.ofNullable(this.param.getStartingState()).ifPresent(v -> bookmark.setAttribute("starting-state", v.intern()));
        Optional.ofNullable(this.param.getChildren()).ifPresent(v -> v.forEach(e -> bookmark.appendChild(e.createElement(document))));
        return bookmark;
    }

    private Element createTitle(Document document) {
        Element title = document.createElement("fo:bookmark-title");
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> title.setAttribute("font-family", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> title.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> title.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> title.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> title.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontColor()).ifPresent(v -> title.setAttribute("color", v.intern().toLowerCase()));
        title.setTextContent(this.param.getTitle());
        return title;
    }
}

