/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.Component;
import org.dromara.pdf.fop.core.doc.component.block.BlockContainerParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlockContainer
implements Component {
    private final BlockContainerParam param = new BlockContainerParam();

    private BlockContainer setInitialCapacity(int initialCapacity) {
        this.param.setComponents(new ArrayList<Component>(initialCapacity));
        return this;
    }

    public BlockContainer setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public BlockContainer setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public BlockContainer setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public BlockContainer setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public BlockContainer setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public BlockContainer setPadding(String padding) {
        this.param.setPadding(padding);
        return this;
    }

    public BlockContainer setPaddingTop(String paddingTop) {
        this.param.setPaddingTop(paddingTop);
        return this;
    }

    public BlockContainer setPaddingBottom(String paddingBottom) {
        this.param.setPaddingBottom(paddingBottom);
        return this;
    }

    public BlockContainer setPaddingLeft(String paddingLeft) {
        this.param.setPaddingLeft(paddingLeft);
        return this;
    }

    public BlockContainer setPaddingRight(String paddingRight) {
        this.param.setPaddingRight(paddingRight);
        return this;
    }

    public BlockContainer setId(String id) {
        this.param.setId(id);
        return this;
    }

    public BlockContainer setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public BlockContainer setWidth(String width) {
        this.param.setWidth(width);
        return this;
    }

    public BlockContainer setHeight(String height) {
        this.param.setHeight(height);
        return this;
    }

    public BlockContainer setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public BlockContainer setLetterSpacing(String spacing) {
        this.param.setLetterSpacing(spacing);
        return this;
    }

    public BlockContainer setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public BlockContainer setWhiteSpace(String whiteSpace) {
        this.param.setWhiteSpace(whiteSpace);
        return this;
    }

    public BlockContainer setWhiteSpaceCollapse(String whiteSpaceCollapse) {
        this.param.setWhiteSpaceCollapse(whiteSpaceCollapse);
        return this;
    }

    public BlockContainer setTextIndent(String indent) {
        this.param.setTextIndent(indent);
        return this;
    }

    public BlockContainer setStartIndent(String indent) {
        this.param.setStartIndent(indent);
        return this;
    }

    public BlockContainer setEndIndent(String indent) {
        this.param.setEndIndent(indent);
        return this;
    }

    public BlockContainer setSpaceBefore(String space) {
        this.param.setSpaceBefore(space);
        return this;
    }

    public BlockContainer setSpaceAfter(String space) {
        this.param.setSpaceAfter(space);
        return this;
    }

    public BlockContainer setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public BlockContainer setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public BlockContainer setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public BlockContainer setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public BlockContainer setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public BlockContainer setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public BlockContainer setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public BlockContainer setVerticalStyle(String style) {
        this.param.setVerticalAlign(style);
        return this;
    }

    public BlockContainer setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public BlockContainer setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public BlockContainer setBackground(String background) {
        this.param.setBackground(background);
        return this;
    }

    public BlockContainer setBackgroundImage(String image) {
        this.param.setBackgroundImage(image);
        return this;
    }

    public BlockContainer setBackgroundImageWidth(String width) {
        this.param.setBackgroundImageWidth(width);
        return this;
    }

    public BlockContainer setBackgroundImageHeight(String height) {
        this.param.setBackgroundImageHeight(height);
        return this;
    }

    public BlockContainer setBackgroundAttachment(String attachment) {
        this.param.setBackgroundAttachment(attachment);
        return this;
    }

    public BlockContainer setBackgroundColor(String color) {
        this.param.setBackgroundColor(color);
        return this;
    }

    public BlockContainer setBackgroundPosition(String position) {
        this.param.setBackgroundPosition(position);
        return this;
    }

    public BlockContainer setBackgroundHorizontalPosition(String position) {
        this.param.setBackgroundPositionHorizontal(position);
        return this;
    }

    public BlockContainer setBackgroundVerticalPosition(String position) {
        this.param.setBackgroundPositionVertical(position);
        return this;
    }

    public BlockContainer setBackgroundRepeat(String repeat) {
        this.param.setBackgroundRepeat(repeat);
        return this;
    }

    public BlockContainer setBorder(String border) {
        this.param.setBorder(border);
        return this;
    }

    public BlockContainer setBorderColor(String borderColor) {
        this.param.setBorderColor(borderColor);
        return this;
    }

    public BlockContainer setBorderStyle(String borderStyle) {
        this.param.setBorderStyle(borderStyle);
        return this;
    }

    public BlockContainer setBorderCollapse(String borderCollapse) {
        this.param.setBorderCollapse(borderCollapse);
        return this;
    }

    public BlockContainer setBorderTop(String border) {
        this.param.setBorderTop(border);
        return this;
    }

    public BlockContainer setBorderTopColor(String borderColor) {
        this.param.setBorderTopColor(borderColor);
        return this;
    }

    public BlockContainer setBorderTopStyle(String borderStyle) {
        this.param.setBorderTopStyle(borderStyle);
        return this;
    }

    public BlockContainer setBorderBottom(String border) {
        this.param.setBorderBottom(border);
        return this;
    }

    public BlockContainer setBorderBottomColor(String borderColor) {
        this.param.setBorderBottomColor(borderColor);
        return this;
    }

    public BlockContainer setBorderBottomStyle(String borderStyle) {
        this.param.setBorderBottomStyle(borderStyle);
        return this;
    }

    public BlockContainer setBorderLeft(String border) {
        this.param.setBorderLeft(border);
        return this;
    }

    public BlockContainer setBorderLeftColor(String borderColor) {
        this.param.setBorderLeftColor(borderColor);
        return this;
    }

    public BlockContainer setBorderLeftStyle(String borderStyle) {
        this.param.setBorderLeftStyle(borderStyle);
        return this;
    }

    public BlockContainer setBorderRight(String border) {
        this.param.setBorderRight(border);
        return this;
    }

    public BlockContainer setBorderRightColor(String borderColor) {
        this.param.setBorderRightColor(borderColor);
        return this;
    }

    public BlockContainer setBorderRightStyle(String borderStyle) {
        this.param.setBorderRightStyle(borderStyle);
        return this;
    }

    public BlockContainer enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public BlockContainer enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public BlockContainer enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public BlockContainer enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    public BlockContainer addComponent(Component ... components) {
        Optional.ofNullable(components).ifPresent(v -> Collections.addAll(this.param.getComponents(), v));
        return this;
    }

    public BlockContainer addComponent(List<Component> components) {
        Optional.ofNullable(components).ifPresent(this.param.getComponents()::addAll);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element blockContainer = document.createElement("fo:block-container");
        Element block = this.createBlockElement(document, this.param);
        Optional.ofNullable(this.param.getWidth()).ifPresent(v -> blockContainer.setAttribute("width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getHeight()).ifPresent(v -> blockContainer.setAttribute("height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLeading()).ifPresent(v -> blockContainer.setAttribute("line-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLetterSpacing()).ifPresent(v -> blockContainer.setAttribute("letter-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWordSpacing()).ifPresent(v -> blockContainer.setAttribute("word-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getTextIndent()).ifPresent(v -> blockContainer.setAttribute("text-indent", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getStartIndent()).ifPresent(v -> blockContainer.setAttribute("start-indent", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getEndIndent()).ifPresent(v -> blockContainer.setAttribute("end-indent", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getTextIndent()).ifPresent(v -> blockContainer.setAttribute("text-indent", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLanguage()).ifPresent(v -> blockContainer.setAttribute("language", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> blockContainer.setAttribute("font-family", v.intern()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> blockContainer.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> blockContainer.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> blockContainer.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> blockContainer.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getColor()).ifPresent(v -> blockContainer.setAttribute("color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getVerticalAlign()).ifPresent(v -> blockContainer.setAttribute("vertical-align", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundColor()).ifPresent(v -> blockContainer.setAttribute("background-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackground()).ifPresent(v -> blockContainer.setAttribute("background", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundImage()).ifPresent(v -> blockContainer.setAttribute("background-image", v.intern()));
        Optional.ofNullable(this.param.getBackgroundImageWidth()).ifPresent(v -> blockContainer.setAttribute("fox:background-image-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundImageHeight()).ifPresent(v -> blockContainer.setAttribute("fox:background-image-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundAttachment()).ifPresent(v -> blockContainer.setAttribute("background-attachment", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundPosition()).ifPresent(v -> blockContainer.setAttribute("background-position", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundPositionHorizontal()).ifPresent(v -> blockContainer.setAttribute("background-position-horizontal", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundPositionVertical()).ifPresent(v -> blockContainer.setAttribute("background-position-vertical", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundRepeat()).ifPresent(v -> blockContainer.setAttribute("background-repeat", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorder()).ifPresent(v -> blockContainer.setAttribute("border", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderStyle()).ifPresent(v -> blockContainer.setAttribute("border-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderColor()).ifPresent(v -> blockContainer.setAttribute("border-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderWidth()).ifPresent(v -> blockContainer.setAttribute("border-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderCollapse()).ifPresent(v -> blockContainer.setAttribute("border-collapse", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderTop()).ifPresent(v -> blockContainer.setAttribute("border-top", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderTopStyle()).ifPresent(v -> blockContainer.setAttribute("border-top-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderTopColor()).ifPresent(v -> blockContainer.setAttribute("border-top-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderTopWidth()).ifPresent(v -> blockContainer.setAttribute("border-top-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderBottom()).ifPresent(v -> blockContainer.setAttribute("border-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderBottomStyle()).ifPresent(v -> blockContainer.setAttribute("border-bottom-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderBottomColor()).ifPresent(v -> blockContainer.setAttribute("border-bottom-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderBottomWidth()).ifPresent(v -> blockContainer.setAttribute("border-bottom-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderLeft()).ifPresent(v -> blockContainer.setAttribute("border-left", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderLeftStyle()).ifPresent(v -> blockContainer.setAttribute("border-left-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderLeftColor()).ifPresent(v -> blockContainer.setAttribute("border-left-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderLeftWidth()).ifPresent(v -> blockContainer.setAttribute("border-left-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRight()).ifPresent(v -> blockContainer.setAttribute("border-right", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRightStyle()).ifPresent(v -> blockContainer.setAttribute("border-right-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRightColor()).ifPresent(v -> blockContainer.setAttribute("border-right-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRightWidth()).ifPresent(v -> blockContainer.setAttribute("border-right-width", v.intern().toLowerCase()));
        this.param.getComponents().forEach(v -> this.appendChild(block, v.createElement(document)));
        blockContainer.appendChild(block);
        return blockContainer;
    }
}

