/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.link;

import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.Component;
import org.dromara.pdf.fop.core.doc.component.link.LinkParam;
import org.dromara.pdf.fop.core.doc.component.text.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Link
implements Component {
    private final LinkParam param = new LinkParam();

    public Link setId(String id) {
        this.param.setId(id);
        return this;
    }

    public Link setText(Text text) {
        this.param.setComponent(text);
        return this;
    }

    public Link setInternalDestination(String destination) {
        this.param.setInternalDestination(destination);
        return this;
    }

    public Link setExternalDestination(String destination) {
        this.param.setExternalDestination(destination);
        return this;
    }

    public Link setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public Link setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public Link enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public Link enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public Link enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element block = this.createBlockElement(document, this.param);
        block.appendChild(this.createLink(document));
        return block;
    }

    private Element createLink(Document document) {
        Element link = document.createElement("fo:basic-link");
        Optional.ofNullable(this.param.getInternalDestination()).ifPresent(v -> link.setAttribute("internal-destination", v.intern()));
        Optional.ofNullable(this.param.getExternalDestination()).ifPresent(v -> link.setAttribute("external-destination", v.intern()));
        Optional.ofNullable(this.param.getComponent()).ifPresent(v -> link.appendChild(v.createElement(document)));
        return link;
    }
}

