/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.table;

import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.Component;
import org.dromara.pdf.fop.core.doc.component.table.TableBody;
import org.dromara.pdf.fop.core.doc.component.table.TableFooter;
import org.dromara.pdf.fop.core.doc.component.table.TableHeader;
import org.dromara.pdf.fop.core.doc.component.table.TableParam;
import org.dromara.pdf.fop.handler.ElementHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Table
implements Component {
    private final TableParam param = new TableParam();

    public Table setHeader(TableHeader header) {
        this.param.setHeader(header);
        return this;
    }

    public Table setBody(TableBody body) {
        this.param.setBody(body);
        return this;
    }

    public Table setFooter(TableFooter footer) {
        this.param.setFooter(footer);
        return this;
    }

    public Table setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public Table setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public Table setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public Table setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public Table setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public Table setPadding(String padding) {
        this.param.setPadding(padding);
        return this;
    }

    public Table setPaddingTop(String paddingTop) {
        this.param.setPaddingTop(paddingTop);
        return this;
    }

    public Table setPaddingBottom(String paddingBottom) {
        this.param.setPaddingBottom(paddingBottom);
        return this;
    }

    public Table setPaddingLeft(String paddingLeft) {
        this.param.setPaddingLeft(paddingLeft);
        return this;
    }

    public Table setPaddingRight(String paddingRight) {
        this.param.setPaddingRight(paddingRight);
        return this;
    }

    public Table setId(String id) {
        this.param.setId(id);
        return this;
    }

    public Table setWidth(String width) {
        this.param.setWidth(width);
        return this;
    }

    public Table setHeight(String height) {
        this.param.setHeight(height);
        return this;
    }

    public Table setBorder(String border) {
        this.param.setBorder(border);
        return this;
    }

    public Table setBorderStyle(String borderStyle) {
        this.param.setBorderStyle(borderStyle);
        return this;
    }

    public Table setBorderCollapse(String borderCollapse) {
        this.param.setBorderCollapse(borderCollapse);
        return this;
    }

    public Table setBorderSpacing(String borderSpacing) {
        this.param.setBorderSpacing(borderSpacing);
        return this;
    }

    public Table setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public Table setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public Table setLetterSpacing(String letterSpacing) {
        this.param.setLetterSpacing(letterSpacing);
        return this;
    }

    public Table setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public Table setWhiteSpace(String whiteSpace) {
        this.param.setWhiteSpace(whiteSpace);
        return this;
    }

    public Table setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public Table setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public Table setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public Table setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public Table setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public Table setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public Table setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public Table setVerticalStyle(String style) {
        this.param.setVerticalStyle(style);
        return this;
    }

    public Table setMinRowHeight(String minRowHeight) {
        this.param.setMinRowHeight(minRowHeight);
        return this;
    }

    public Table setMinColumnWidth(String minColumnWidth) {
        this.param.setMinColumnWidth(minColumnWidth);
        return this;
    }

    public Table setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public Table setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public Table setBackgroundColor(String color) {
        this.param.setBackgroundColor(color);
        return this;
    }

    public Table enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public Table enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public Table enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public Table enableAutoOmitHeader() {
        this.param.setIsAutoOmitHeader(Boolean.TRUE);
        return this;
    }

    public Table enableAutoOmitFooter() {
        this.param.setIsAutoOmitFooter(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element block = this.createBlockElement(document, this.param, false);
        block.appendChild(this.createTable(document));
        return block;
    }

    private Element createTable(Document document) {
        Element table = document.createElement("fo:table");
        ElementHandler.appendChild(table, this.createTableHeader(document));
        ElementHandler.appendChild(table, this.createTableFooter(document));
        ElementHandler.appendChild(table, this.createTableBody(document));
        Optional.ofNullable(this.param.getMargin()).ifPresent(v -> table.setAttribute("margin", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getMarginTop()).ifPresent(v -> table.setAttribute("margin-top", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getMarginBottom()).ifPresent(v -> table.setAttribute("margin-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getMarginLeft()).ifPresent(v -> table.setAttribute("margin-left", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getMarginRight()).ifPresent(v -> table.setAttribute("margin-right", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getVerticalStyle()).ifPresent(v -> table.setAttribute("display-align", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWidth()).ifPresent(v -> table.setAttribute("width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getHeight()).ifPresent(v -> table.setAttribute("height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorder()).ifPresent(v -> table.setAttribute("border", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderStyle()).ifPresent(v -> table.setAttribute("border-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderCollapse()).ifPresent(v -> table.setAttribute("border-collapse", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderSpacing()).ifPresent(v -> table.setAttribute("border-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLanguage()).ifPresent(v -> table.setAttribute("language", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> table.setAttribute("font-family", v.intern()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> table.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> table.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> table.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> table.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getColor()).ifPresent(v -> table.setAttribute("color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLeading()).ifPresent(v -> table.setAttribute("line-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLetterSpacing()).ifPresent(v -> table.setAttribute("letter-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWordSpacing()).ifPresent(v -> table.setAttribute("word-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWhiteSpace()).ifPresent(v -> table.setAttribute("white-space", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getIsAutoOmitHeader()).ifPresent(v -> table.setAttribute("table-omit-header-at-break", v.toString().intern().toLowerCase()));
        Optional.ofNullable(this.param.getIsAutoOmitFooter()).ifPresent(v -> table.setAttribute("table-omit-footer-at-break", v.toString().intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundColor()).ifPresent(v -> table.setAttribute("background-color", v.intern().toLowerCase()));
        table.setAttribute("table-layout", "fixed");
        return table;
    }

    private Element createTableHeader(Document document) {
        TableHeader header = this.param.getHeader();
        return header == null ? null : header.setMinColumnWidth(this.param.getMinColumnWidth()).setMinRowHeight(this.param.getMinRowHeight()).createElement(document);
    }

    private Element createTableBody(Document document) {
        TableBody body = this.param.getBody();
        if (body == null) {
            throw new IllegalArgumentException("the table body can not be null");
        }
        return body.setMinColumnWidth(this.param.getMinColumnWidth()).setMinRowHeight(this.param.getMinRowHeight()).createElement(document);
    }

    private Element createTableFooter(Document document) {
        TableFooter footer = this.param.getFooter();
        return footer == null ? null : footer.setMinColumnWidth(this.param.getMinColumnWidth()).setMinRowHeight(this.param.getMinRowHeight()).createElement(document);
    }
}

