/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.dromara.pdf.fop.core.datasource.DataSource;
import org.dromara.pdf.fop.support.layout.ExpandLayoutManagerMaker;
import org.dromara.pdf.fop.support.layout.LayoutManagerMapping;

class TemplateParam {
    private String configPath;
    private String title;
    private String author;
    private String subject;
    private String keywords;
    private String creator;
    private Date creationDate;
    private FopFactory fopFactory;
    private FOUserAgent userAgent;
    private URI baseUri;
    private ExpandLayoutManagerMaker layoutManagerMaker;
    private DataSource dataSource;
    private Boolean isAccessibility = Boolean.FALSE;
    private Boolean isKeepEmptyTags = Boolean.TRUE;
    private Boolean isErrorInfo = Boolean.TRUE;
    private Boolean isConserveMemory = Boolean.FALSE;

    void initParams() {
        if (Objects.isNull(this.configPath)) {
            this.configPath = "org/dromara/pdf/fop/fop.xconf";
        }
        if (Objects.isNull(this.dataSource)) {
            throw new IllegalArgumentException("the data source can not be null");
        }
        if (Objects.isNull(this.layoutManagerMaker)) {
            this.layoutManagerMaker = new LayoutManagerMapping();
        }
        if (Objects.isNull(this.fopFactory)) {
            this.fopFactory = this.initFopFactory();
        }
        if (Objects.isNull(this.userAgent)) {
            this.userAgent = this.initUserAgent();
        }
        this.layoutManagerMaker.initialize(this.userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FopFactory initFopFactory() {
        FopFactory fopFactory;
        block7: {
            InputStream inputStream = null;
            try {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configPath);
                if (inputStream == null) {
                    inputStream = Files.newInputStream(Paths.get(this.configPath, new String[0]), new OpenOption[0]);
                }
                Configuration configuration = this.initConfiguration((Configuration)new DefaultConfigurationBuilder().build(inputStream));
                fopFactory = new FopFactoryBuilder(this.baseUri, (ResourceResolver)new ImageResourceResolver(this.baseUri)).setLayoutManagerMakerOverride((LayoutManagerMaker)this.layoutManagerMaker).setConfiguration(configuration).build();
                if (inputStream == null) break block7;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return fopFactory;
    }

    FOUserAgent initUserAgent() {
        FOUserAgent userAgent = this.fopFactory.newFOUserAgent();
        userAgent.getFontManager().setResourceResolver(ResourceResolverFactory.createInternalResourceResolver((URI)this.baseUri, (ResourceResolver)new FontResourceResolver(this.initResource(this.fopFactory.getUserConfig()))));
        userAgent.setProducer("x-easypdf/fop");
        userAgent.setAccessibility(this.isAccessibility.booleanValue());
        userAgent.setAuthor(this.author);
        userAgent.setCreator(this.creator);
        userAgent.setTitle(this.title);
        userAgent.setSubject(this.subject);
        userAgent.setKeywords(this.keywords);
        userAgent.setCreationDate(this.creationDate);
        userAgent.setKeepEmptyTags(this.isKeepEmptyTags.booleanValue());
        userAgent.setLocatorEnabled(this.isErrorInfo.booleanValue());
        userAgent.setConserveMemoryPolicy(this.isConserveMemory.booleanValue());
        return userAgent;
    }

    private Map<String, String> initResource(Configuration configuration) {
        Configuration[] rendererArray;
        String renderType = "application/pdf";
        HashMap<String, String> resource = new HashMap<String, String>(10);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Configuration renderers = configuration.getChild("renderers");
        for (Configuration renderer : rendererArray = renderers.getChildren("renderer")) {
            Configuration[] fontArray;
            if (!"application/pdf".equals(renderer.getAttribute("mime"))) continue;
            Configuration fonts = renderer.getChild("fonts");
            for (Configuration font : fontArray = fonts.getChildren("font")) {
                String attribute = font.getAttribute("embed-url");
                if (attribute == null || classLoader.getResource(attribute) == null) continue;
                resource.put(FilenameUtils.getName((String)attribute), attribute);
            }
        }
        return resource;
    }

    private Configuration initConfiguration(Configuration configuration) {
        Configuration baseConfig = configuration.getChild("base");
        this.baseUri = baseConfig == null ? new File(".").toURI() : new File(baseConfig.getValue(".")).toURI();
        return configuration;
    }

    @Generated
    public TemplateParam() {
    }

    @Generated
    public String getConfigPath() {
        return this.configPath;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getKeywords() {
        return this.keywords;
    }

    @Generated
    public String getCreator() {
        return this.creator;
    }

    @Generated
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public FopFactory getFopFactory() {
        return this.fopFactory;
    }

    @Generated
    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Generated
    public ExpandLayoutManagerMaker getLayoutManagerMaker() {
        return this.layoutManagerMaker;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public Boolean getIsAccessibility() {
        return this.isAccessibility;
    }

    @Generated
    public Boolean getIsKeepEmptyTags() {
        return this.isKeepEmptyTags;
    }

    @Generated
    public Boolean getIsErrorInfo() {
        return this.isErrorInfo;
    }

    @Generated
    public Boolean getIsConserveMemory() {
        return this.isConserveMemory;
    }

    @Generated
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    @Generated
    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Generated
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Generated
    public void setFopFactory(FopFactory fopFactory) {
        this.fopFactory = fopFactory;
    }

    @Generated
    public void setUserAgent(FOUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    @Generated
    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    @Generated
    public void setLayoutManagerMaker(ExpandLayoutManagerMaker layoutManagerMaker) {
        this.layoutManagerMaker = layoutManagerMaker;
    }

    @Generated
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Generated
    public void setIsAccessibility(Boolean isAccessibility) {
        this.isAccessibility = isAccessibility;
    }

    @Generated
    public void setIsKeepEmptyTags(Boolean isKeepEmptyTags) {
        this.isKeepEmptyTags = isKeepEmptyTags;
    }

    @Generated
    public void setIsErrorInfo(Boolean isErrorInfo) {
        this.isErrorInfo = isErrorInfo;
    }

    @Generated
    public void setIsConserveMemory(Boolean isConserveMemory) {
        this.isConserveMemory = isConserveMemory;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateParam)) {
            return false;
        }
        TemplateParam other = (TemplateParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isAccessibility = this.getIsAccessibility();
        Boolean other$isAccessibility = other.getIsAccessibility();
        if (this$isAccessibility == null ? other$isAccessibility != null : !((Object)this$isAccessibility).equals(other$isAccessibility)) {
            return false;
        }
        Boolean this$isKeepEmptyTags = this.getIsKeepEmptyTags();
        Boolean other$isKeepEmptyTags = other.getIsKeepEmptyTags();
        if (this$isKeepEmptyTags == null ? other$isKeepEmptyTags != null : !((Object)this$isKeepEmptyTags).equals(other$isKeepEmptyTags)) {
            return false;
        }
        Boolean this$isErrorInfo = this.getIsErrorInfo();
        Boolean other$isErrorInfo = other.getIsErrorInfo();
        if (this$isErrorInfo == null ? other$isErrorInfo != null : !((Object)this$isErrorInfo).equals(other$isErrorInfo)) {
            return false;
        }
        Boolean this$isConserveMemory = this.getIsConserveMemory();
        Boolean other$isConserveMemory = other.getIsConserveMemory();
        if (this$isConserveMemory == null ? other$isConserveMemory != null : !((Object)this$isConserveMemory).equals(other$isConserveMemory)) {
            return false;
        }
        String this$configPath = this.getConfigPath();
        String other$configPath = other.getConfigPath();
        if (this$configPath == null ? other$configPath != null : !this$configPath.equals(other$configPath)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$keywords = this.getKeywords();
        String other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !this$keywords.equals(other$keywords)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Date this$creationDate = this.getCreationDate();
        Date other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        FopFactory this$fopFactory = this.getFopFactory();
        FopFactory other$fopFactory = other.getFopFactory();
        if (this$fopFactory == null ? other$fopFactory != null : !this$fopFactory.equals(other$fopFactory)) {
            return false;
        }
        FOUserAgent this$userAgent = this.getUserAgent();
        FOUserAgent other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        URI this$baseUri = this.getBaseUri();
        URI other$baseUri = other.getBaseUri();
        if (this$baseUri == null ? other$baseUri != null : !((Object)this$baseUri).equals(other$baseUri)) {
            return false;
        }
        ExpandLayoutManagerMaker this$layoutManagerMaker = this.getLayoutManagerMaker();
        ExpandLayoutManagerMaker other$layoutManagerMaker = other.getLayoutManagerMaker();
        if (this$layoutManagerMaker == null ? other$layoutManagerMaker != null : !this$layoutManagerMaker.equals(other$layoutManagerMaker)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TemplateParam;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isAccessibility = this.getIsAccessibility();
        result = result * 59 + ($isAccessibility == null ? 43 : ((Object)$isAccessibility).hashCode());
        Boolean $isKeepEmptyTags = this.getIsKeepEmptyTags();
        result = result * 59 + ($isKeepEmptyTags == null ? 43 : ((Object)$isKeepEmptyTags).hashCode());
        Boolean $isErrorInfo = this.getIsErrorInfo();
        result = result * 59 + ($isErrorInfo == null ? 43 : ((Object)$isErrorInfo).hashCode());
        Boolean $isConserveMemory = this.getIsConserveMemory();
        result = result * 59 + ($isConserveMemory == null ? 43 : ((Object)$isConserveMemory).hashCode());
        String $configPath = this.getConfigPath();
        result = result * 59 + ($configPath == null ? 43 : $configPath.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : $keywords.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Date $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        FopFactory $fopFactory = this.getFopFactory();
        result = result * 59 + ($fopFactory == null ? 43 : $fopFactory.hashCode());
        FOUserAgent $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        URI $baseUri = this.getBaseUri();
        result = result * 59 + ($baseUri == null ? 43 : ((Object)$baseUri).hashCode());
        ExpandLayoutManagerMaker $layoutManagerMaker = this.getLayoutManagerMaker();
        result = result * 59 + ($layoutManagerMaker == null ? 43 : $layoutManagerMaker.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TemplateParam(configPath=" + this.getConfigPath() + ", title=" + this.getTitle() + ", author=" + this.getAuthor() + ", subject=" + this.getSubject() + ", keywords=" + this.getKeywords() + ", creator=" + this.getCreator() + ", creationDate=" + this.getCreationDate() + ", fopFactory=" + this.getFopFactory() + ", userAgent=" + this.getUserAgent() + ", baseUri=" + this.getBaseUri() + ", layoutManagerMaker=" + this.getLayoutManagerMaker() + ", dataSource=" + this.getDataSource() + ", isAccessibility=" + this.getIsAccessibility() + ", isKeepEmptyTags=" + this.getIsKeepEmptyTags() + ", isErrorInfo=" + this.getIsErrorInfo() + ", isConserveMemory=" + this.getIsConserveMemory() + ")";
    }

    public static final class ImageResourceResolver
    implements ResourceResolver {
        private final Integer baseIndexOf;
        private static final String TYPE = "file";

        public ImageResourceResolver(URI baseUri) {
            this.baseIndexOf = Paths.get(baseUri).toRealPath(new LinkOption[0]).toUri().getPath().length();
        }

        public Resource getResource(URI uri) throws IOException {
            InputStream inputStream;
            if (TYPE.equals(uri.getScheme()) && uri.getPath().length() > this.baseIndexOf) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri.getPath().substring(this.baseIndexOf));
                if (inputStream == null) {
                    inputStream = Files.newInputStream(Paths.get(uri), new OpenOption[0]);
                }
            } else {
                inputStream = uri.toURL().openStream();
            }
            return new Resource(inputStream);
        }

        public OutputStream getOutputStream(URI uri) throws IOException {
            return uri.toURL().openConnection().getOutputStream();
        }
    }

    public static final class FontResourceResolver
    implements ResourceResolver {
        private final Map<String, String> resources;

        public FontResourceResolver(Map<String, String> resources) {
            this.resources = resources;
        }

        public Resource getResource(URI uri) throws IOException {
            String resourceFontPath = this.resources.get(FilenameUtils.getName((String)uri.toString()));
            InputStream inputStream = resourceFontPath != null ? Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceFontPath) : uri.toURL().openStream();
            return new Resource(inputStream);
        }

        public OutputStream getOutputStream(URI uri) throws IOException {
            return uri.toURL().openConnection().getOutputStream();
        }
    }
}

