/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.table;

import java.awt.Color;
import java.io.Serializable;
import java.util.Optional;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.barcode.XEasyPdfBarCode;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImage;
import org.dromara.pdf.pdfbox.component.line.XEasyPdfLine;
import org.dromara.pdf.pdfbox.component.rect.XEasyPdfRect;
import org.dromara.pdf.pdfbox.component.table.XEasyPdfCellBorder;
import org.dromara.pdf.pdfbox.component.table.XEasyPdfCellParam;
import org.dromara.pdf.pdfbox.component.table.XEasyPdfRow;
import org.dromara.pdf.pdfbox.component.table.XEasyPdfTable;
import org.dromara.pdf.pdfbox.component.table.XEasyPdfTableParam;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfText;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDefaultFontStyle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPositionStyle;
import org.dromara.pdf.pdfbox.handler.XEasyPdfHandler;

public class XEasyPdfCell
implements Serializable {
    private static final long serialVersionUID = -94458460877280249L;
    private final XEasyPdfCellParam param = new XEasyPdfCellParam();

    public XEasyPdfCell(float width) {
        this.param.setWidth(Float.valueOf(Math.abs(width)));
    }

    public XEasyPdfCell(float width, float height) {
        this.param.setWidth(Float.valueOf(Math.abs(width))).setHeight(Float.valueOf(Math.abs(height)));
    }

    public XEasyPdfCell setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    public XEasyPdfCell setWidth(float width) {
        this.param.setWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    public XEasyPdfCell setHeight(float height) {
        this.param.setHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    public XEasyPdfCell setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.param.setBackgroundColor(backgroundColor);
        }
        return this;
    }

    public XEasyPdfCell setBorderWidth(float borderWidth) {
        this.param.setBorderWidth(Float.valueOf(Math.abs(borderWidth)));
        return this;
    }

    public XEasyPdfCell setBorderLineLength(float borderLineLength) {
        this.param.setBorderLineLength(Float.valueOf(Math.abs(borderLineLength)));
        return this;
    }

    public XEasyPdfCell setBorderLineSpace(float borderLineSpace) {
        this.param.setBorderLineSpace(Float.valueOf(Math.abs(borderLineSpace)));
        return this;
    }

    public XEasyPdfCell setBorderColor(Color borderColor) {
        if (borderColor != null) {
            this.param.setBorderColor(borderColor);
        }
        return this;
    }

    public XEasyPdfCell setLeftBorderColor(Color borderColor) {
        this.param.setLeftBorderColor(borderColor);
        return this;
    }

    public XEasyPdfCell setRightBorderColor(Color borderColor) {
        this.param.setRightBorderColor(borderColor);
        return this;
    }

    public XEasyPdfCell setTopBorderColor(Color borderColor) {
        this.param.setTopBorderColor(borderColor);
        return this;
    }

    public XEasyPdfCell setBottomBorderColor(Color borderColor) {
        this.param.setBottomBorderColor(borderColor);
        return this;
    }

    public XEasyPdfCell setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    public XEasyPdfCell disableBorder() {
        this.param.setHasBorder(Boolean.FALSE).setHasTopBorder(Boolean.FALSE).setHasBottomBorder(Boolean.FALSE).setHasLeftBorder(Boolean.FALSE).setHasRightBorder(Boolean.FALSE);
        return this;
    }

    public XEasyPdfCell setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfCell setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfCell setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize)));
        return this;
    }

    public XEasyPdfCell setFontColor(Color fontColor) {
        if (fontColor != null) {
            this.param.setFontColor(fontColor);
        }
        return this;
    }

    public XEasyPdfCell setHorizontalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            XEasyPdfPositionStyle.checkHorizontalStyle(style);
            this.param.setHorizontalStyle(style);
        }
        return this;
    }

    public XEasyPdfCell setVerticalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            XEasyPdfPositionStyle.checkVerticalStyle(style);
            this.param.setVerticalStyle(style);
        }
        return this;
    }

    public XEasyPdfCell enableCenterStyle() {
        this.param.setHorizontalStyle(XEasyPdfPositionStyle.CENTER).setVerticalStyle(XEasyPdfPositionStyle.CENTER);
        return this;
    }

    public XEasyPdfCell enableVerticalMerge() {
        this.param.setIsVerticalMerge(Boolean.TRUE);
        return this;
    }

    public XEasyPdfCell enableNewLine() {
        this.param.setIsNewLine(Boolean.TRUE);
        return this;
    }

    public XEasyPdfCell disableNewLine() {
        this.param.setIsNewLine(Boolean.FALSE);
        return this;
    }

    public XEasyPdfCell enableComponentSelfStyle() {
        this.param.setIsComponentSelfStyle(Boolean.TRUE);
        return this;
    }

    public XEasyPdfCell disableTopBorder() {
        this.param.setHasTopBorder(Boolean.FALSE);
        return this;
    }

    public XEasyPdfCell disableBottomBorder() {
        this.param.setHasBottomBorder(Boolean.FALSE);
        return this;
    }

    public XEasyPdfCell disableLeftBorder() {
        this.param.setHasLeftBorder(Boolean.FALSE);
        return this;
    }

    public XEasyPdfCell disableRightBorder() {
        this.param.setHasRightBorder(Boolean.FALSE);
        return this;
    }

    public XEasyPdfCell disableTopBottomBorder() {
        this.param.setHasTopBorder(Boolean.FALSE).setHasBottomBorder(Boolean.FALSE);
        return this;
    }

    public XEasyPdfCell disableLeftRightBorder() {
        this.param.setHasLeftBorder(Boolean.FALSE).setHasRightBorder(Boolean.FALSE);
        return this;
    }

    public XEasyPdfCell enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfCell enableAutoScaleFontSize() {
        this.param.setIsAutoScaleFontSize(Boolean.TRUE);
        return this;
    }

    public XEasyPdfCell addContent(XEasyPdfComponent component) {
        this.param.setComponent(component);
        return this;
    }

    XEasyPdfCellParam getParam() {
        return this.param;
    }

    float init(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row) {
        this.param.init(document, page, row);
        Float rowHeight = this.param.getHeight();
        XEasyPdfComponent component = this.param.getComponent();
        if (component instanceof XEasyPdfText) {
            XEasyPdfText text = (XEasyPdfText)component;
            this.initText(document, page, row, text);
            if (rowHeight == null) {
                rowHeight = Float.valueOf(text.getHeight(document, page));
            }
        } else if (component instanceof XEasyPdfImage) {
            XEasyPdfImage image = (XEasyPdfImage)component;
            this.initImage(document, page, row, image);
            if (rowHeight == null) {
                rowHeight = Float.valueOf(image.getHeight(document, page).intValue());
            }
        }
        return rowHeight == null ? 0.0f : rowHeight.floatValue();
    }

    void doDraw(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table, XEasyPdfRow row) {
        if (this.param.getHeight() == null) {
            this.param.setHeight(row.getParam().getHeight());
        }
        this.fillBackgroundColor(document, page, row);
        this.writeBorder(document, page, table, row);
        if (this.param.getIsNewLine().booleanValue()) {
            page.enablePosition();
        }
        float pageY = page.getPageY().floatValue();
        float rowBeginX = row.getParam().getBeginX().floatValue();
        XEasyPdfComponent component = this.param.getComponent();
        if (component != null) {
            if (this.param.getIsResetContext().booleanValue()) {
                component.enableResetContext();
            }
            if (component instanceof XEasyPdfText) {
                this.writeText(document, page, row, (XEasyPdfText)component);
            } else if (component instanceof XEasyPdfImage) {
                this.writeImage(document, page, row, (XEasyPdfImage)component);
            } else if (component instanceof XEasyPdfBarCode) {
                this.writeBarCode(document, page, row, (XEasyPdfBarCode)component);
            } else if (component instanceof XEasyPdfLine) {
                this.writeLine(document, page, row, (XEasyPdfLine)component);
            } else {
                this.writeOtherComponent(document, page, row, component);
            }
        }
        row.getParam().setBeginX(Float.valueOf(rowBeginX));
        page.setPageY(Float.valueOf(pageY));
        page.disablePosition();
    }

    void enableLeftBorder() {
        this.param.setHasLeftBorder(Boolean.TRUE).setHasBorder(Boolean.TRUE);
    }

    void enableRightBorder() {
        this.param.setHasRightBorder(Boolean.TRUE).setHasBorder(Boolean.TRUE);
    }

    void enableTopBorder() {
        this.param.setHasTopBorder(Boolean.TRUE).setHasBorder(Boolean.TRUE);
    }

    void enableBottomBorder() {
        this.param.setHasBottomBorder(Boolean.TRUE).setHasBorder(Boolean.TRUE);
    }

    private void fillBackgroundColor(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row) {
        if (!Color.WHITE.equals(this.param.getBackgroundColor())) {
            XEasyPdfRect rect = XEasyPdfHandler.Rect.build(this.param.getWidth().floatValue(), this.param.getHeight().floatValue(), row.getParam().getBeginX().floatValue(), row.getParam().getBeginY().floatValue() - this.param.getHeight().floatValue() - this.param.getMarginTop().floatValue());
            if (this.param.getIsResetContext().booleanValue()) {
                rect.enableResetContext();
            }
            rect.setContentMode(this.param.getContentMode()).setBackgroundColor(this.param.getBackgroundColor()).setBorderColor(this.param.getBackgroundColor()).setNewLine(false).disableCheckPage().draw(document, page);
        }
    }

    private void writeBorder(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table, XEasyPdfRow row) {
        if (this.param.getHasBorder().booleanValue()) {
            XEasyPdfCellBorder cellBorder = new XEasyPdfCellBorder().setDocument(document.getTarget()).setPage(page.getLastPage()).setContentMode(Optional.ofNullable(this.param.getContentMode()).orElse(XEasyPdfComponent.ContentMode.APPEND).getMode()).setIsResetContext(this.param.getIsResetContext()).setWidth(this.param.getWidth()).setHeight(this.param.getHeight()).setLeftBorderColor(this.param.getLeftBorderColor()).setRightBorderColor(this.param.getRightBorderColor()).setTopBorderColor(this.param.getTopBorderColor()).setBottomBorderColor(this.param.getBottomBorderColor()).setBorderWidth(this.param.getBorderWidth()).setBorderLineLength(this.param.getBorderLineLength()).setBorderLineSpace(this.param.getBorderLineSpace()).setBeginX(row.getParam().getBeginX()).setBeginY(Float.valueOf(row.getParam().getBeginY().floatValue() - this.param.getMarginTop().floatValue())).setHasTopBorder(this.param.getHasTopBorder()).setHasBottomBorder(this.param.getHasBottomBorder()).setHasLeftBorder(this.param.getHasLeftBorder()).setHasRightBorder(this.param.getHasRightBorder());
            XEasyPdfTableParam tableParam = table.getParam();
            if (this.param.getBorderColor().equals(tableParam.getBorderColor())) {
                cellBorder.drawBorder();
            } else {
                tableParam.getCellBorderList().add(cellBorder);
            }
        }
    }

    private void writeText(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfText text) {
        if (this.param.getIsAutoScaleFontSize() != null && this.param.getIsAutoScaleFontSize().booleanValue()) {
            float textHeight = text.getHeight(document, page);
            while (textHeight > this.param.getHeight().floatValue() && text.getFontSize() > 1.0f) {
                textHeight = text.setFontSize(text.getFontSize() - 1.0f).setMaxHeight(null).setSplitTextList(null).getHeight(document, page);
            }
        }
        text.setPosition(row.getParam().getBeginX().floatValue(), this.initYForText(document, page, row, text) - this.param.getMarginTop().floatValue()).enableChildComponent().draw(document, page);
    }

    private void writeImage(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfImage image) {
        image.setPosition(row.getParam().getBeginX().floatValue() + this.param.getBorderWidth().floatValue() / 2.0f, this.initYForImage(document, page, row, image.getHeight(document, page).intValue()) - this.param.getMarginTop().floatValue()).draw(document, page);
    }

    private void writeBarCode(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfBarCode barCode) {
        barCode.setPosition(row.getParam().getBeginX().floatValue() + this.param.getBorderWidth().floatValue(), this.initYForImage(document, page, row, barCode.getHeight(document, page)) - this.param.getMarginTop().floatValue()).draw(document, page);
    }

    private void writeLine(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfLine line) {
        line.setContentMode(this.param.getContentMode()).setWidth(this.param.getWidth().floatValue()).setPosition(row.getParam().getBeginX().floatValue(), row.getParam().getBeginY().floatValue() - this.param.getMarginTop().floatValue()).draw(document, page);
    }

    private void writeOtherComponent(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfComponent component) {
        component.setPosition(row.getParam().getBeginX().floatValue(), page.getPageY().floatValue() - this.param.getMarginTop().floatValue()).draw(document, page);
    }

    private void initText(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfText text) {
        if (text.isNeedInitialize()) {
            text.enableChildComponent().setWidth(this.param.getWidth().floatValue());
            if (this.param.getIsComponentSelfStyle().booleanValue()) {
                this.param.setContentMode(text.getContentMode()).setFontPath(text.getFontPath()).setFontSize(Float.valueOf(text.getFontSize())).setFontColor(text.getFontColor()).setVerticalStyle(text.getVerticalStyle()).setHorizontalStyle(text.getHorizontalStyle());
            }
            text.setNeedInitialize(false).setContentMode(this.param.getContentMode()).setFontPath(this.param.getFontPath()).setFontSize(this.param.getFontSize().floatValue()).setFontColor(this.param.getFontColor()).setHorizontalStyle(this.param.getHorizontalStyle()).setVerticalStyle(this.param.getVerticalStyle());
        }
    }

    private void initImage(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfImage image) {
        if (image.isNeedInitialize()) {
            Float height;
            if (this.param.getIsComponentSelfStyle().booleanValue()) {
                this.param.setContentMode(image.getContentMode()).setVerticalStyle(image.getVerticalStyle()).setHorizontalStyle(image.getHorizontalStyle());
            }
            if ((height = this.param.getHeight()) == null) {
                height = row.getParam().getHeight();
            }
            if (height == null) {
                height = Float.valueOf(image.getHeight(document, page).intValue());
            }
            if (image.isCustomRectangle()) {
                image.setWidth(Math.min((float)image.getWidth(document, page).intValue(), this.param.getWidth().floatValue()) - this.param.getBorderWidth().floatValue()).setHeight(Math.min((float)image.getHeight(document, page).intValue(), height.floatValue()) - this.param.getBorderWidth().floatValue());
            } else {
                image.setWidth(this.param.getWidth().floatValue() - this.param.getBorderWidth().floatValue()).setHeight(height.floatValue() - this.param.getBorderWidth().floatValue());
            }
            image.setNeedInitialize(false).enableChildComponent().setMaxWidth(this.param.getWidth().floatValue() - this.param.getBorderWidth().floatValue()).setMaxHeight(height.floatValue() - this.param.getBorderWidth().floatValue()).setContentMode(this.param.getContentMode()).setHorizontalStyle(this.param.getHorizontalStyle()).setVerticalStyle(this.param.getVerticalStyle());
        }
    }

    private float initYForText(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfText text) {
        float height = text.getHeight(document, page);
        float y = page.getPageY().floatValue();
        if (this.param.getVerticalStyle() == XEasyPdfPositionStyle.TOP) {
            y = y - text.getFontSize() - this.param.getBorderWidth().floatValue() - row.getParam().getMarginTop().floatValue();
            return y;
        }
        if (this.param.getVerticalStyle() == XEasyPdfPositionStyle.CENTER) {
            y = y - text.getFontSize() - (this.param.getHeight().floatValue() - height) / 2.0f - row.getParam().getMarginTop().floatValue();
            return y;
        }
        if (this.param.getVerticalStyle() == XEasyPdfPositionStyle.BOTTOM) {
            y = y - text.getFontSize() - this.param.getHeight().floatValue() + height - row.getParam().getMarginTop().floatValue();
        }
        return y;
    }

    private float initYForImage(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, float height) {
        float y = page.getPageY().floatValue();
        if (this.param.getVerticalStyle() == XEasyPdfPositionStyle.TOP) {
            y = y - height - this.param.getBorderWidth().floatValue() - row.getParam().getMarginTop().floatValue();
            return y;
        }
        if (this.param.getVerticalStyle() == XEasyPdfPositionStyle.CENTER) {
            y = y - height - (this.param.getHeight().floatValue() - height) / 2.0f - row.getParam().getMarginTop().floatValue();
            return y;
        }
        if (this.param.getVerticalStyle() == XEasyPdfPositionStyle.BOTTOM) {
            y = y - this.param.getHeight().floatValue() + this.param.getBorderWidth().floatValue() - row.getParam().getMarginTop().floatValue();
        }
        return y;
    }
}

