/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.table;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

final class XEasyPdfCellBorder {
    private PDDocument document;
    private PDPage page;
    private PDPageContentStream.AppendMode contentMode;
    private Boolean isResetContext;
    private Float width;
    private Float height;
    private Float beginX;
    private Float beginY;
    private Color leftBorderColor;
    private Color rightBorderColor;
    private Color topBorderColor;
    private Color bottomBorderColor;
    private Float borderWidth;
    private Float borderLineLength;
    private Float borderLineSpace;
    private Boolean hasTopBorder = Boolean.TRUE;
    private Boolean hasBottomBorder = Boolean.TRUE;
    private Boolean hasLeftBorder = Boolean.TRUE;
    private Boolean hasRightBorder = Boolean.TRUE;

    void drawBorder() {
        PDPageContentStream contentStream = new PDPageContentStream(this.document, this.page, this.contentMode, true, this.isResetContext.booleanValue());
        contentStream.setLineWidth(this.borderWidth.floatValue());
        contentStream.setLineCapStyle(0);
        this.line(contentStream);
        contentStream.setStrokingColor(Color.BLACK);
        contentStream.close();
        this.document = null;
        this.page = null;
    }

    private void line(PDPageContentStream contentStream) {
        float min = 1.0f;
        if (this.borderLineLength != null && this.borderLineLength.floatValue() >= min && this.borderLineSpace != null && this.borderLineSpace.floatValue() >= min) {
            this.drawDottedLine(contentStream);
        } else {
            this.drawSolidLine(contentStream);
        }
    }

    private void drawSolidLine(PDPageContentStream contentStream) {
        float beginX = this.beginX.floatValue();
        float beginY = this.beginY.floatValue();
        if (this.hasTopBorder.booleanValue()) {
            contentStream.setStrokingColor(this.topBorderColor);
            contentStream.moveTo(beginX, beginY);
            beginX = this.beginX.floatValue() + this.width.floatValue();
            contentStream.lineTo(beginX, beginY);
            contentStream.stroke();
        }
        if (this.hasBottomBorder.booleanValue()) {
            contentStream.setStrokingColor(this.bottomBorderColor);
            beginX = this.beginX.floatValue();
            beginY = this.beginY.floatValue() - this.height.floatValue();
            contentStream.moveTo(beginX, beginY);
            beginX = this.beginX.floatValue() + this.width.floatValue();
            contentStream.lineTo(beginX, beginY);
            contentStream.stroke();
        }
        if (this.hasLeftBorder.booleanValue()) {
            contentStream.setStrokingColor(this.leftBorderColor);
            beginX = this.beginX.floatValue();
            beginY = this.beginY.floatValue();
            contentStream.moveTo(beginX, beginY);
            beginY = this.beginY.floatValue() - this.height.floatValue();
            contentStream.lineTo(beginX, beginY);
            contentStream.stroke();
        }
        if (this.hasRightBorder.booleanValue()) {
            contentStream.setStrokingColor(this.rightBorderColor);
            beginX = this.beginX.floatValue() + this.width.floatValue();
            beginY = this.beginY.floatValue();
            contentStream.moveTo(beginX, beginY);
            beginY = this.beginY.floatValue() - this.height.floatValue();
            contentStream.lineTo(beginX, beginY);
            contentStream.stroke();
        }
    }

    private void drawDottedLine(PDPageContentStream contentStream) {
        float endX = this.beginX.floatValue() + this.width.floatValue();
        float endY = this.beginY.floatValue() - this.height.floatValue();
        if (this.hasTopBorder.booleanValue()) {
            this.drawDottedLine(contentStream, this.topBorderColor, this.beginX.floatValue(), this.beginY.floatValue(), endX, this.beginY.floatValue());
        }
        if (this.hasBottomBorder.booleanValue()) {
            this.drawDottedLine(contentStream, this.bottomBorderColor, this.beginX.floatValue(), endY, endX, endY);
        }
        if (this.hasLeftBorder.booleanValue()) {
            this.drawDottedLine(contentStream, this.leftBorderColor, this.beginX.floatValue(), this.beginY.floatValue(), this.beginX.floatValue(), endY);
        }
        if (this.hasRightBorder.booleanValue()) {
            this.drawDottedLine(contentStream, this.rightBorderColor, endX, this.beginY.floatValue(), endX, endY);
        }
    }

    private void drawDottedLine(PDPageContentStream contentStream, Color borderColor, float beginX, float beginY, float endX, float endY) {
        boolean isHorizontal;
        contentStream.setStrokingColor(borderColor);
        float totalLength = endX - beginX;
        boolean bl = isHorizontal = totalLength > 0.0f;
        if (!isHorizontal) {
            totalLength = beginY - endY;
        }
        float lineWidth = this.borderLineLength.floatValue() + this.borderLineSpace.floatValue();
        int count = Math.max((int)(totalLength / lineWidth), 1);
        float offset = Math.abs((totalLength - (float)count * lineWidth + this.borderLineSpace.floatValue()) / 2.0f);
        if (this.borderLineLength.floatValue() > totalLength) {
            this.borderLineLength = Float.valueOf(totalLength);
            offset = 0.0f;
        }
        if (isHorizontal) {
            beginX += offset;
        } else {
            beginY -= offset;
        }
        for (int i = 0; i < count; ++i) {
            contentStream.moveTo(beginX, beginY);
            if (isHorizontal) {
                contentStream.lineTo(beginX += this.borderLineLength.floatValue(), beginY);
                beginX += this.borderLineSpace.floatValue();
                continue;
            }
            contentStream.lineTo(beginX, beginY -= this.borderLineLength.floatValue());
            beginY -= this.borderLineSpace.floatValue();
        }
        contentStream.stroke();
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public PDPage getPage() {
        return this.page;
    }

    public PDPageContentStream.AppendMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Color getLeftBorderColor() {
        return this.leftBorderColor;
    }

    public Color getRightBorderColor() {
        return this.rightBorderColor;
    }

    public Color getTopBorderColor() {
        return this.topBorderColor;
    }

    public Color getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public Float getBorderWidth() {
        return this.borderWidth;
    }

    public Float getBorderLineLength() {
        return this.borderLineLength;
    }

    public Float getBorderLineSpace() {
        return this.borderLineSpace;
    }

    public Boolean getHasTopBorder() {
        return this.hasTopBorder;
    }

    public Boolean getHasBottomBorder() {
        return this.hasBottomBorder;
    }

    public Boolean getHasLeftBorder() {
        return this.hasLeftBorder;
    }

    public Boolean getHasRightBorder() {
        return this.hasRightBorder;
    }

    public XEasyPdfCellBorder setDocument(PDDocument document) {
        this.document = document;
        return this;
    }

    public XEasyPdfCellBorder setPage(PDPage page) {
        this.page = page;
        return this;
    }

    public XEasyPdfCellBorder setContentMode(PDPageContentStream.AppendMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfCellBorder setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfCellBorder setWidth(Float width) {
        this.width = width;
        return this;
    }

    public XEasyPdfCellBorder setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfCellBorder setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfCellBorder setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfCellBorder setLeftBorderColor(Color leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
        return this;
    }

    public XEasyPdfCellBorder setRightBorderColor(Color rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
        return this;
    }

    public XEasyPdfCellBorder setTopBorderColor(Color topBorderColor) {
        this.topBorderColor = topBorderColor;
        return this;
    }

    public XEasyPdfCellBorder setBottomBorderColor(Color bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
        return this;
    }

    public XEasyPdfCellBorder setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public XEasyPdfCellBorder setBorderLineLength(Float borderLineLength) {
        this.borderLineLength = borderLineLength;
        return this;
    }

    public XEasyPdfCellBorder setBorderLineSpace(Float borderLineSpace) {
        this.borderLineSpace = borderLineSpace;
        return this;
    }

    public XEasyPdfCellBorder setHasTopBorder(Boolean hasTopBorder) {
        this.hasTopBorder = hasTopBorder;
        return this;
    }

    public XEasyPdfCellBorder setHasBottomBorder(Boolean hasBottomBorder) {
        this.hasBottomBorder = hasBottomBorder;
        return this;
    }

    public XEasyPdfCellBorder setHasLeftBorder(Boolean hasLeftBorder) {
        this.hasLeftBorder = hasLeftBorder;
        return this;
    }

    public XEasyPdfCellBorder setHasRightBorder(Boolean hasRightBorder) {
        this.hasRightBorder = hasRightBorder;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfCellBorder)) {
            return false;
        }
        XEasyPdfCellBorder other = (XEasyPdfCellBorder)o;
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$borderWidth = this.getBorderWidth();
        Float other$borderWidth = other.getBorderWidth();
        if (this$borderWidth == null ? other$borderWidth != null : !((Object)this$borderWidth).equals(other$borderWidth)) {
            return false;
        }
        Float this$borderLineLength = this.getBorderLineLength();
        Float other$borderLineLength = other.getBorderLineLength();
        if (this$borderLineLength == null ? other$borderLineLength != null : !((Object)this$borderLineLength).equals(other$borderLineLength)) {
            return false;
        }
        Float this$borderLineSpace = this.getBorderLineSpace();
        Float other$borderLineSpace = other.getBorderLineSpace();
        if (this$borderLineSpace == null ? other$borderLineSpace != null : !((Object)this$borderLineSpace).equals(other$borderLineSpace)) {
            return false;
        }
        Boolean this$hasTopBorder = this.getHasTopBorder();
        Boolean other$hasTopBorder = other.getHasTopBorder();
        if (this$hasTopBorder == null ? other$hasTopBorder != null : !((Object)this$hasTopBorder).equals(other$hasTopBorder)) {
            return false;
        }
        Boolean this$hasBottomBorder = this.getHasBottomBorder();
        Boolean other$hasBottomBorder = other.getHasBottomBorder();
        if (this$hasBottomBorder == null ? other$hasBottomBorder != null : !((Object)this$hasBottomBorder).equals(other$hasBottomBorder)) {
            return false;
        }
        Boolean this$hasLeftBorder = this.getHasLeftBorder();
        Boolean other$hasLeftBorder = other.getHasLeftBorder();
        if (this$hasLeftBorder == null ? other$hasLeftBorder != null : !((Object)this$hasLeftBorder).equals(other$hasLeftBorder)) {
            return false;
        }
        Boolean this$hasRightBorder = this.getHasRightBorder();
        Boolean other$hasRightBorder = other.getHasRightBorder();
        if (this$hasRightBorder == null ? other$hasRightBorder != null : !((Object)this$hasRightBorder).equals(other$hasRightBorder)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        PDPageContentStream.AppendMode this$contentMode = this.getContentMode();
        PDPageContentStream.AppendMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !this$contentMode.equals(other$contentMode)) {
            return false;
        }
        Color this$leftBorderColor = this.getLeftBorderColor();
        Color other$leftBorderColor = other.getLeftBorderColor();
        if (this$leftBorderColor == null ? other$leftBorderColor != null : !((Object)this$leftBorderColor).equals(other$leftBorderColor)) {
            return false;
        }
        Color this$rightBorderColor = this.getRightBorderColor();
        Color other$rightBorderColor = other.getRightBorderColor();
        if (this$rightBorderColor == null ? other$rightBorderColor != null : !((Object)this$rightBorderColor).equals(other$rightBorderColor)) {
            return false;
        }
        Color this$topBorderColor = this.getTopBorderColor();
        Color other$topBorderColor = other.getTopBorderColor();
        if (this$topBorderColor == null ? other$topBorderColor != null : !((Object)this$topBorderColor).equals(other$topBorderColor)) {
            return false;
        }
        Color this$bottomBorderColor = this.getBottomBorderColor();
        Color other$bottomBorderColor = other.getBottomBorderColor();
        return !(this$bottomBorderColor == null ? other$bottomBorderColor != null : !((Object)this$bottomBorderColor).equals(other$bottomBorderColor));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $borderWidth = this.getBorderWidth();
        result = result * 59 + ($borderWidth == null ? 43 : ((Object)$borderWidth).hashCode());
        Float $borderLineLength = this.getBorderLineLength();
        result = result * 59 + ($borderLineLength == null ? 43 : ((Object)$borderLineLength).hashCode());
        Float $borderLineSpace = this.getBorderLineSpace();
        result = result * 59 + ($borderLineSpace == null ? 43 : ((Object)$borderLineSpace).hashCode());
        Boolean $hasTopBorder = this.getHasTopBorder();
        result = result * 59 + ($hasTopBorder == null ? 43 : ((Object)$hasTopBorder).hashCode());
        Boolean $hasBottomBorder = this.getHasBottomBorder();
        result = result * 59 + ($hasBottomBorder == null ? 43 : ((Object)$hasBottomBorder).hashCode());
        Boolean $hasLeftBorder = this.getHasLeftBorder();
        result = result * 59 + ($hasLeftBorder == null ? 43 : ((Object)$hasLeftBorder).hashCode());
        Boolean $hasRightBorder = this.getHasRightBorder();
        result = result * 59 + ($hasRightBorder == null ? 43 : ((Object)$hasRightBorder).hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        PDPageContentStream.AppendMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : $contentMode.hashCode());
        Color $leftBorderColor = this.getLeftBorderColor();
        result = result * 59 + ($leftBorderColor == null ? 43 : ((Object)$leftBorderColor).hashCode());
        Color $rightBorderColor = this.getRightBorderColor();
        result = result * 59 + ($rightBorderColor == null ? 43 : ((Object)$rightBorderColor).hashCode());
        Color $topBorderColor = this.getTopBorderColor();
        result = result * 59 + ($topBorderColor == null ? 43 : ((Object)$topBorderColor).hashCode());
        Color $bottomBorderColor = this.getBottomBorderColor();
        result = result * 59 + ($bottomBorderColor == null ? 43 : ((Object)$bottomBorderColor).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfCellBorder(document=" + this.getDocument() + ", page=" + this.getPage() + ", contentMode=" + this.getContentMode() + ", isResetContext=" + this.getIsResetContext() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", leftBorderColor=" + this.getLeftBorderColor() + ", rightBorderColor=" + this.getRightBorderColor() + ", topBorderColor=" + this.getTopBorderColor() + ", bottomBorderColor=" + this.getBottomBorderColor() + ", borderWidth=" + this.getBorderWidth() + ", borderLineLength=" + this.getBorderLineLength() + ", borderLineSpace=" + this.getBorderLineSpace() + ", hasTopBorder=" + this.getHasTopBorder() + ", hasBottomBorder=" + this.getHasBottomBorder() + ", hasLeftBorder=" + this.getHasLeftBorder() + ", hasRightBorder=" + this.getHasRightBorder() + ")";
    }
}

