/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.doc;

import java.io.Serializable;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentForm;

public class XEasyPdfDocumentFormTextField
implements Serializable {
    private static final long serialVersionUID = -6308558126594489097L;
    private static final int FLAG_PRINTED = 4;
    private final XEasyPdfDocumentForm form;
    private final PDTextField textField;
    private Float beginX = Float.valueOf(0.0f);
    private Float beginY = Float.valueOf(0.0f);
    private Float width = Float.valueOf(100.0f);
    private Float height = Float.valueOf(12.0f);
    private Integer pageIndex = 0;

    XEasyPdfDocumentFormTextField(XEasyPdfDocumentForm form) {
        this.form = form;
        this.textField = new PDTextField(this.form.getFormFiller().getForm());
    }

    public XEasyPdfDocumentFormTextField setMappingName(String mappingName) {
        this.textField.setPartialName(mappingName);
        return this;
    }

    public XEasyPdfDocumentFormTextField setAlternateName(String alternateName) {
        this.textField.setAlternateFieldName(alternateName);
        return this;
    }

    public XEasyPdfDocumentFormTextField setPosition(float beginX, float beginY) {
        this.beginX = Float.valueOf(beginX);
        this.beginY = Float.valueOf(beginY);
        return this;
    }

    public XEasyPdfDocumentFormTextField setWidth(float width) {
        this.width = Float.valueOf(Math.abs(width));
        return this;
    }

    public XEasyPdfDocumentFormTextField setHeight(float height) {
        this.height = Float.valueOf(Math.abs(height));
        return this;
    }

    public XEasyPdfDocumentFormTextField setPageIndex(int pageIndex) {
        this.pageIndex = Math.abs(pageIndex);
        return this;
    }

    public XEasyPdfDocumentFormTextField setDefaultValue(String defaultValue) {
        if (defaultValue != null) {
            this.textField.setDefaultValue(defaultValue);
        }
        return this;
    }

    public XEasyPdfDocumentFormTextField setRichTextValue(String richTextValue) {
        if (richTextValue != null) {
            this.textField.setRichTextValue(richTextValue);
        }
        return this;
    }

    public XEasyPdfDocumentFormTextField setMaxLength(int maxLength) {
        this.textField.setMaxLen(maxLength);
        return this;
    }

    public XEasyPdfDocumentFormTextField setStyle(TextStyle style) {
        this.textField.setQ(style.style.intValue());
        return this;
    }

    public XEasyPdfDocumentFormTextField enableReadOnly() {
        this.textField.setReadOnly(true);
        return this;
    }

    public XEasyPdfDocumentFormTextField enableRequired() {
        this.textField.setRequired(true);
        return this;
    }

    public XEasyPdfDocumentFormTextField enablePrint() {
        this.textField.getCOSObject().setFlag(COSName.F, 4, true);
        return this;
    }

    public XEasyPdfDocumentFormTextField enableRichText() {
        this.textField.setRichText(true);
        return this;
    }

    public XEasyPdfDocumentFormTextField enableMultiline() {
        this.textField.setMultiline(true);
        return this;
    }

    public XEasyPdfDocumentFormTextField enablePassword() {
        this.textField.setPassword(true);
        return this;
    }

    public XEasyPdfDocumentFormTextField enableCombo() {
        this.textField.setComb(true);
        return this;
    }

    public XEasyPdfDocumentFormTextField disableSpellCheck() {
        this.textField.setDoNotSpellCheck(true);
        return this;
    }

    public XEasyPdfDocumentFormTextField disableScroll() {
        this.textField.setDoNotScroll(true);
        return this;
    }

    public XEasyPdfDocumentFormTextField disableExport() {
        this.textField.setNoExport(true);
        return this;
    }

    public XEasyPdfDocumentForm finish() {
        PDPage page = this.form.getFormFiller().getDocument().getPage(this.pageIndex.intValue());
        PDAnnotationWidget widget = (PDAnnotationWidget)this.textField.getWidgets().get(0);
        widget.setRectangle(new PDRectangle(this.beginX.floatValue(), this.beginY.floatValue(), this.width.floatValue(), this.height.floatValue()));
        widget.setPage(page);
        page.getAnnotations().add(widget);
        this.form.getFormFiller().getForm().getFields().add(this.textField);
        return this.form;
    }

    public static enum TextStyle {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        private final Integer style;

        private TextStyle(Integer style) {
            this.style = style;
        }
    }
}

