/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.doc;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.rendering.RenderDestination;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImageType;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.util.XEasyPdfFileUtil;
import org.dromara.pdf.pdfbox.util.XEasyPdfImageUtil;

public class XEasyPdfDocumentImager
implements Serializable {
    private static final long serialVersionUID = 4542844990362703412L;
    private final PDDocument document;
    private final XEasyPdfDocument pdfDocument;
    private Float dpi = Float.valueOf(72.0f);
    private RenderType renderType = RenderType.EXPORT;
    private Boolean isMemoryOptimization = Boolean.FALSE;
    private Boolean isGray = Boolean.FALSE;
    private Boolean isAlpha = Boolean.FALSE;
    private Boolean isMerge = Boolean.FALSE;
    private Boolean isHorizontalMerge = Boolean.FALSE;

    XEasyPdfDocumentImager(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.document = this.pdfDocument.build(true);
    }

    public XEasyPdfDocumentImager setDpi(float dpi) {
        this.dpi = Float.valueOf(Math.abs(dpi));
        return this;
    }

    public XEasyPdfDocumentImager setRenderType(RenderType renderType) {
        this.renderType = renderType;
        return this;
    }

    public XEasyPdfDocumentImager enableOptimization() {
        this.isMemoryOptimization = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentImager enableGray() {
        this.isGray = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentImager enableAlpha() {
        this.isAlpha = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentImager enableHorizontalMerge() {
        this.isHorizontalMerge = Boolean.TRUE;
        this.isMerge = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentImager enableVerticalMerge() {
        this.isHorizontalMerge = Boolean.FALSE;
        this.isMerge = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentImager image(String outputPath, XEasyPdfImageType imageType) {
        return this.image(outputPath, imageType, null);
    }

    public XEasyPdfDocumentImager image(String outputPath, XEasyPdfImageType imageType, String prefix) {
        if (prefix == null) {
            prefix = "x-easypdf";
        }
        String imageTypeName = imageType.name().toLowerCase();
        PDFRenderer renderer = new PDFRenderer(this.document);
        renderer.setSubsamplingAllowed(this.isMemoryOptimization.booleanValue());
        renderer.setDefaultDestination(this.renderType.destination);
        int pageCount = this.document.getNumberOfPages();
        if (this.isMerge.booleanValue()) {
            ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>(pageCount);
            for (int i = 0; i < pageCount; ++i) {
                imageList.add(renderer.renderImageWithDPI(i, this.dpi.floatValue(), this.getColorType()));
            }
            BufferedImage bufferedImage = XEasyPdfImageUtil.join(imageList, this.isHorizontalMerge);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(XEasyPdfFileUtil.createDirectories(Paths.get(outputPath + File.separator + prefix + '.' + imageTypeName, new String[0])), new OpenOption[0]));){
                ImageIO.write((RenderedImage)bufferedImage, imageTypeName, outputStream);
            }
        } else {
            for (int i = 0; i < pageCount; ++i) {
                StringBuilder fileNameBuilder = new StringBuilder();
                fileNameBuilder.append(outputPath).append(File.separator).append(prefix).append(i + 1).append('.').append(imageTypeName);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(XEasyPdfFileUtil.createDirectories(Paths.get(fileNameBuilder.toString(), new String[0])), new OpenOption[0]));){
                    BufferedImage bufferedImage = renderer.renderImageWithDPI(i, this.dpi.floatValue(), this.getColorType());
                    ImageIO.write((RenderedImage)bufferedImage, imageTypeName, outputStream);
                    continue;
                }
            }
        }
        return this;
    }

    public XEasyPdfDocumentImager image(OutputStream outputStream, XEasyPdfImageType imageType, int ... pageIndex) {
        PDFRenderer renderer = new PDFRenderer(this.document);
        renderer.setSubsamplingAllowed(this.isMemoryOptimization.booleanValue());
        renderer.setDefaultDestination(this.renderType.destination);
        if (this.isMerge.booleanValue()) {
            ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>(pageIndex.length);
            for (int index : pageIndex) {
                imageList.add(renderer.renderImageWithDPI(Math.min(Math.max(index, 0), this.document.getNumberOfPages() - 1), this.dpi.floatValue(), this.getColorType()));
            }
            BufferedImage bufferedImage = XEasyPdfImageUtil.join(imageList, this.isHorizontalMerge);
            ImageIO.write((RenderedImage)bufferedImage, imageType.name().toLowerCase(), outputStream);
        } else {
            for (int index : pageIndex) {
                BufferedImage bufferedImage = renderer.renderImageWithDPI(Math.min(Math.max(index, 0), this.document.getNumberOfPages() - 1), this.dpi.floatValue(), this.getColorType());
                ImageIO.write((RenderedImage)bufferedImage, imageType.name().toLowerCase(), outputStream);
            }
        }
        return this;
    }

    public XEasyPdfDocument finish() {
        return this.pdfDocument;
    }

    private ImageType getColorType() {
        if (this.isAlpha.booleanValue()) {
            return ImageType.ARGB;
        }
        if (this.isGray.booleanValue()) {
            return ImageType.GRAY;
        }
        return ImageType.RGB;
    }

    public static enum RenderType {
        EXPORT(RenderDestination.EXPORT),
        VIEW(RenderDestination.VIEW),
        PRINT(RenderDestination.PRINT);

        private final RenderDestination destination;

        private RenderType(RenderDestination destination) {
            this.destination = destination;
        }
    }
}

