/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.header;

import java.util.Arrays;
import java.util.List;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImage;
import org.dromara.pdf.pdfbox.component.line.XEasyPdfLine;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfText;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPositionStyle;
import org.dromara.pdf.pdfbox.handler.XEasyPdfHandler;
import org.dromara.pdf.pdfbox.header.XEasyPdfHeader;
import org.dromara.pdf.pdfbox.header.XEasyPdfHeaderParam;

public class XEasyPdfDefaultHeader
implements XEasyPdfHeader {
    private static final long serialVersionUID = -7390695218795028439L;
    private final XEasyPdfHeaderParam param = new XEasyPdfHeaderParam();

    public XEasyPdfDefaultHeader() {
    }

    public XEasyPdfDefaultHeader(XEasyPdfComponent component) {
        this.param.setComponent(component);
    }

    public XEasyPdfDefaultHeader(XEasyPdfImage image) {
        this(image, null);
    }

    public XEasyPdfDefaultHeader(XEasyPdfText text) {
        this(null, text);
    }

    public XEasyPdfDefaultHeader(XEasyPdfImage image, XEasyPdfText text) {
        this.param.setImage(image).setText(text);
    }

    @Override
    public XEasyPdfDefaultHeader enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader addSplitLine(XEasyPdfLine ... splitLine) {
        if (splitLine != null) {
            this.param.getLineList().addAll(Arrays.asList(splitLine));
        }
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader addComponent(XEasyPdfComponent component) {
        this.param.setComponent(component);
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    @Override
    public float getHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.param.getHeight() == null) {
            this.param.init(document, page);
        }
        return this.param.getHeight().floatValue();
    }

    @Override
    public String getTotalPagePlaceholder() {
        return XEasyPdfHandler.Page.getTotalPagePlaceholder();
    }

    @Override
    public String getCurrentPagePlaceholder() {
        return XEasyPdfHandler.Page.getCurrentPagePlaceholder();
    }

    @Override
    public String getTextFontPath() {
        if (this.param.getText() != null) {
            return this.param.getText().getFontPath();
        }
        return null;
    }

    @Override
    public boolean check(XEasyPdfComponent component) {
        if (component != null) {
            if (component instanceof XEasyPdfImage) {
                return this.param.getImage() != null && this.param.getImage().equals(component);
            }
            if (component instanceof XEasyPdfText) {
                return this.param.getText() != null && this.param.getText().equals(component);
            }
        }
        return false;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.init(document, page);
        if (this.param.getText() != null) {
            XEasyPdfText text = this.param.getText();
            if (this.param.getIsResetContext().booleanValue()) {
                text.enableResetContext();
            }
            text.replaceAllPlaceholder(XEasyPdfHandler.Page.getCurrentPagePlaceholder(), page.getCurrentIndex(document) + "").setCheckPage(false);
            text.setPosition(this.param.getTextBeginX().floatValue(), this.initYForText(document, page, text)).enableChildComponent().draw(document, page);
        }
        if (this.param.getImage() != null) {
            XEasyPdfImage image = this.param.getImage();
            if (this.param.getIsResetContext().booleanValue()) {
                image.enableResetContext();
            }
            image.setContentMode(XEasyPdfComponent.ContentMode.PREPEND).setPosition(this.param.getImageBeginX().floatValue(), this.param.getImageBeginY().floatValue() - (float)this.param.getImage().getHeight(document, page).intValue()).draw(document, page);
        }
        if (this.param.getComponent() != null) {
            this.param.getComponent().draw(document, page);
        }
        if (!this.param.getLineList().isEmpty()) {
            List<XEasyPdfLine> lineList = this.param.getLineList();
            for (XEasyPdfLine xEasyPdfLine : lineList) {
                if (this.param.getIsResetContext().booleanValue()) {
                    xEasyPdfLine.enableResetContext();
                }
                xEasyPdfLine.setMarginLeft(this.param.getMarginLeft().floatValue()).setMarginRight(this.param.getMarginRight().floatValue()).draw(document, page);
            }
        }
        if (this.param.hasNotComponent()) {
            page.setPageY(Float.valueOf(page.getHeight() - this.param.getHeight().floatValue()));
        }
    }

    private float initYForText(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfText text) {
        float height = this.param.getHeight().floatValue();
        float textHeight = text.getHeight(document, page);
        float y = this.param.getTextBeginY().floatValue() + text.getLeading() / 2.0f;
        if (text.getVerticalStyle() == XEasyPdfPositionStyle.TOP) {
            return y -= text.getFontSize();
        }
        if (text.getVerticalStyle() == XEasyPdfPositionStyle.CENTER) {
            y = y - text.getFontSize() - (height - textHeight) / 2.0f;
            return y;
        }
        if (text.getVerticalStyle() == XEasyPdfPositionStyle.BOTTOM) {
            y = y - text.getFontSize() - height + textHeight;
        }
        return y;
    }
}

