/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.header;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImage;
import org.dromara.pdf.pdfbox.component.line.XEasyPdfLine;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfText;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;

class XEasyPdfHeaderParam
implements Serializable {
    private static final long serialVersionUID = -5055961872807917576L;
    private Boolean isResetContext;
    private XEasyPdfText text;
    private XEasyPdfImage image;
    private XEasyPdfComponent component;
    private List<XEasyPdfLine> lineList = new ArrayList<XEasyPdfLine>(6);
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(5.0f);
    private Float imageBeginX;
    private Float imageBeginY;
    private Float textBeginX;
    private Float textBeginY;
    private Float height;

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.isResetContext == null) {
            this.isResetContext = page.isResetContext();
        }
        this.initHeight(document, page);
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        float beginY = rectangle.getHeight() - this.marginTop.floatValue();
        if (this.image != null && this.imageBeginX == null && this.imageBeginY == null) {
            this.imageBeginX = this.marginLeft;
            this.imageBeginY = Float.valueOf(beginY);
        }
        if (this.text != null && this.textBeginX == null && this.textBeginY == null) {
            this.textBeginX = this.marginLeft;
            this.textBeginY = Float.valueOf(beginY);
        }
    }

    boolean hasNotComponent() {
        return this.text == null && this.image == null && this.component == null && this.lineList.isEmpty();
    }

    private void initHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.height == null) {
            float textHeight = 0.0f;
            if (this.text != null) {
                textHeight = this.text.getHeight(document, page);
            }
            float imageHeight = 0.0f;
            if (this.image != null) {
                this.image.disableSelfAdaption();
                if (this.image.getWidth(document, page) == null) {
                    this.image.setWidth(page.getLastPage().getMediaBox().getWidth());
                }
                imageHeight = this.image.getHeight(document, page).intValue();
            }
            this.height = Float.valueOf(Math.max(textHeight, imageHeight) + this.marginTop.floatValue());
        }
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public XEasyPdfText getText() {
        return this.text;
    }

    public XEasyPdfImage getImage() {
        return this.image;
    }

    public XEasyPdfComponent getComponent() {
        return this.component;
    }

    public List<XEasyPdfLine> getLineList() {
        return this.lineList;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getImageBeginX() {
        return this.imageBeginX;
    }

    public Float getImageBeginY() {
        return this.imageBeginY;
    }

    public Float getTextBeginX() {
        return this.textBeginX;
    }

    public Float getTextBeginY() {
        return this.textBeginY;
    }

    public Float getHeight() {
        return this.height;
    }

    public XEasyPdfHeaderParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfHeaderParam setText(XEasyPdfText text) {
        this.text = text;
        return this;
    }

    public XEasyPdfHeaderParam setImage(XEasyPdfImage image) {
        this.image = image;
        return this;
    }

    public XEasyPdfHeaderParam setComponent(XEasyPdfComponent component) {
        this.component = component;
        return this;
    }

    public XEasyPdfHeaderParam setLineList(List<XEasyPdfLine> lineList) {
        this.lineList = lineList;
        return this;
    }

    public XEasyPdfHeaderParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfHeaderParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfHeaderParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfHeaderParam setImageBeginX(Float imageBeginX) {
        this.imageBeginX = imageBeginX;
        return this;
    }

    public XEasyPdfHeaderParam setImageBeginY(Float imageBeginY) {
        this.imageBeginY = imageBeginY;
        return this;
    }

    public XEasyPdfHeaderParam setTextBeginX(Float textBeginX) {
        this.textBeginX = textBeginX;
        return this;
    }

    public XEasyPdfHeaderParam setTextBeginY(Float textBeginY) {
        this.textBeginY = textBeginY;
        return this;
    }

    public XEasyPdfHeaderParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfHeaderParam)) {
            return false;
        }
        XEasyPdfHeaderParam other = (XEasyPdfHeaderParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$imageBeginX = this.getImageBeginX();
        Float other$imageBeginX = other.getImageBeginX();
        if (this$imageBeginX == null ? other$imageBeginX != null : !((Object)this$imageBeginX).equals(other$imageBeginX)) {
            return false;
        }
        Float this$imageBeginY = this.getImageBeginY();
        Float other$imageBeginY = other.getImageBeginY();
        if (this$imageBeginY == null ? other$imageBeginY != null : !((Object)this$imageBeginY).equals(other$imageBeginY)) {
            return false;
        }
        Float this$textBeginX = this.getTextBeginX();
        Float other$textBeginX = other.getTextBeginX();
        if (this$textBeginX == null ? other$textBeginX != null : !((Object)this$textBeginX).equals(other$textBeginX)) {
            return false;
        }
        Float this$textBeginY = this.getTextBeginY();
        Float other$textBeginY = other.getTextBeginY();
        if (this$textBeginY == null ? other$textBeginY != null : !((Object)this$textBeginY).equals(other$textBeginY)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        XEasyPdfText this$text = this.getText();
        XEasyPdfText other$text = other.getText();
        if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
            return false;
        }
        XEasyPdfImage this$image = this.getImage();
        XEasyPdfImage other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        XEasyPdfComponent this$component = this.getComponent();
        XEasyPdfComponent other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        List<XEasyPdfLine> this$lineList = this.getLineList();
        List<XEasyPdfLine> other$lineList = other.getLineList();
        return !(this$lineList == null ? other$lineList != null : !((Object)this$lineList).equals(other$lineList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfHeaderParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $imageBeginX = this.getImageBeginX();
        result = result * 59 + ($imageBeginX == null ? 43 : ((Object)$imageBeginX).hashCode());
        Float $imageBeginY = this.getImageBeginY();
        result = result * 59 + ($imageBeginY == null ? 43 : ((Object)$imageBeginY).hashCode());
        Float $textBeginX = this.getTextBeginX();
        result = result * 59 + ($textBeginX == null ? 43 : ((Object)$textBeginX).hashCode());
        Float $textBeginY = this.getTextBeginY();
        result = result * 59 + ($textBeginY == null ? 43 : ((Object)$textBeginY).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        XEasyPdfText $text = this.getText();
        result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
        XEasyPdfImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        XEasyPdfComponent $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        List<XEasyPdfLine> $lineList = this.getLineList();
        result = result * 59 + ($lineList == null ? 43 : ((Object)$lineList).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfHeaderParam(isResetContext=" + this.getIsResetContext() + ", text=" + this.getText() + ", image=" + this.getImage() + ", component=" + this.getComponent() + ", lineList=" + this.getLineList() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", imageBeginX=" + this.getImageBeginX() + ", imageBeginY=" + this.getImageBeginY() + ", textBeginX=" + this.getTextBeginX() + ", textBeginY=" + this.getTextBeginY() + ", height=" + this.getHeight() + ")";
    }
}

