/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImageType;

public class XEasyPdfImageUtil {
    public static BufferedImage read(File imageFile) {
        if (imageFile == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        return ImageIO.read(imageFile);
    }

    public static BufferedImage read(InputStream imageStream) {
        if (imageStream == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        return ImageIO.read(imageStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage read(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(bytes));){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
    }

    public static void write(BufferedImage image, XEasyPdfImageType imageType, OutputStream outputStream) {
        ImageIO.write((RenderedImage)image, imageType.name(), outputStream);
    }

    public static String parseType(File imageFile) {
        if (imageFile == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        String name = imageFile.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            throw new IllegalArgumentException("Image type not supported: " + name);
        }
        return name.substring(dot + 1).toLowerCase();
    }

    public static BufferedImage scale(BufferedImage sourceImage, int width, int height, int scaleMode) {
        if (sourceImage == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        Image temp = sourceImage.getScaledInstance(width, height, scaleMode);
        BufferedImage image = new BufferedImage(width, height, sourceImage.getType());
        Graphics2D graphics = XEasyPdfImageUtil.createGraphics(image);
        graphics.drawImage(temp, 0, 0, null);
        graphics.dispose();
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(BufferedImage sourceImage, String imageType) {
        if (sourceImage == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)sourceImage, imageType, outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream toInputStream(BufferedImage sourceImage, String imageType) {
        if (sourceImage == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)sourceImage, imageType, outputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static BufferedImage rotate(BufferedImage sourceImage, double radians) {
        if (sourceImage == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        Rectangle rectangle = XEasyPdfImageUtil.getRotateRectangle(imageWidth, imageHeight, radians);
        BufferedImage image = new BufferedImage(rectangle.width, rectangle.height, sourceImage.getType());
        Graphics2D graphics = XEasyPdfImageUtil.createGraphics(image);
        graphics.translate((double)(rectangle.width - imageWidth) / 2.0, (double)(rectangle.height - imageHeight) / 2.0);
        graphics.rotate(Math.toRadians(radians), (double)imageWidth / 2.0, (double)imageHeight / 2.0);
        graphics.drawImage((Image)sourceImage, 0, 0, null);
        graphics.dispose();
        sourceImage.flush();
        return image;
    }

    public static BufferedImage join(List<BufferedImage> sourceImageList, boolean isHorizontal) {
        BufferedImage firstImage = sourceImageList.get(0);
        int imageWidth = 0;
        int imageHeight = 0;
        if (isHorizontal) {
            imageHeight = firstImage.getHeight();
            for (BufferedImage sourceImage : sourceImageList) {
                imageWidth += sourceImage.getWidth();
            }
        } else {
            imageWidth = firstImage.getWidth();
            for (BufferedImage sourceImage : sourceImageList) {
                imageHeight += sourceImage.getHeight();
            }
        }
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, firstImage.getType());
        Graphics2D graphics = XEasyPdfImageUtil.createGraphics(image);
        int x = 0;
        int y = 0;
        for (BufferedImage sourceImage : sourceImageList) {
            graphics.drawImage((Image)sourceImage, x, y, null);
            if (isHorizontal) {
                x += sourceImage.getWidth();
            } else {
                y += sourceImage.getHeight();
            }
            sourceImage.flush();
        }
        graphics.dispose();
        return image;
    }

    private static Graphics2D createGraphics(BufferedImage image) {
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return graphics;
    }

    private static Rectangle getRotateRectangle(int width, int height, double radians) {
        Rectangle src = new Rectangle(new Dimension(width, height));
        int angle = 90;
        int num = 2;
        if (radians >= 90.0) {
            if (radians / 90.0 % 2.0 == 1.0) {
                return new Rectangle((int)src.getHeight(), (int)src.getWidth());
            }
            radians %= 90.0;
        }
        double radius = Math.sqrt(src.getHeight() * src.getHeight() + src.getWidth() * src.getWidth()) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(radians) / 2.0) * radius;
        double radiansAlpha = (Math.PI - Math.toRadians(radians)) / 2.0;
        double radiansWidth = Math.atan(src.getHeight() / src.getWidth());
        double radiansHeight = Math.atan(src.getWidth() / src.getHeight());
        int lenWidth = Math.abs((int)(len * Math.cos(Math.PI - radiansAlpha - radiansWidth)));
        int lenHeight = Math.abs((int)(len * Math.cos(Math.PI - radiansAlpha - radiansHeight)));
        return new Rectangle(src.width + lenWidth * 2, src.height + lenHeight * 2);
    }
}

