package org.dromara.pdf.pdfbox.component.image;

/**
 * 图片类型枚举
 *
 * @author xsx
 * @date 2021/6/30
 * @since 1.8
 * <p>
 * Copyright (c) 2020-2023 xsx All Rights Reserved.
 * x-easypdf is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 * </p>
 */
public enum XEasyPdfImageType {
    /**
     * 联合图像专家组
     */
    JPEG,
    /**
     * 标签图像文件格式
     */
    TIFF,
    /**
     * Photoshop专用格式
     */
    PSD,
    /**
     * 便携式网络图形
     */
    PNG,
    /**
     * 位图图像
     */
    BMP,
    /**
     * 可交换图像数据格式
     */
    GIF,
    /**
     * 图标文件格式
     */
    ICO,
    /**
     * 最早的图像格式
     */
    PCX,
    /**
     * 资源交换档案标准
     */
    RIFF,
    /**
     * 索尼相机格式
     */
    ARW,
    /**
     * 佳能相机格式1
     */
    CRW,
    /**
     * 佳能相机格式2
     */
    CR2,
    /**
     * 尼康相机格式
     */
    NEF,
    /**
     * 奥林巴斯相机格式
     */
    ORF,
    /**
     * 富士胶片格式
     */
    RAF,
    /**
     * 松下相机格式
     */
    RW2
}
