/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.circle;

import java.awt.Color;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.circle.XEasyPdfCircleParam;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;

public class XEasyPdfCircle
implements XEasyPdfComponent {
    private static final long serialVersionUID = -4357177673484194277L;
    private final XEasyPdfCircleParam param = new XEasyPdfCircleParam();

    public XEasyPdfCircle(float radius) {
        this(radius, null, null);
    }

    public XEasyPdfCircle(float radius, Float beginX, Float beginY) {
        this.param.setRadius(Float.valueOf(Math.abs(radius))).setBeginX(beginX).setBeginY(beginY);
    }

    public XEasyPdfCircle enableCheckPage() {
        this.param.setCheckPage(Boolean.TRUE);
        return this;
    }

    public XEasyPdfCircle disableCheckPage() {
        this.param.setCheckPage(Boolean.FALSE);
        return this;
    }

    @Override
    public XEasyPdfCircle enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfCircle setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCircle setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCircle setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCircle setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCircle setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCircle setRadius(float radius) {
        this.param.setRadius(Float.valueOf(Math.abs(radius)));
        return this;
    }

    public XEasyPdfCircle setHasBorder(boolean hasBorder) {
        this.param.setHasBorder(hasBorder);
        return this;
    }

    public XEasyPdfCircle setBorderWidth(float borderWidth) {
        this.param.setBorderWidth(Float.valueOf(Math.abs(borderWidth)));
        return this;
    }

    public XEasyPdfCircle setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.param.setBackgroundColor(backgroundColor);
        }
        return this;
    }

    public XEasyPdfCircle setBorderColor(Color borderColor) {
        if (borderColor != null) {
            this.param.setBorderColor(borderColor);
        }
        return this;
    }

    @Override
    public XEasyPdfCircle setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfCircle setWidth(float width) {
        this.param.setRadius(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfCircle setHeight(float height) {
        this.param.setRadius(Float.valueOf(Math.abs(height)));
        return this;
    }

    @Override
    public XEasyPdfCircle setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.init(document, page);
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.param.getContentMode().getMode(), true, this.param.getIsResetContext().booleanValue());
        if (this.param.getHasBorder().booleanValue()) {
            this.drawCircle(contentStream, this.param.getBorderColor());
            this.param.setRadius(Float.valueOf(this.param.getRadius().floatValue() - this.param.getBorderWidth().floatValue()));
            this.drawCircle(contentStream, this.param.getBackgroundColor());
        } else {
            this.drawCircle(contentStream, this.param.getBackgroundColor());
        }
        contentStream.setNonStrokingColor(Color.BLACK);
        contentStream.close();
        if (page.isAllowResetPosition()) {
            if (this.param.getIsNewLine().booleanValue()) {
                page.setPageX(null);
                page.setPageY(this.param.getBeginY());
            } else {
                page.setPageX(Float.valueOf(this.param.getBeginX().floatValue() + this.param.getRadius().floatValue()));
            }
        }
    }

    private void drawCircle(PDPageContentStream contentStream, Color color) {
        List<Point> dataPoints = this.param.initDataPoints();
        List<Point> ctrlPoints = this.param.initCtrlPoints(dataPoints);
        Point dataTop = dataPoints.get(0);
        Point ctrlTopRight = ctrlPoints.get(0);
        Point ctrlRightTop = ctrlPoints.get(1);
        Point dataRight = dataPoints.get(1);
        Point ctrlRightBottom = ctrlPoints.get(2);
        Point ctrlBottomRight = ctrlPoints.get(3);
        Point dataBottom = dataPoints.get(2);
        Point ctrlBottomLeft = ctrlPoints.get(4);
        Point ctrlLeftBottom = ctrlPoints.get(5);
        Point dataLeft = dataPoints.get(3);
        Point ctrlLeftTop = ctrlPoints.get(6);
        Point ctrlTopLeft = ctrlPoints.get(7);
        contentStream.moveTo(dataTop.getX().floatValue(), dataTop.getY().floatValue());
        contentStream.curveTo(ctrlTopRight.getX().floatValue(), ctrlTopRight.getY().floatValue(), ctrlRightTop.getX().floatValue(), ctrlRightTop.getY().floatValue(), dataRight.getX().floatValue(), dataRight.getY().floatValue());
        contentStream.curveTo(ctrlRightBottom.getX().floatValue(), ctrlRightBottom.getY().floatValue(), ctrlBottomRight.getX().floatValue(), ctrlBottomRight.getY().floatValue(), dataBottom.getX().floatValue(), dataBottom.getY().floatValue());
        contentStream.curveTo(ctrlBottomLeft.getX().floatValue(), ctrlBottomLeft.getY().floatValue(), ctrlLeftBottom.getX().floatValue(), ctrlLeftBottom.getY().floatValue(), dataLeft.getX().floatValue(), dataLeft.getY().floatValue());
        contentStream.curveTo(ctrlLeftTop.getX().floatValue(), ctrlLeftTop.getY().floatValue(), ctrlTopLeft.getX().floatValue(), ctrlTopLeft.getY().floatValue(), dataTop.getX().floatValue(), dataTop.getY().floatValue());
        contentStream.setNonStrokingColor(color);
        contentStream.fill();
    }

    static class Point {
        private Float x;
        private Float y;

        public Float getX() {
            return this.x;
        }

        public Float getY() {
            return this.y;
        }

        public void setX(Float x) {
            this.x = x;
        }

        public void setY(Float y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point other = (Point)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Float this$x = this.getX();
            Float other$x = other.getX();
            if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
                return false;
            }
            Float this$y = this.getY();
            Float other$y = other.getY();
            return !(this$y == null ? other$y != null : !((Object)this$y).equals(other$y));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Point;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Float $x = this.getX();
            result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
            Float $y = this.getY();
            result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
            return result;
        }

        public String toString() {
            return "XEasyPdfCircle.Point(x=" + this.getX() + ", y=" + this.getY() + ")";
        }

        public Point(Float x, Float y) {
            this.x = x;
            this.y = y;
        }
    }
}

