/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.line;

import java.awt.Color;
import java.io.Serializable;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.line.XEasyPdfLineCapStyle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;

class XEasyPdfLineParam
implements Serializable {
    private static final long serialVersionUID = 1496963673664295875L;
    private XEasyPdfComponent.ContentMode contentMode;
    private Boolean isResetContext;
    private String fontPath;
    private Float fontSize = Float.valueOf(1.0f);
    private Float beginX;
    private Float beginY;
    private Float endX;
    private Float endY;
    private Float width;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Float lineWidth = Float.valueOf(1.0f);
    private XEasyPdfLineCapStyle style = XEasyPdfLineCapStyle.NORMAL;
    private Color color = Color.BLACK;

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.contentMode == null) {
            this.contentMode = page.getContentMode();
        }
        if (this.isResetContext == null) {
            this.isResetContext = page.isResetContext();
        }
        if (this.fontPath == null) {
            this.fontPath = page.getFontPath();
        }
    }

    void checkPage(XEasyPdfDocument document, XEasyPdfPage page) {
        float footerHeight = 0.0f;
        if (page.isAllowFooter() && page.getFooter() != null) {
            footerHeight = page.getFooter().getHeight(document, page);
        }
        if (page.getPageY() != null) {
            float lineWidth = this.lineWidth.floatValue() / 2.0f;
            if (page.getPageY().floatValue() - this.marginTop.floatValue() - lineWidth - footerHeight <= this.marginBottom.floatValue()) {
                page.addNewPage(document, page.getLastPage().getMediaBox());
            }
        }
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Float getEndX() {
        return this.endX;
    }

    public Float getEndY() {
        return this.endY;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public XEasyPdfLineCapStyle getStyle() {
        return this.style;
    }

    public Color getColor() {
        return this.color;
    }

    public XEasyPdfLineParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfLineParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfLineParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfLineParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfLineParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfLineParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfLineParam setEndX(Float endX) {
        this.endX = endX;
        return this;
    }

    public XEasyPdfLineParam setEndY(Float endY) {
        this.endY = endY;
        return this;
    }

    public XEasyPdfLineParam setWidth(Float width) {
        this.width = width;
        return this;
    }

    public XEasyPdfLineParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfLineParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfLineParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfLineParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfLineParam setLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public XEasyPdfLineParam setStyle(XEasyPdfLineCapStyle style) {
        this.style = style;
        return this;
    }

    public XEasyPdfLineParam setColor(Color color) {
        this.color = color;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfLineParam)) {
            return false;
        }
        XEasyPdfLineParam other = (XEasyPdfLineParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$endX = this.getEndX();
        Float other$endX = other.getEndX();
        if (this$endX == null ? other$endX != null : !((Object)this$endX).equals(other$endX)) {
            return false;
        }
        Float this$endY = this.getEndY();
        Float other$endY = other.getEndY();
        if (this$endY == null ? other$endY != null : !((Object)this$endY).equals(other$endY)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$lineWidth = this.getLineWidth();
        Float other$lineWidth = other.getLineWidth();
        if (this$lineWidth == null ? other$lineWidth != null : !((Object)this$lineWidth).equals(other$lineWidth)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        XEasyPdfLineCapStyle this$style = this.getStyle();
        XEasyPdfLineCapStyle other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfLineParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $endX = this.getEndX();
        result = result * 59 + ($endX == null ? 43 : ((Object)$endX).hashCode());
        Float $endY = this.getEndY();
        result = result * 59 + ($endY == null ? 43 : ((Object)$endY).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $lineWidth = this.getLineWidth();
        result = result * 59 + ($lineWidth == null ? 43 : ((Object)$lineWidth).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        XEasyPdfLineCapStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfLineParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContext=" + this.getIsResetContext() + ", fontPath=" + this.getFontPath() + ", fontSize=" + this.getFontSize() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", endX=" + this.getEndX() + ", endY=" + this.getEndY() + ", width=" + this.getWidth() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", lineWidth=" + this.getLineWidth() + ", style=" + (Object)((Object)this.getStyle()) + ", color=" + this.getColor() + ")";
    }
}

