/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.component.rect;

import java.awt.Color;
import java.io.Serializable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;

class XEasyPdfRectParam
implements Serializable {
    private static final long serialVersionUID = 1621265990621255413L;
    private XEasyPdfComponent.ContentMode contentMode;
    private Boolean isResetContext;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Float width;
    private Float height;
    private Float beginX;
    private Float beginY;
    private Boolean hasBorder = Boolean.FALSE;
    private Float borderWidth = Float.valueOf(1.0f);
    private Color backgroundColor = Color.WHITE;
    private Color borderColor = Color.BLACK;
    private Boolean checkPage = Boolean.TRUE;
    private Boolean isNewLine = Boolean.TRUE;

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        Float pageY;
        if (this.width == null) {
            throw new RuntimeException("the width can not be null");
        }
        if (this.height == null) {
            throw new RuntimeException("the height can not be null");
        }
        if (this.contentMode == null) {
            this.contentMode = page.getContentMode();
        }
        if (this.isResetContext == null) {
            this.isResetContext = page.isResetContext();
        }
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        float footerHeight = 0.0f;
        if (this.beginY == null) {
            if (page.isAllowFooter() && page.getFooter() != null) {
                footerHeight = page.getFooter().getHeight(document, page);
            }
            this.beginY = Float.valueOf((pageY = page.getPageY()) == null ? rectangle.getHeight() - this.marginTop.floatValue() - this.height.floatValue() : pageY.floatValue() - this.marginTop.floatValue() - this.height.floatValue());
        }
        if (this.checkPage.booleanValue() && this.beginY.floatValue() - footerHeight <= this.marginBottom.floatValue()) {
            page.addNewPage(document, rectangle);
            pageY = page.getPageY();
            this.beginY = Float.valueOf(pageY == null ? rectangle.getHeight() - this.marginTop.floatValue() - this.height.floatValue() : pageY.floatValue() - this.marginTop.floatValue() - this.height.floatValue());
        }
        if (this.beginX == null) {
            Float pageX = page.getPageX();
            this.beginX = Float.valueOf(pageX == null ? this.marginLeft.floatValue() : pageX.floatValue() + this.marginLeft.floatValue());
        }
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Boolean getHasBorder() {
        return this.hasBorder;
    }

    public Float getBorderWidth() {
        return this.borderWidth;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Boolean getCheckPage() {
        return this.checkPage;
    }

    public Boolean getIsNewLine() {
        return this.isNewLine;
    }

    public XEasyPdfRectParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfRectParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfRectParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfRectParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfRectParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfRectParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfRectParam setWidth(Float width) {
        this.width = width;
        return this;
    }

    public XEasyPdfRectParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfRectParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfRectParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfRectParam setHasBorder(Boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public XEasyPdfRectParam setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public XEasyPdfRectParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public XEasyPdfRectParam setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public XEasyPdfRectParam setCheckPage(Boolean checkPage) {
        this.checkPage = checkPage;
        return this;
    }

    public XEasyPdfRectParam setIsNewLine(Boolean isNewLine) {
        this.isNewLine = isNewLine;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfRectParam)) {
            return false;
        }
        XEasyPdfRectParam other = (XEasyPdfRectParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$hasBorder = this.getHasBorder();
        Boolean other$hasBorder = other.getHasBorder();
        if (this$hasBorder == null ? other$hasBorder != null : !((Object)this$hasBorder).equals(other$hasBorder)) {
            return false;
        }
        Float this$borderWidth = this.getBorderWidth();
        Float other$borderWidth = other.getBorderWidth();
        if (this$borderWidth == null ? other$borderWidth != null : !((Object)this$borderWidth).equals(other$borderWidth)) {
            return false;
        }
        Boolean this$checkPage = this.getCheckPage();
        Boolean other$checkPage = other.getCheckPage();
        if (this$checkPage == null ? other$checkPage != null : !((Object)this$checkPage).equals(other$checkPage)) {
            return false;
        }
        Boolean this$isNewLine = this.getIsNewLine();
        Boolean other$isNewLine = other.getIsNewLine();
        if (this$isNewLine == null ? other$isNewLine != null : !((Object)this$isNewLine).equals(other$isNewLine)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        return !(this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfRectParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $hasBorder = this.getHasBorder();
        result = result * 59 + ($hasBorder == null ? 43 : ((Object)$hasBorder).hashCode());
        Float $borderWidth = this.getBorderWidth();
        result = result * 59 + ($borderWidth == null ? 43 : ((Object)$borderWidth).hashCode());
        Boolean $checkPage = this.getCheckPage();
        result = result * 59 + ($checkPage == null ? 43 : ((Object)$checkPage).hashCode());
        Boolean $isNewLine = this.getIsNewLine();
        result = result * 59 + ($isNewLine == null ? 43 : ((Object)$isNewLine).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfRectParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContext=" + this.getIsResetContext() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", hasBorder=" + this.getHasBorder() + ", borderWidth=" + this.getBorderWidth() + ", backgroundColor=" + this.getBackgroundColor() + ", borderColor=" + this.getBorderColor() + ", checkPage=" + this.getCheckPage() + ", isNewLine=" + this.getIsNewLine() + ")";
    }
}

