/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.doc;

import java.awt.Color;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.PrintServiceLookup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.xml.XmpSerializer;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDefaultFontStyle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentAnalyzer;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentBookmark;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentExtractor;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentFormFiller;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentImager;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentInfo;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentParam;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentPermission;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentReplacer;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentSigner;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentSplitter;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPageRectangle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPrintStyle;
import org.dromara.pdf.pdfbox.footer.XEasyPdfFooter;
import org.dromara.pdf.pdfbox.handler.XEasyPdfHandler;
import org.dromara.pdf.pdfbox.header.XEasyPdfHeader;
import org.dromara.pdf.pdfbox.mark.XEasyPdfWatermark;
import org.dromara.pdf.pdfbox.util.XEasyPdfFileUtil;

public class XEasyPdfDocument
implements Closeable,
Serializable {
    private static final long serialVersionUID = -4298644812517253946L;
    private final Log log = LogFactory.getLog(XEasyPdfDocument.class);
    private final XEasyPdfDocumentParam param = new XEasyPdfDocumentParam();

    public XEasyPdfDocument() {
        this.param.setSource(new PDDocument());
    }

    public XEasyPdfDocument(String filePath) {
        this(filePath, "");
    }

    public XEasyPdfDocument(String filePath, String password) {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
            this.param.init(inputStream, password, this);
        }
    }

    public XEasyPdfDocument(String filePath, String password, InputStream keyStore, String alias) {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
            this.param.init(inputStream, password, keyStore, alias, this);
        }
    }

    public XEasyPdfDocument(InputStream inputStream) {
        this.param.init(inputStream, "", this);
    }

    public XEasyPdfDocument(InputStream inputStream, String password) {
        this(inputStream, password, null, null);
    }

    public XEasyPdfDocument(InputStream inputStream, String password, InputStream keyStore, String alias) {
        this.param.init(inputStream, password, keyStore, alias, this);
    }

    public XEasyPdfDocument enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfDocument enableReplaceTotalPagePlaceholder() {
        this.param.setIsReplaceTotalPagePlaceholder(Boolean.TRUE);
        return this;
    }

    public XEasyPdfDocument setGlobalContentMode(XEasyPdfComponent.ContentMode contentMode) {
        if (contentMode != null) {
            this.param.setContentMode(contentMode);
        }
        return this;
    }

    public XEasyPdfComponent.ContentMode getGlobalContentMode() {
        return this.param.getContentMode();
    }

    public XEasyPdfDocument setGlobalBackgroundColor(Color globalBackgroundColor) {
        if (globalBackgroundColor != null) {
            this.param.setIsReset(Boolean.TRUE);
            this.param.setGlobalBackgroundColor(globalBackgroundColor);
        }
        return this;
    }

    public Color getGlobalBackgroundColor() {
        return this.param.getGlobalBackgroundColor();
    }

    public XEasyPdfDocument setGlobalBackgroundImage(XEasyPdfImage globalBackgroundImage) {
        this.param.setIsReset(Boolean.TRUE);
        this.param.setGlobalBackgroundImage(globalBackgroundImage);
        return this;
    }

    public XEasyPdfImage getGlobalBackgroundImage() {
        return this.param.getGlobalBackgroundImage();
    }

    public XEasyPdfDocument setGlobalWatermark(XEasyPdfWatermark globalWatermark) {
        this.param.setIsReset(Boolean.TRUE);
        this.param.setGlobalWatermark(globalWatermark);
        return this;
    }

    public XEasyPdfWatermark getGlobalWatermark() {
        return this.param.getGlobalWatermark();
    }

    public XEasyPdfDocument setGlobalHeader(XEasyPdfHeader globalHeader) {
        this.param.setIsReset(Boolean.TRUE);
        this.param.setGlobalHeader(globalHeader);
        return this;
    }

    public XEasyPdfHeader getGlobalHeader() {
        return this.param.getGlobalHeader();
    }

    public XEasyPdfDocument setGlobalFooter(XEasyPdfFooter globalFooter) {
        this.param.setIsReset(Boolean.TRUE);
        this.param.setGlobalFooter(globalFooter);
        return this;
    }

    public XEasyPdfFooter getGlobalFooter() {
        return this.param.getGlobalFooter();
    }

    public XEasyPdfDocument setFontPath(String fontPath) {
        this.param.setIsReset(Boolean.TRUE);
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfDocument setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        this.param.setIsReset(Boolean.TRUE);
        this.param.setDefaultFontStyle(style);
        return this;
    }

    public XEasyPdfDocument setVersion(float version) {
        float maxVersion = 1.7f;
        float minVersion = 1.0f;
        if (version < minVersion || version > maxVersion) {
            throw new IllegalArgumentException("the version must be between 1.0 and 1.7");
        }
        this.param.setVersion(Float.valueOf(version));
        return this;
    }

    public XEasyPdfDocument setTempDir(String tempDir) {
        if (!Files.isDirectory(Paths.get(tempDir, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("the url must be directory");
        }
        this.param.setTempDir(tempDir);
        return this;
    }

    public void addFont(String fontPath, PDFont font) {
        this.param.getFontCache().put(fontPath, font);
    }

    public void addOtfFont(String fontPath, PDFont font) {
        this.param.getOtfFontCache().put(fontPath, font);
    }

    public PDFont getFont() {
        return this.param.getFont();
    }

    public PDFont getFont(String fontPath) {
        return this.param.getFontCache().get(fontPath);
    }

    public PDFont getOtfFont(String fontPath) {
        return this.param.getOtfFontCache().get(fontPath);
    }

    public String getFontPath() {
        return this.param.getFontPath();
    }

    public PDDocument getTarget() {
        if (this.param.getTarget() == null || this.param.getIsReset().booleanValue()) {
            this.param.initTarget(this);
        }
        return this.param.getTarget();
    }

    public List<XEasyPdfPage> getPageList() {
        return this.param.getPageList();
    }

    public int getTotalPage() {
        return this.param.getTotalPage();
    }

    public XEasyPdfDocument addPage(XEasyPdfPage ... pages) {
        this.param.setIsReset(Boolean.TRUE);
        Collections.addAll(this.param.getPageList(), pages);
        return this;
    }

    public XEasyPdfDocument addPage(List<XEasyPdfPage> pages) {
        if (pages != null) {
            return this.addPage(pages.toArray(new XEasyPdfPage[0]));
        }
        return this;
    }

    public XEasyPdfDocument insertPage(int pageIndex, XEasyPdfPage ... pages) {
        this.param.setIsReset(Boolean.TRUE);
        List<XEasyPdfPage> pageList = this.param.getPageList();
        if (pageList.size() >= pageIndex) {
            for (XEasyPdfPage page : pages) {
                pageList.add(Math.max(pageIndex, 0), page);
            }
        } else {
            this.addPage(pages);
        }
        return this;
    }

    public XEasyPdfDocument insertPage(int pageIndex, List<XEasyPdfPage> pages) {
        if (pages != null) {
            return this.insertPage(pageIndex, pages.toArray(new XEasyPdfPage[0]));
        }
        return this;
    }

    public XEasyPdfDocument modifyPageSize(XEasyPdfPageRectangle pageSize, int ... pageIndex) {
        this.param.setIsReset(Boolean.TRUE);
        List<XEasyPdfPage> pageList = this.param.getPageList();
        if (pageIndex != null && pageIndex.length > 0) {
            for (int index : pageIndex) {
                pageList.get(index).modifyPageSize(pageSize);
            }
        } else {
            for (XEasyPdfPage xEasyPdfPage : pageList) {
                xEasyPdfPage.modifyPageSize(pageSize);
            }
        }
        return this;
    }

    public XEasyPdfDocument removePage(int ... pageIndex) {
        this.param.setIsReset(Boolean.TRUE);
        List<XEasyPdfPage> pageList = this.param.getPageList();
        for (int index : pageIndex) {
            XEasyPdfPage page = pageList.get(index);
            this.param.initTotalPage(-(page.getPageList().size() + page.getNewPageList().size()));
            pageList.remove(index);
        }
        return this;
    }

    public XEasyPdfDocument merge(XEasyPdfDocument ... documents) {
        this.param.setIsReset(Boolean.TRUE);
        for (XEasyPdfDocument document : documents) {
            this.param.getMergeSourceList().add(document);
            this.param.getPageList().addAll(document.getPageList());
        }
        return this;
    }

    public XEasyPdfDocumentInfo information() {
        return this.param.getDocumentInfo() != null ? this.param.getDocumentInfo() : new XEasyPdfDocumentInfo(this);
    }

    public XEasyPdfDocumentPermission permission() {
        return this.param.getPermission() != null ? this.param.getPermission() : new XEasyPdfDocumentPermission(this);
    }

    public XEasyPdfDocumentBookmark bookmark() {
        return this.param.getBookmark() != null ? this.param.getBookmark() : new XEasyPdfDocumentBookmark(this);
    }

    public XEasyPdfDocumentReplacer replacer() {
        return new XEasyPdfDocumentReplacer(this);
    }

    public XEasyPdfDocumentFormFiller formFiller() {
        return new XEasyPdfDocumentFormFiller(this);
    }

    public XEasyPdfDocumentImager imager() {
        return new XEasyPdfDocumentImager(this);
    }

    public XEasyPdfDocumentSplitter splitter() {
        return new XEasyPdfDocumentSplitter(this);
    }

    public XEasyPdfDocumentExtractor extractor() {
        return new XEasyPdfDocumentExtractor(this);
    }

    public XEasyPdfDocumentSigner signer() {
        return new XEasyPdfDocumentSigner(this);
    }

    public XEasyPdfDocumentAnalyzer analyzer() {
        return new XEasyPdfDocumentAnalyzer(this);
    }

    public XEasyPdfDocument flush() {
        PDDocument target = this.build();
        String tempPath = this.param.getTempUrl();
        target.save(new File(tempPath));
        this.param.getTempTargetList().add(tempPath);
        this.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("current count of flush\uff1a" + this.param.getTempTargetList().size()));
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XEasyPdfDocument save(String outputPath) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(XEasyPdfFileUtil.createDirectories(Paths.get(outputPath, new String[0])), new OpenOption[0]));){
            XEasyPdfDocument xEasyPdfDocument = this.save(outputStream);
            return xEasyPdfDocument;
        }
    }

    public XEasyPdfDocument save(OutputStream outputStream) {
        if (this.param.getTempTargetList().isEmpty()) {
            PDDocument target = this.build();
            this.replaceTotalPagePlaceholder(target, false);
            this.setBasicInfo(target);
            target.save(outputStream);
            return this;
        }
        this.saveTemp(outputStream);
        return this;
    }

    public XEasyPdfDocument print(int count) {
        return this.print(count, XEasyPdfPrintStyle.PORTRAIT, Scaling.ACTUAL_SIZE);
    }

    public XEasyPdfDocument print(int count, XEasyPdfPrintStyle style, Scaling scaling) {
        PDDocument document = this.build(true);
        PDFPrintable printable = new PDFPrintable(document, scaling);
        PDFPageable target = new PDFPageable(document);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(style.getOrientation());
        target.append((Printable)printable, pageFormat);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
        job.setPageable((Pageable)target);
        job.setCopies(count);
        job.print();
        this.getParam().setIsReset(Boolean.TRUE);
        return this;
    }

    @Override
    public void close() {
        if (!this.param.getMergeSourceList().isEmpty()) {
            List<XEasyPdfDocument> mergeSourceList = this.param.getMergeSourceList();
            for (XEasyPdfDocument mergeSource : mergeSourceList) {
                mergeSource.close();
            }
            mergeSourceList.clear();
        }
        if (this.param.getSource() != null) {
            this.param.getSource().close();
        }
        if (this.param.getTarget() != null) {
            this.param.getTarget().close();
            this.param.getFontCache().clear();
            this.param.getOtfFontCache().clear();
        }
        this.param.setFont(null);
        this.param.setTarget(null);
        this.param.getPageList().clear();
    }

    XEasyPdfDocument reset() {
        this.param.setIsReset(Boolean.TRUE);
        return this;
    }

    PDDocument build() {
        return this.build(false);
    }

    PDDocument build(boolean isReplaceTotalPagePlaceholder) {
        PDDocument target = this.getTarget();
        this.param.initPage(this);
        if (isReplaceTotalPagePlaceholder) {
            this.replaceTotalPagePlaceholder(target, false);
        }
        return target;
    }

    void setInfo(XEasyPdfDocumentInfo info) {
        this.param.setDocumentInfo(info);
    }

    void setPermission(XEasyPdfDocumentPermission permission) {
        this.param.setPermission(permission);
    }

    void setBookmark(XEasyPdfDocumentBookmark bookmark) {
        this.param.setBookmark(bookmark);
    }

    void setBasicInfo(PDDocument target) {
        if (this.param.getDocumentInfo() != null) {
            target.setDocumentInformation(this.param.getDocumentInfo().getInfo());
        }
        if (this.param.getPermission() != null) {
            target.protect(this.param.getPermission().getPolicy());
        }
        target.setVersion(this.param.getVersion().floatValue());
        this.initXMPMetadata(target);
        this.initBookmark(target);
    }

    void replaceTotalPagePlaceholder(PDDocument target, boolean isMultiDocument) {
        int totalPage;
        if (this.param.getIsReplaceTotalPagePlaceholder().booleanValue() && (totalPage = target.getNumberOfPages()) > 0) {
            XEasyPdfDocumentReplacer replacer = new XEasyPdfDocumentReplacer(this, target);
            HashMap<String, String> replaceMap = new HashMap<String, String>(1);
            replaceMap.put(XEasyPdfHandler.Page.getTotalPagePlaceholder(), String.valueOf(totalPage));
            if (isMultiDocument) {
                this.replaceTotalPagePlaceholder(target, replacer, replaceMap);
            } else {
                this.replaceTotalPagePlaceholder(replacer, replaceMap, this.getPageList());
            }
            replacer.finish();
        }
    }

    XEasyPdfDocumentParam getParam() {
        return this.param;
    }

    private void saveTemp(OutputStream outputStream) {
        this.flush();
        PDDocument target = new PDDocument();
        List<String> tempTargetList = this.param.getTempTargetList();
        ArrayList<PDDocument> tempList = new ArrayList<PDDocument>(tempTargetList.size());
        for (String tempPath : tempTargetList) {
            InputStream inputStream = Files.newInputStream(Paths.get(tempPath, new String[0]), StandardOpenOption.DELETE_ON_CLOSE);
            Throwable throwable = null;
            try {
                PDDocument temp = PDDocument.load((InputStream)inputStream);
                PDPageTree tempPageTree = temp.getPages();
                for (PDPage page : tempPageTree) {
                    PDPage importPage = target.importPage(page);
                    importPage.setResources(page.getResources());
                }
                tempList.add(temp);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        this.replaceTotalPagePlaceholder(target, true);
        this.setBasicInfo(target);
        target.save(outputStream);
        this.param.setTarget(target);
        for (PDDocument temp : tempList) {
            temp.close();
        }
    }

    private void initXMPMetadata(PDDocument target) {
        PDMetadata pdMetadata = new PDMetadata(target);
        XMPMetadata xmpMetadata = XMPMetadata.createXMPMetadata();
        AdobePDFSchema adobePdfSchema = xmpMetadata.createAndAddAdobePDFSchema();
        adobePdfSchema.setPDFVersion(this.param.getVersion().toString());
        adobePdfSchema.setProducer(this.param.getProducer());
        xmpMetadata.addSchema((XMPSchema)adobePdfSchema);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            new XmpSerializer().serialize(xmpMetadata, (OutputStream)outputStream, true);
            pdMetadata.importXMPMetadata(outputStream.toByteArray());
        }
        target.getDocumentCatalog().setMetadata(pdMetadata);
    }

    private void initBookmark(PDDocument target) {
        PDDocumentOutline outline = target.getDocumentCatalog().getDocumentOutline();
        if (this.param.getBookmark() != null) {
            if (outline == null) {
                outline = new PDDocumentOutline();
            }
            List<PDOutlineItem> items = this.param.getBookmark().getBookMark();
            for (PDOutlineItem item : items) {
                outline.addLast(item);
            }
        }
        target.getDocumentCatalog().setDocumentOutline(outline);
    }

    private void replaceTotalPagePlaceholder(PDDocument target, XEasyPdfDocumentReplacer replacer, Map<String, String> replaceMap) {
        PDPageTree pages = target.getPages();
        replacer.setFontPath(this.param.getFontPath());
        for (PDPage pdfboxPage : pages) {
            replacer.replaceText(pdfboxPage, replaceMap);
        }
    }

    private void replaceTotalPagePlaceholder(XEasyPdfDocumentReplacer replacer, Map<String, String> replaceMap, List<XEasyPdfPage> pageList) {
        for (XEasyPdfPage page : pageList) {
            XEasyPdfFooter footer;
            XEasyPdfHeader header = page.getHeader();
            if (header != null) {
                this.replaceTotalPagePlaceholder(header.getTextFontPath(), replacer, replaceMap, page);
            }
            if ((footer = page.getFooter()) == null) continue;
            this.replaceTotalPagePlaceholder(footer.getTextFontPath(), replacer, replaceMap, page);
        }
    }

    private void replaceTotalPagePlaceholder(String fontPath, XEasyPdfDocumentReplacer replacer, Map<String, String> replaceMap, XEasyPdfPage page) {
        if (fontPath != null) {
            replacer.setFontPath(fontPath);
            List<PDPage> pdfboxPageList = page.getPageList();
            for (PDPage pdfboxPage : pdfboxPageList) {
                replacer.replaceText(pdfboxPage, replaceMap);
            }
            pdfboxPageList = page.getNewPageList();
            for (PDPage pdfboxPage : pdfboxPageList) {
                replacer.replaceText(pdfboxPage, replaceMap);
            }
        }
    }
}

