/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.doc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentSigner;

public class XEasyPdfDocumentSignDefaultProcessor
implements SignatureInterface {
    private final XEasyPdfDocumentSigner signer;
    private static final String PROVIDER = "BC";

    XEasyPdfDocumentSignDefaultProcessor(XEasyPdfDocumentSigner signer) {
        this.signer = signer;
    }

    public byte[] sign(InputStream content) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        char[] passwordCharArray = this.signer.getParam().getCertificatePassword().toCharArray();
        KeyStore keyStore = KeyStore.getInstance(this.signer.getParam().getKeyStoreType().name());
        try (FileInputStream inputStream = new FileInputStream(this.signer.getParam().getCertificate());){
            keyStore.load(inputStream, passwordCharArray);
        }
        String alias = keyStore.aliases().nextElement();
        Certificate[] certificateChain = keyStore.getCertificateChain(alias);
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder(this.signer.getParam().getSignAlgorithm().name()).setProvider(PROVIDER).build((PrivateKey)keyStore.getKey(alias, passwordCharArray));
        generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(PROVIDER).build()).build(sha1Signer, (X509Certificate)certificateChain[0]));
        generator.addCertificates((Store)new JcaCertStore(Arrays.asList(certificateChain)));
        return generator.generate((CMSTypedData)new CmsProcessableInputStream(content), true).getEncoded();
    }

    public static class CmsProcessableInputStream
    implements CMSTypedData {
        private final InputStream in;
        private final ASN1ObjectIdentifier contentType;

        CmsProcessableInputStream(InputStream is) {
            this(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), is);
        }

        CmsProcessableInputStream(ASN1ObjectIdentifier type, InputStream is) {
            this.contentType = type;
            this.in = is;
        }

        public Object getContent() {
            return this.in;
        }

        public void write(OutputStream out) throws IOException {
            IOUtils.copy((InputStream)this.in, (OutputStream)out);
            this.in.close();
        }

        public ASN1ObjectIdentifier getContentType() {
            return this.contentType;
        }
    }
}

