/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.footer;

import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImage;
import org.dromara.pdf.pdfbox.component.text.XEasyPdfText;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPositionStyle;
import org.dromara.pdf.pdfbox.footer.XEasyPdfFooter;
import org.dromara.pdf.pdfbox.footer.XEasyPdfFooterParam;
import org.dromara.pdf.pdfbox.handler.XEasyPdfHandler;

public class XEasyPdfDefaultFooter
implements XEasyPdfFooter {
    private static final long serialVersionUID = 6124740112893964108L;
    private final XEasyPdfFooterParam param = new XEasyPdfFooterParam();

    public XEasyPdfDefaultFooter(XEasyPdfComponent component) {
        this.param.setComponent(component);
    }

    public XEasyPdfDefaultFooter(XEasyPdfImage image) {
        this(image, null);
    }

    public XEasyPdfDefaultFooter(XEasyPdfText text) {
        this(null, text);
    }

    public XEasyPdfDefaultFooter(XEasyPdfImage image, XEasyPdfText text) {
        this.param.setImage(image).setText(text);
    }

    @Override
    public XEasyPdfDefaultFooter enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfDefaultFooter setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultFooter setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultFooter setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultFooter setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfFooter setHeight(float height) {
        this.param.setHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    @Override
    public XEasyPdfDefaultFooter addComponent(XEasyPdfComponent component) {
        this.param.setComponent(component);
        return this;
    }

    @Override
    public float getHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.init(document, page);
        return this.param.getHeight().floatValue();
    }

    @Override
    public String getTotalPagePlaceholder() {
        return XEasyPdfHandler.Page.getTotalPagePlaceholder();
    }

    @Override
    public String getCurrentPagePlaceholder() {
        return XEasyPdfHandler.Page.getCurrentPagePlaceholder();
    }

    @Override
    public String getTextFontPath() {
        if (this.param.getText() != null) {
            return this.param.getText().getFontPath();
        }
        return null;
    }

    @Override
    public boolean check(XEasyPdfComponent component) {
        if (component != null) {
            if (component instanceof XEasyPdfImage) {
                return this.param.getImage() != null && this.param.getImage().equals(component);
            }
            if (component instanceof XEasyPdfText) {
                return this.param.getText() != null && this.param.getText().equals(component);
            }
        }
        return false;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.init(document, page);
        page.disablePosition();
        if (this.param.getImage() != null) {
            XEasyPdfImage image = this.param.getImage();
            if (this.param.getIsResetContext().booleanValue()) {
                image.enableResetContext();
            }
            image.setContentMode(XEasyPdfComponent.ContentMode.PREPEND).setPosition(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue() + this.param.getMarginBottom().floatValue()).draw(document, page);
        }
        if (this.param.getText() != null) {
            XEasyPdfText text = this.param.getText();
            if (this.param.getIsResetContext().booleanValue()) {
                text.enableResetContext();
            }
            text.replaceAllPlaceholder(XEasyPdfHandler.Page.getCurrentPagePlaceholder(), page.getCurrentIndex(document) + "").setCheckPage(false);
            text.setPosition(this.param.getBeginX().floatValue(), this.initYForText(document, page, text)).enableChildComponent().draw(document, page);
            page.disablePosition();
        }
        if (this.param.getComponent() != null) {
            this.param.getComponent().draw(document, page);
        }
        page.enablePosition();
    }

    private float initYForText(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfText text) {
        float height = this.param.getHeight().floatValue();
        float textHeight = text.getHeight(document, page);
        float y = this.param.getBeginY().floatValue() + height + text.getLeading() / 2.0f;
        if (text.getVerticalStyle() == XEasyPdfPositionStyle.TOP) {
            return y -= text.getFontSize();
        }
        if (text.getVerticalStyle() == XEasyPdfPositionStyle.CENTER) {
            y = y - text.getFontSize() - (height - textHeight) / 2.0f;
            return y;
        }
        if (text.getVerticalStyle() == XEasyPdfPositionStyle.BOTTOM) {
            y = y - text.getFontSize() - height + textHeight;
        }
        return y;
    }
}

