/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.mark;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.blend.BlendMode;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDefaultFontStyle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.mark.XEasyPdfWatermark;
import org.dromara.pdf.pdfbox.mark.XEasyPdfWatermarkParam;
import org.dromara.pdf.pdfbox.util.XEasyPdfFontUtil;

public class XEasyPdfDefaultWatermark
implements XEasyPdfWatermark {
    private static final long serialVersionUID = 9095729509463996323L;
    private final XEasyPdfWatermarkParam param = new XEasyPdfWatermarkParam();

    public XEasyPdfDefaultWatermark(String ... text) {
        this.param.setTexts(Arrays.asList(text));
    }

    public XEasyPdfDefaultWatermark(float fontSize, String ... text) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize))).setTexts(Arrays.asList(text));
    }

    public XEasyPdfDefaultWatermark setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfDefaultWatermark setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfDefaultWatermark setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize)));
        return this;
    }

    public XEasyPdfDefaultWatermark setFontColor(Color fontColor) {
        if (fontColor != null) {
            this.param.setFontColor(fontColor);
        }
        return this;
    }

    public XEasyPdfDefaultWatermark setAlpha(float alpha) {
        if (0.0f <= alpha && alpha <= 1.0f) {
            this.param.setAlpha(Float.valueOf(alpha));
        }
        return this;
    }

    public XEasyPdfDefaultWatermark setRadians(double radians) {
        this.param.setRadians(radians);
        return this;
    }

    public XEasyPdfDefaultWatermark setText(String ... text) {
        this.param.setTexts(Arrays.asList(text));
        return this;
    }

    public XEasyPdfDefaultWatermark setWordSpace(float wordSpace) {
        this.param.setWordSpace(Float.valueOf(Math.abs(wordSpace)));
        return this;
    }

    public XEasyPdfDefaultWatermark setWordCount(int wordCount) {
        this.param.setWordCount(Math.abs(wordCount));
        return this;
    }

    public XEasyPdfDefaultWatermark setWordLine(int wordLine) {
        this.param.setWordLine(Math.abs(wordLine));
        return this;
    }

    public XEasyPdfDefaultWatermark setCharacterSpacing(float characterSpacing) {
        this.param.setCharacterSpacing(Float.valueOf(Math.abs(characterSpacing)));
        return this;
    }

    public XEasyPdfDefaultWatermark setLeading(float leading) {
        this.param.setLeading(Float.valueOf(Math.abs(leading)));
        return this;
    }

    public XEasyPdfDefaultWatermark setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    public XEasyPdfDefaultWatermark enableOuterMode() {
        this.param.setContentMode(XEasyPdfComponent.ContentMode.APPEND);
        return this;
    }

    public XEasyPdfDefaultWatermark enableInnerMode() {
        this.param.setContentMode(XEasyPdfComponent.ContentMode.PREPEND);
        return this;
    }

    @Override
    public XEasyPdfDefaultWatermark enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.param.getIsNeedInit().booleanValue()) {
            this.param.init(document, page);
        }
        PDFont font = XEasyPdfFontUtil.loadFont(document, page, this.param.getFontPath(), true);
        Float beginX = this.param.getBeginX();
        Float beginY = this.param.getBeginY();
        PDDocument target = document.getTarget();
        List<PDPage> pageList = page.getPageList();
        for (PDPage pdPage : pageList) {
            this.doDraw(target, pdPage, font);
            this.param.setBeginX(beginX);
            this.param.setBeginY(beginY);
        }
        pageList = page.getNewPageList();
        for (PDPage pdPage : pageList) {
            this.doDraw(target, pdPage, font);
            this.param.setBeginX(beginX);
            this.param.setBeginY(beginY);
        }
    }

    private void doDraw(PDDocument document, PDPage page, PDFont font) {
        float height = page.getMediaBox().getHeight();
        float width = page.getMediaBox().getWidth();
        if (this.param.getBeginX() == null) {
            this.param.setBeginX(Float.valueOf(0.0f));
        }
        if (this.param.getBeginY() == null) {
            this.param.setBeginY(Float.valueOf(height - this.param.getFontSize().floatValue()));
        }
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        state.setNonStrokingAlphaConstant(this.param.getAlpha());
        state.setAlphaSourceFlag(true);
        state.setBlendMode((BlendMode)BlendMode.MULTIPLY);
        PDPageContentStream cs = new PDPageContentStream(document, page, this.param.getContentMode().getMode(), true, this.param.getIsResetContext().booleanValue());
        cs.setGraphicsStateParameters(state);
        cs.setNonStrokingColor(this.param.getFontColor());
        cs.setFont(font, this.param.getFontSize().floatValue());
        cs.setCharacterSpacing(this.param.getCharacterSpacing().floatValue());
        this.writeText(cs, width * 2.0f);
        cs.close();
    }

    private void writeText(PDPageContentStream cs, float mixWidth) {
        if (this.param.getWordCount() != null) {
            this.writeTextWithCount(cs);
        } else {
            this.writeTextWithWidth(cs, Float.valueOf(mixWidth));
        }
    }

    private void writeTextWithCount(PDPageContentStream cs) {
        for (int i = 0; i < this.param.getWordLine(); ++i) {
            int index = 0;
            do {
                this.writeText(cs);
                this.param.setBeginX(Float.valueOf(this.param.getBeginX().floatValue() + this.param.getWordSpace().floatValue()));
            } while (++index < this.param.getWordCount());
            this.param.setBeginX(Float.valueOf(0.0f));
            this.param.setBeginY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getFontSize().floatValue() * (float)this.param.getTexts().size() - this.param.getLeading().floatValue()));
        }
    }

    private void writeTextWithWidth(PDPageContentStream cs, Float mixWidth) {
        for (int i = 0; i < this.param.getWordLine(); ++i) {
            do {
                this.writeText(cs);
                this.param.setBeginX(Float.valueOf(this.param.getBeginX().floatValue() + this.param.getWordSpace().floatValue()));
            } while (this.param.getBeginX().floatValue() < mixWidth.floatValue());
            this.param.setBeginX(Float.valueOf(0.0f));
            this.param.setBeginY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getFontSize().floatValue() * (float)this.param.getTexts().size() - this.param.getLeading().floatValue()));
        }
    }

    private void writeText(PDPageContentStream cs) {
        float beginY = this.param.getBeginY().floatValue();
        for (String text : this.param.getTexts()) {
            beginY = this.writeText(cs, text, beginY);
        }
    }

    private float writeText(PDPageContentStream cs, String text, float beginY) {
        cs.beginText();
        cs.setTextMatrix(Matrix.getRotateInstance((double)Math.toRadians(this.param.getRadians()), (float)0.0f, (float)0.0f));
        cs.newLineAtOffset(this.param.getBeginX().floatValue(), beginY);
        cs.showText(text);
        cs.endText();
        return beginY - this.param.getFontSize().floatValue();
    }
}

