/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.awt.Color;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseMargin;
import org.dromara.pdf.pdfbox.core.enums.BorderStyle;

public abstract class AbstractBaseBorder
extends AbstractBaseMargin {
    private BorderStyle borderStyle;
    private Float borderWidth;
    private Float borderLineLength;
    private Float borderLineSpacing;
    private Color borderTopColor;
    private Color borderBottomColor;
    private Color borderLeftColor;
    private Color borderRightColor;
    private Boolean isBorderTop;
    private Boolean isBorderBottom;
    private Boolean isBorderLeft;
    private Boolean isBorderRight;

    public void setIsBorder(boolean flag) {
        this.isBorderTop = flag;
        this.isBorderBottom = flag;
        this.isBorderLeft = flag;
        this.isBorderRight = flag;
    }

    public void setBorderColor(Color color) {
        this.borderTopColor = color;
        this.borderBottomColor = color;
        this.borderLeftColor = color;
        this.borderRightColor = color;
    }

    public void setBorderWidth(float width) {
        if (width <= 0.0f) {
            throw new IllegalArgumentException("the border width must be greater than 0");
        }
        this.borderWidth = Float.valueOf(width);
    }

    public void setBorderLineLength(float length) {
        if (length <= 0.0f) {
            throw new IllegalArgumentException("the border line length must be greater than 0");
        }
        this.borderLineLength = Float.valueOf(length);
    }

    public void setBorderLineSpacing(float spacing) {
        if (spacing < 0.0f) {
            throw new IllegalArgumentException("the border line spacing must be greater than 0");
        }
        this.borderLineSpacing = Float.valueOf(spacing);
    }

    protected void init(AbstractBaseBorder base, boolean isInitMarginByParam) {
        super.init(base, isInitMarginByParam);
        this.initBorder(base);
    }

    protected void initBorder(AbstractBaseBorder base) {
        if (Objects.isNull((Object)this.borderStyle)) {
            this.borderStyle = base.borderStyle;
        }
        if (Objects.isNull(this.borderWidth)) {
            this.borderWidth = base.borderWidth;
        }
        if (Objects.isNull(this.borderLineLength)) {
            this.borderLineLength = base.borderLineLength;
        }
        if (Objects.isNull(this.borderLineSpacing)) {
            this.borderLineSpacing = base.borderLineSpacing;
        }
        if (Objects.isNull(this.borderTopColor)) {
            this.borderTopColor = base.borderTopColor;
        }
        if (Objects.isNull(this.borderBottomColor)) {
            this.borderBottomColor = base.borderBottomColor;
        }
        if (Objects.isNull(this.borderLeftColor)) {
            this.borderLeftColor = base.borderLeftColor;
        }
        if (Objects.isNull(this.borderRightColor)) {
            this.borderRightColor = base.borderRightColor;
        }
        if (Objects.isNull(this.isBorderTop)) {
            this.isBorderTop = base.isBorderTop;
        }
        if (Objects.isNull(this.isBorderBottom)) {
            this.isBorderBottom = base.isBorderBottom;
        }
        if (Objects.isNull(this.isBorderLeft)) {
            this.isBorderLeft = base.isBorderLeft;
        }
        if (Objects.isNull(this.isBorderRight)) {
            this.isBorderRight = base.isBorderRight;
        }
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public Float getBorderWidth() {
        return this.borderWidth;
    }

    public Float getBorderLineLength() {
        return this.borderLineLength;
    }

    public Float getBorderLineSpacing() {
        return this.borderLineSpacing;
    }

    public Color getBorderTopColor() {
        return this.borderTopColor;
    }

    public Color getBorderBottomColor() {
        return this.borderBottomColor;
    }

    public Color getBorderLeftColor() {
        return this.borderLeftColor;
    }

    public Color getBorderRightColor() {
        return this.borderRightColor;
    }

    public Boolean getIsBorderTop() {
        return this.isBorderTop;
    }

    public Boolean getIsBorderBottom() {
        return this.isBorderBottom;
    }

    public Boolean getIsBorderLeft() {
        return this.isBorderLeft;
    }

    public Boolean getIsBorderRight() {
        return this.isBorderRight;
    }

    public void setBorderStyle(BorderStyle borderStyle) {
        this.borderStyle = borderStyle;
    }

    public void setBorderTopColor(Color borderTopColor) {
        this.borderTopColor = borderTopColor;
    }

    public void setBorderBottomColor(Color borderBottomColor) {
        this.borderBottomColor = borderBottomColor;
    }

    public void setBorderLeftColor(Color borderLeftColor) {
        this.borderLeftColor = borderLeftColor;
    }

    public void setBorderRightColor(Color borderRightColor) {
        this.borderRightColor = borderRightColor;
    }

    public void setIsBorderTop(Boolean isBorderTop) {
        this.isBorderTop = isBorderTop;
    }

    public void setIsBorderBottom(Boolean isBorderBottom) {
        this.isBorderBottom = isBorderBottom;
    }

    public void setIsBorderLeft(Boolean isBorderLeft) {
        this.isBorderLeft = isBorderLeft;
    }

    public void setIsBorderRight(Boolean isBorderRight) {
        this.isBorderRight = isBorderRight;
    }

    @Override
    public String toString() {
        return "AbstractBaseBorder(borderStyle=" + (Object)((Object)this.getBorderStyle()) + ", borderWidth=" + this.getBorderWidth() + ", borderLineLength=" + this.getBorderLineLength() + ", borderLineSpacing=" + this.getBorderLineSpacing() + ", borderTopColor=" + this.getBorderTopColor() + ", borderBottomColor=" + this.getBorderBottomColor() + ", borderLeftColor=" + this.getBorderLeftColor() + ", borderRightColor=" + this.getBorderRightColor() + ", isBorderTop=" + this.getIsBorderTop() + ", isBorderBottom=" + this.getIsBorderBottom() + ", isBorderLeft=" + this.getIsBorderLeft() + ", isBorderRight=" + this.getIsBorderRight() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBaseBorder)) {
            return false;
        }
        AbstractBaseBorder other = (AbstractBaseBorder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$borderWidth = this.getBorderWidth();
        Float other$borderWidth = other.getBorderWidth();
        if (this$borderWidth == null ? other$borderWidth != null : !((Object)this$borderWidth).equals(other$borderWidth)) {
            return false;
        }
        Float this$borderLineLength = this.getBorderLineLength();
        Float other$borderLineLength = other.getBorderLineLength();
        if (this$borderLineLength == null ? other$borderLineLength != null : !((Object)this$borderLineLength).equals(other$borderLineLength)) {
            return false;
        }
        Float this$borderLineSpacing = this.getBorderLineSpacing();
        Float other$borderLineSpacing = other.getBorderLineSpacing();
        if (this$borderLineSpacing == null ? other$borderLineSpacing != null : !((Object)this$borderLineSpacing).equals(other$borderLineSpacing)) {
            return false;
        }
        Boolean this$isBorderTop = this.getIsBorderTop();
        Boolean other$isBorderTop = other.getIsBorderTop();
        if (this$isBorderTop == null ? other$isBorderTop != null : !((Object)this$isBorderTop).equals(other$isBorderTop)) {
            return false;
        }
        Boolean this$isBorderBottom = this.getIsBorderBottom();
        Boolean other$isBorderBottom = other.getIsBorderBottom();
        if (this$isBorderBottom == null ? other$isBorderBottom != null : !((Object)this$isBorderBottom).equals(other$isBorderBottom)) {
            return false;
        }
        Boolean this$isBorderLeft = this.getIsBorderLeft();
        Boolean other$isBorderLeft = other.getIsBorderLeft();
        if (this$isBorderLeft == null ? other$isBorderLeft != null : !((Object)this$isBorderLeft).equals(other$isBorderLeft)) {
            return false;
        }
        Boolean this$isBorderRight = this.getIsBorderRight();
        Boolean other$isBorderRight = other.getIsBorderRight();
        if (this$isBorderRight == null ? other$isBorderRight != null : !((Object)this$isBorderRight).equals(other$isBorderRight)) {
            return false;
        }
        BorderStyle this$borderStyle = this.getBorderStyle();
        BorderStyle other$borderStyle = other.getBorderStyle();
        if (this$borderStyle == null ? other$borderStyle != null : !((Object)((Object)this$borderStyle)).equals((Object)other$borderStyle)) {
            return false;
        }
        Color this$borderTopColor = this.getBorderTopColor();
        Color other$borderTopColor = other.getBorderTopColor();
        if (this$borderTopColor == null ? other$borderTopColor != null : !((Object)this$borderTopColor).equals(other$borderTopColor)) {
            return false;
        }
        Color this$borderBottomColor = this.getBorderBottomColor();
        Color other$borderBottomColor = other.getBorderBottomColor();
        if (this$borderBottomColor == null ? other$borderBottomColor != null : !((Object)this$borderBottomColor).equals(other$borderBottomColor)) {
            return false;
        }
        Color this$borderLeftColor = this.getBorderLeftColor();
        Color other$borderLeftColor = other.getBorderLeftColor();
        if (this$borderLeftColor == null ? other$borderLeftColor != null : !((Object)this$borderLeftColor).equals(other$borderLeftColor)) {
            return false;
        }
        Color this$borderRightColor = this.getBorderRightColor();
        Color other$borderRightColor = other.getBorderRightColor();
        return !(this$borderRightColor == null ? other$borderRightColor != null : !((Object)this$borderRightColor).equals(other$borderRightColor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractBaseBorder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $borderWidth = this.getBorderWidth();
        result = result * 59 + ($borderWidth == null ? 43 : ((Object)$borderWidth).hashCode());
        Float $borderLineLength = this.getBorderLineLength();
        result = result * 59 + ($borderLineLength == null ? 43 : ((Object)$borderLineLength).hashCode());
        Float $borderLineSpacing = this.getBorderLineSpacing();
        result = result * 59 + ($borderLineSpacing == null ? 43 : ((Object)$borderLineSpacing).hashCode());
        Boolean $isBorderTop = this.getIsBorderTop();
        result = result * 59 + ($isBorderTop == null ? 43 : ((Object)$isBorderTop).hashCode());
        Boolean $isBorderBottom = this.getIsBorderBottom();
        result = result * 59 + ($isBorderBottom == null ? 43 : ((Object)$isBorderBottom).hashCode());
        Boolean $isBorderLeft = this.getIsBorderLeft();
        result = result * 59 + ($isBorderLeft == null ? 43 : ((Object)$isBorderLeft).hashCode());
        Boolean $isBorderRight = this.getIsBorderRight();
        result = result * 59 + ($isBorderRight == null ? 43 : ((Object)$isBorderRight).hashCode());
        BorderStyle $borderStyle = this.getBorderStyle();
        result = result * 59 + ($borderStyle == null ? 43 : ((Object)((Object)$borderStyle)).hashCode());
        Color $borderTopColor = this.getBorderTopColor();
        result = result * 59 + ($borderTopColor == null ? 43 : ((Object)$borderTopColor).hashCode());
        Color $borderBottomColor = this.getBorderBottomColor();
        result = result * 59 + ($borderBottomColor == null ? 43 : ((Object)$borderBottomColor).hashCode());
        Color $borderLeftColor = this.getBorderLeftColor();
        result = result * 59 + ($borderLeftColor == null ? 43 : ((Object)$borderLeftColor).hashCode());
        Color $borderRightColor = this.getBorderRightColor();
        result = result * 59 + ($borderRightColor == null ? 43 : ((Object)$borderRightColor).hashCode());
        return result;
    }
}

