/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.awt.Color;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseBorder;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;

public abstract class AbstractBaseFont
extends AbstractBaseBorder {
    private String fontName;
    private PDFont font;
    private Float fontSize;
    private Color fontColor;
    private Float fontAlpha;
    private FontStyle fontStyle;
    private Float fontSlope;
    private Float characterSpacing;
    private Float leading;

    public void setFontSize(float fontSize) {
        if (fontSize < 1.0f) {
            throw new IllegalArgumentException("the font size must be greater than 1");
        }
        this.fontSize = Float.valueOf(fontSize);
    }

    public void setCharacterSpacing(float spacing) {
        if (spacing < 0.0f) {
            throw new IllegalArgumentException("the character spacing must be greater than 0");
        }
        this.characterSpacing = Float.valueOf(spacing);
    }

    public void setLeading(float leading) {
        if (leading < 0.0f) {
            throw new IllegalArgumentException("the leading must be greater than 0");
        }
        this.leading = Float.valueOf(leading);
    }

    public void init(AbstractBaseFont base, boolean isInitMarginByParam) {
        super.init(base, isInitMarginByParam);
        this.initFont(base);
    }

    protected void initFont(AbstractBaseFont base) {
        if (Objects.isNull(this.font)) {
            this.font = base.font;
        }
        if (Objects.isNull(this.fontName)) {
            this.fontName = base.fontName;
        }
        if (Objects.isNull(this.fontSize)) {
            this.fontSize = base.fontSize;
        }
        if (Objects.isNull(this.fontColor)) {
            this.fontColor = base.fontColor;
        }
        if (Objects.isNull(this.fontAlpha)) {
            this.fontAlpha = base.fontAlpha;
        }
        if (Objects.isNull((Object)this.fontStyle)) {
            this.fontStyle = base.fontStyle;
        }
        if (Objects.isNull(this.fontSlope)) {
            this.fontSlope = this.fontStyle.isItalic() ? Float.valueOf(0.3f) : base.fontSlope;
        }
        if (Objects.isNull(this.characterSpacing)) {
            this.characterSpacing = base.characterSpacing;
        }
        if (Objects.isNull(this.leading)) {
            this.leading = base.leading;
        }
    }

    public String getFontName() {
        return this.fontName;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Float getFontAlpha() {
        return this.fontAlpha;
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public Float getFontSlope() {
        return this.fontSlope;
    }

    public Float getCharacterSpacing() {
        return this.characterSpacing;
    }

    public Float getLeading() {
        return this.leading;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void setFontAlpha(Float fontAlpha) {
        this.fontAlpha = fontAlpha;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontSlope(Float fontSlope) {
        this.fontSlope = fontSlope;
    }

    @Override
    public String toString() {
        return "AbstractBaseFont(fontName=" + this.getFontName() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", fontColor=" + this.getFontColor() + ", fontAlpha=" + this.getFontAlpha() + ", fontStyle=" + (Object)((Object)this.getFontStyle()) + ", fontSlope=" + this.getFontSlope() + ", characterSpacing=" + this.getCharacterSpacing() + ", leading=" + this.getLeading() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBaseFont)) {
            return false;
        }
        AbstractBaseFont other = (AbstractBaseFont)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Float this$fontAlpha = this.getFontAlpha();
        Float other$fontAlpha = other.getFontAlpha();
        if (this$fontAlpha == null ? other$fontAlpha != null : !((Object)this$fontAlpha).equals(other$fontAlpha)) {
            return false;
        }
        Float this$fontSlope = this.getFontSlope();
        Float other$fontSlope = other.getFontSlope();
        if (this$fontSlope == null ? other$fontSlope != null : !((Object)this$fontSlope).equals(other$fontSlope)) {
            return false;
        }
        Float this$characterSpacing = this.getCharacterSpacing();
        Float other$characterSpacing = other.getCharacterSpacing();
        if (this$characterSpacing == null ? other$characterSpacing != null : !((Object)this$characterSpacing).equals(other$characterSpacing)) {
            return false;
        }
        Float this$leading = this.getLeading();
        Float other$leading = other.getLeading();
        if (this$leading == null ? other$leading != null : !((Object)this$leading).equals(other$leading)) {
            return false;
        }
        String this$fontName = this.getFontName();
        String other$fontName = other.getFontName();
        if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor)) {
            return false;
        }
        FontStyle this$fontStyle = this.getFontStyle();
        FontStyle other$fontStyle = other.getFontStyle();
        return !(this$fontStyle == null ? other$fontStyle != null : !((Object)((Object)this$fontStyle)).equals((Object)other$fontStyle));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractBaseFont;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Float $fontAlpha = this.getFontAlpha();
        result = result * 59 + ($fontAlpha == null ? 43 : ((Object)$fontAlpha).hashCode());
        Float $fontSlope = this.getFontSlope();
        result = result * 59 + ($fontSlope == null ? 43 : ((Object)$fontSlope).hashCode());
        Float $characterSpacing = this.getCharacterSpacing();
        result = result * 59 + ($characterSpacing == null ? 43 : ((Object)$characterSpacing).hashCode());
        Float $leading = this.getLeading();
        result = result * 59 + ($leading == null ? 43 : ((Object)$leading).hashCode());
        String $fontName = this.getFontName();
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        FontStyle $fontStyle = this.getFontStyle();
        result = result * 59 + ($fontStyle == null ? 43 : ((Object)((Object)$fontStyle)).hashCode());
        return result;
    }
}

