/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;

public abstract class AbstractBaseMargin
extends AbstractBase {
    private Float marginTop;
    private Float marginBottom;
    private Float marginLeft;
    private Float marginRight;

    public void setMargin(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.initMargin(margin);
    }

    public void setMarginTop(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginTop = Float.valueOf(margin);
    }

    public void setMarginBottom(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginBottom = Float.valueOf(margin);
    }

    public void setMarginLeft(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginLeft = Float.valueOf(margin);
    }

    public void setMarginRight(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginRight = Float.valueOf(margin);
    }

    protected void init(AbstractBaseMargin base, boolean isInitMarginByParam) {
        if (isInitMarginByParam) {
            this.initMarginWithParam(base);
        } else {
            this.initMargin();
        }
        super.init(base);
    }

    protected void initMargin() {
        if (Objects.isNull(this.marginTop)) {
            this.marginTop = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginBottom)) {
            this.marginBottom = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginLeft)) {
            this.marginLeft = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginRight)) {
            this.marginRight = Float.valueOf(0.0f);
        }
    }

    protected void initMargin(float margin) {
        this.setMarginTop(margin);
        this.setMarginBottom(margin);
        this.setMarginLeft(margin);
        this.setMarginRight(margin);
    }

    protected void initMarginWithParam(AbstractBaseMargin base) {
        if (Objects.isNull(this.marginTop)) {
            this.marginTop = base.marginTop;
        }
        if (Objects.isNull(this.marginBottom)) {
            this.marginBottom = base.marginBottom;
        }
        if (Objects.isNull(this.marginLeft)) {
            this.marginLeft = base.marginLeft;
        }
        if (Objects.isNull(this.marginRight)) {
            this.marginRight = base.marginRight;
        }
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    @Override
    public String toString() {
        return "AbstractBaseMargin(marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBaseMargin)) {
            return false;
        }
        AbstractBaseMargin other = (AbstractBaseMargin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        return !(this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractBaseMargin;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        return result;
    }
}

