/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Cursor;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.ContainerInfo;
import org.dromara.pdf.pdfbox.core.component.PageFooter;
import org.dromara.pdf.pdfbox.core.component.PageHeader;
import org.dromara.pdf.pdfbox.core.enums.ContentMode;
import org.dromara.pdf.pdfbox.core.info.CatalogInfo;

public class Context {
    private ContentMode contentMode;
    private Boolean isResetContentStream;
    private Document document;
    private Page page;
    private Integer pageCount;
    private ComponentType executingComponentType;
    private PageHeader pageHeader;
    private PageFooter pageFooter;
    private Cursor cursor;
    private Boolean isAlreadyPaging;
    private Float wrapBeginX;
    private Float wrapWidth;
    private Float wrapHeight;
    private List<CatalogInfo> catalogs;
    private ContainerInfo containerInfo;
    private Map<String, Object> customInfo;

    public Context(Document document) {
        this.document = document;
        this.cursor = new Cursor();
        this.catalogs = new ArrayList<CatalogInfo>(16);
        this.customInfo = new HashMap<String, Object>();
    }

    public PDDocument getTargetDocument() {
        return this.document.getTarget();
    }

    public PDPage getTargetPage() {
        return this.page.getTarget();
    }

    public boolean isFirstLine() {
        if (this.hasPageHeader()) {
            return this.cursor.getY().floatValue() == this.page.getHeight().floatValue() - this.page.getMarginTop().floatValue() - this.pageHeader.getHeight().floatValue();
        }
        return this.cursor.getY().floatValue() == this.page.getHeight().floatValue() - this.page.getMarginTop().floatValue();
    }

    public boolean isContainerWrap() {
        return this.containerInfo != null && this.containerInfo.getIsFirstComponent() != false;
    }

    public boolean hasPageHeader() {
        return Objects.nonNull(this.pageHeader);
    }

    public boolean hasPageFooter() {
        return Objects.nonNull(this.pageFooter);
    }

    public void reset(Page page) {
        this.isAlreadyPaging = !page.getId().equals(Optional.ofNullable(this.page).map(Page::getId).orElse(null));
        if (this.isAlreadyPaging.booleanValue()) {
            this.page = page;
            this.pageCount = Optional.ofNullable(this.pageCount).orElse(0) + 1;
            this.cursor.reset(this.page.getMarginLeft().floatValue(), this.page.getHeight().floatValue() - this.page.getMarginTop().floatValue());
            this.resetWrapWidth(this.wrapWidth);
        }
    }

    public Float resetWrapWidth(Float wrapWidth) {
        Float old = this.wrapWidth;
        this.wrapWidth = Objects.isNull(wrapWidth) ? this.page.getWithoutMarginWidth() : wrapWidth;
        return old;
    }

    public Float resetWrapHeight(Float wrapHeight) {
        Float old = this.wrapHeight;
        this.wrapHeight = Objects.isNull(wrapHeight) ? Float.valueOf(0.0f) : wrapHeight;
        return old;
    }

    public void resetExecutingComponentType(ComponentType type) {
        if (type == this.executingComponentType) {
            this.executingComponentType = null;
        }
    }

    public void clear() {
        this.document = null;
        this.page = null;
        this.pageHeader = null;
        this.pageFooter = null;
    }

    public ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContentStream() {
        return this.isResetContentStream;
    }

    public Document getDocument() {
        return this.document;
    }

    public Page getPage() {
        return this.page;
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public ComponentType getExecutingComponentType() {
        return this.executingComponentType;
    }

    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    public PageFooter getPageFooter() {
        return this.pageFooter;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public Boolean getIsAlreadyPaging() {
        return this.isAlreadyPaging;
    }

    public Float getWrapBeginX() {
        return this.wrapBeginX;
    }

    public Float getWrapWidth() {
        return this.wrapWidth;
    }

    public Float getWrapHeight() {
        return this.wrapHeight;
    }

    public List<CatalogInfo> getCatalogs() {
        return this.catalogs;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public Map<String, Object> getCustomInfo() {
        return this.customInfo;
    }

    public void setContentMode(ContentMode contentMode) {
        this.contentMode = contentMode;
    }

    public void setIsResetContentStream(Boolean isResetContentStream) {
        this.isResetContentStream = isResetContentStream;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public void setExecutingComponentType(ComponentType executingComponentType) {
        this.executingComponentType = executingComponentType;
    }

    public void setPageHeader(PageHeader pageHeader) {
        this.pageHeader = pageHeader;
    }

    public void setPageFooter(PageFooter pageFooter) {
        this.pageFooter = pageFooter;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public void setIsAlreadyPaging(Boolean isAlreadyPaging) {
        this.isAlreadyPaging = isAlreadyPaging;
    }

    public void setWrapBeginX(Float wrapBeginX) {
        this.wrapBeginX = wrapBeginX;
    }

    public void setWrapWidth(Float wrapWidth) {
        this.wrapWidth = wrapWidth;
    }

    public void setWrapHeight(Float wrapHeight) {
        this.wrapHeight = wrapHeight;
    }

    public void setCatalogs(List<CatalogInfo> catalogs) {
        this.catalogs = catalogs;
    }

    public void setContainerInfo(ContainerInfo containerInfo) {
        this.containerInfo = containerInfo;
    }

    public void setCustomInfo(Map<String, Object> customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContentStream = this.getIsResetContentStream();
        Boolean other$isResetContentStream = other.getIsResetContentStream();
        if (this$isResetContentStream == null ? other$isResetContentStream != null : !((Object)this$isResetContentStream).equals(other$isResetContentStream)) {
            return false;
        }
        Integer this$pageCount = this.getPageCount();
        Integer other$pageCount = other.getPageCount();
        if (this$pageCount == null ? other$pageCount != null : !((Object)this$pageCount).equals(other$pageCount)) {
            return false;
        }
        Boolean this$isAlreadyPaging = this.getIsAlreadyPaging();
        Boolean other$isAlreadyPaging = other.getIsAlreadyPaging();
        if (this$isAlreadyPaging == null ? other$isAlreadyPaging != null : !((Object)this$isAlreadyPaging).equals(other$isAlreadyPaging)) {
            return false;
        }
        Float this$wrapBeginX = this.getWrapBeginX();
        Float other$wrapBeginX = other.getWrapBeginX();
        if (this$wrapBeginX == null ? other$wrapBeginX != null : !((Object)this$wrapBeginX).equals(other$wrapBeginX)) {
            return false;
        }
        Float this$wrapWidth = this.getWrapWidth();
        Float other$wrapWidth = other.getWrapWidth();
        if (this$wrapWidth == null ? other$wrapWidth != null : !((Object)this$wrapWidth).equals(other$wrapWidth)) {
            return false;
        }
        Float this$wrapHeight = this.getWrapHeight();
        Float other$wrapHeight = other.getWrapHeight();
        if (this$wrapHeight == null ? other$wrapHeight != null : !((Object)this$wrapHeight).equals(other$wrapHeight)) {
            return false;
        }
        ContentMode this$contentMode = this.getContentMode();
        ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        Page this$page = this.getPage();
        Page other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        ComponentType this$executingComponentType = this.getExecutingComponentType();
        ComponentType other$executingComponentType = other.getExecutingComponentType();
        if (this$executingComponentType == null ? other$executingComponentType != null : !((Object)((Object)this$executingComponentType)).equals((Object)other$executingComponentType)) {
            return false;
        }
        PageHeader this$pageHeader = this.getPageHeader();
        PageHeader other$pageHeader = other.getPageHeader();
        if (this$pageHeader == null ? other$pageHeader != null : !((Object)this$pageHeader).equals(other$pageHeader)) {
            return false;
        }
        PageFooter this$pageFooter = this.getPageFooter();
        PageFooter other$pageFooter = other.getPageFooter();
        if (this$pageFooter == null ? other$pageFooter != null : !((Object)this$pageFooter).equals(other$pageFooter)) {
            return false;
        }
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !((Object)this$cursor).equals(other$cursor)) {
            return false;
        }
        List<CatalogInfo> this$catalogs = this.getCatalogs();
        List<CatalogInfo> other$catalogs = other.getCatalogs();
        if (this$catalogs == null ? other$catalogs != null : !((Object)this$catalogs).equals(other$catalogs)) {
            return false;
        }
        ContainerInfo this$containerInfo = this.getContainerInfo();
        ContainerInfo other$containerInfo = other.getContainerInfo();
        if (this$containerInfo == null ? other$containerInfo != null : !((Object)this$containerInfo).equals(other$containerInfo)) {
            return false;
        }
        Map<String, Object> this$customInfo = this.getCustomInfo();
        Map<String, Object> other$customInfo = other.getCustomInfo();
        return !(this$customInfo == null ? other$customInfo != null : !((Object)this$customInfo).equals(other$customInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Context;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContentStream = this.getIsResetContentStream();
        result = result * 59 + ($isResetContentStream == null ? 43 : ((Object)$isResetContentStream).hashCode());
        Integer $pageCount = this.getPageCount();
        result = result * 59 + ($pageCount == null ? 43 : ((Object)$pageCount).hashCode());
        Boolean $isAlreadyPaging = this.getIsAlreadyPaging();
        result = result * 59 + ($isAlreadyPaging == null ? 43 : ((Object)$isAlreadyPaging).hashCode());
        Float $wrapBeginX = this.getWrapBeginX();
        result = result * 59 + ($wrapBeginX == null ? 43 : ((Object)$wrapBeginX).hashCode());
        Float $wrapWidth = this.getWrapWidth();
        result = result * 59 + ($wrapWidth == null ? 43 : ((Object)$wrapWidth).hashCode());
        Float $wrapHeight = this.getWrapHeight();
        result = result * 59 + ($wrapHeight == null ? 43 : ((Object)$wrapHeight).hashCode());
        ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        Page $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        ComponentType $executingComponentType = this.getExecutingComponentType();
        result = result * 59 + ($executingComponentType == null ? 43 : ((Object)((Object)$executingComponentType)).hashCode());
        PageHeader $pageHeader = this.getPageHeader();
        result = result * 59 + ($pageHeader == null ? 43 : ((Object)$pageHeader).hashCode());
        PageFooter $pageFooter = this.getPageFooter();
        result = result * 59 + ($pageFooter == null ? 43 : ((Object)$pageFooter).hashCode());
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : ((Object)$cursor).hashCode());
        List<CatalogInfo> $catalogs = this.getCatalogs();
        result = result * 59 + ($catalogs == null ? 43 : ((Object)$catalogs).hashCode());
        ContainerInfo $containerInfo = this.getContainerInfo();
        result = result * 59 + ($containerInfo == null ? 43 : ((Object)$containerInfo).hashCode());
        Map<String, Object> $customInfo = this.getCustomInfo();
        result = result * 59 + ($customInfo == null ? 43 : ((Object)$customInfo).hashCode());
        return result;
    }

    public String toString() {
        return "Context(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContentStream=" + this.getIsResetContentStream() + ", document=" + this.getDocument() + ", page=" + this.getPage() + ", pageCount=" + this.getPageCount() + ", executingComponentType=" + (Object)((Object)this.getExecutingComponentType()) + ", pageHeader=" + this.getPageHeader() + ", pageFooter=" + this.getPageFooter() + ", cursor=" + this.getCursor() + ", isAlreadyPaging=" + this.getIsAlreadyPaging() + ", wrapBeginX=" + this.getWrapBeginX() + ", wrapWidth=" + this.getWrapWidth() + ", wrapHeight=" + this.getWrapHeight() + ", catalogs=" + this.getCatalogs() + ", containerInfo=" + this.getContainerInfo() + ", customInfo=" + this.getCustomInfo() + ")";
    }
}

