/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyRecipient;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseFont;
import org.dromara.pdf.pdfbox.core.base.Banner;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.MemoryPolicy;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.enums.BorderStyle;
import org.dromara.pdf.pdfbox.core.enums.ContentMode;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.PWLength;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.core.ext.processor.MetadataProcessor;
import org.dromara.pdf.pdfbox.core.ext.processor.PageProcessor;
import org.dromara.pdf.pdfbox.core.info.CatalogInfo;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.support.DefaultResourceCache;
import org.dromara.pdf.pdfbox.util.FileUtil;

public class Document
extends AbstractBaseFont
implements Closeable {
    private static final Log log;
    private AccessPermission accessPermission;
    private Float version;
    private PDDocument target;
    private List<Page> pages;
    private Integer totalPageNumber;
    private Boolean isFlushMetadata;

    public Document() {
        this.init();
    }

    public Document(MemoryPolicy policy) {
        Objects.requireNonNull(policy, "the policy can not be null");
        this.init(policy);
    }

    public Document(File file, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.init(file, password, keyStore, alias, policy);
    }

    public Document(byte[] bytes, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.init(bytes, password, keyStore, alias, policy);
    }

    public Document(InputStream inputStream, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.init(inputStream, password, keyStore, alias, policy);
    }

    @Override
    public void setFontName(String fontName) {
        super.setFontName(fontName);
        super.setFont(PdfHandler.getFontHandler().getPDFont(this.target, fontName, true));
    }

    public void setVersion(float version) {
        float maxVersion = 1.7f;
        float minVersion = 1.0f;
        if (version < minVersion || version > maxVersion) {
            throw new IllegalArgumentException("the version must be between 1.0 and 1.7");
        }
        this.version = Float.valueOf(version);
    }

    public void setResourceCache(ResourceCache cache) {
        Objects.requireNonNull(cache, "the cache can not be null");
        this.target.setResourceCache(cache);
    }

    public int getTotalPageNumber() {
        return Optional.ofNullable(this.totalPageNumber).orElse(this.pages.size());
    }

    public Page getCurrentPage() {
        return this.getContext().getPage();
    }

    public Page getPage(int index) {
        if (Objects.isNull(this.pages) || this.pages.size() <= index) {
            return null;
        }
        return this.pages.get(index);
    }

    public List<CatalogInfo> getCatalogs() {
        return this.getContext().getCatalogs();
    }

    public void encryption() {
        this.encryption(false, PWLength.LENGTH_40, "", "");
    }

    public void encryption(boolean preferAES, PWLength length, String ownerPassword, String userPassword) {
        StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword, this.getAccessPermission());
        policy.setPreferAES(preferAES);
        policy.setEncryptionKeyLength(Optional.ofNullable(length).orElse(PWLength.LENGTH_40).getLength());
        this.getTarget().protect((ProtectionPolicy)policy);
    }

    public void encryption(InputStream certificateInputStream) {
        PublicKeyRecipient recipient = new PublicKeyRecipient();
        recipient.setPermission(this.getAccessPermission());
        recipient.setX509((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(certificateInputStream));
        PublicKeyProtectionPolicy policy = new PublicKeyProtectionPolicy();
        policy.addRecipient(recipient);
        this.getTarget().protect((ProtectionPolicy)policy);
    }

    public void decrypt() {
        this.getTarget().setAllSecurityToBeRemoved(true);
    }

    public Page createPage(PageSize rectangle) {
        return new Page(Optional.ofNullable(this.getContext()).orElse(new Context(this)), rectangle);
    }

    public Page createPage() {
        return this.createPage(PageSize.A4);
    }

    public void insertPage(int index, Page page) {
        PageProcessor processor = new PageProcessor(this);
        processor.insert(index, page);
        processor.flush();
    }

    public void appendPage(Page ... pages) {
        PageProcessor processor = new PageProcessor(this);
        for (Page page : pages) {
            processor.append(page);
        }
        processor.flush();
    }

    public void appendPage(List<Page> pages) {
        this.appendPage(pages.toArray(new Page[0]));
    }

    public void setPage(int index, Page page) {
        PageProcessor processor = new PageProcessor(this);
        processor.set(index, page);
        processor.flush();
    }

    public void save(File file) {
        Objects.requireNonNull(file, "the file can not be null");
        this.save(file.getAbsolutePath());
    }

    public void save(String path) {
        Objects.requireNonNull(path, "the path can not be null");
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(FileUtil.createDirectories(Paths.get(path, new String[0])), new OpenOption[0]));){
            this.save(outputStream);
        }
    }

    public void save(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "the output stream can not be null");
        if (this.getTarget().getNumberOfPages() == 0) {
            log.error((Object)"the document has no page, please add a page before saving");
        }
        if (Optional.ofNullable(this.getIsFlushMetadata()).orElse(Boolean.TRUE).booleanValue()) {
            MetadataProcessor processor = new MetadataProcessor(this);
            processor.flush();
        }
        this.getTarget().setVersion(this.getVersion().floatValue());
        this.getTarget().save(outputStream, new CompressParameters(Integer.MAX_VALUE));
    }

    @Override
    public void close() {
        this.getPages().forEach(Page::close);
        super.setFont(null);
        this.getContext().clear();
        try {
            this.getTarget().close();
        }
        catch (Exception e) {
            log.warn((Object)"an error occurred when the document was closed", (Throwable)e);
        }
    }

    @Override
    public void initBase() {
        super.setContext(new Context(this));
        this.initFontParams();
        this.initBorderParams();
        this.initMargin();
        this.initOtherParams();
    }

    @Override
    protected void init() {
        this.init(MemoryPolicy.setupMainMemoryOnly());
    }

    protected void init(MemoryPolicy policy) {
        this.target = new PDDocument(policy.getSetting().streamCache);
        this.target.setVersion(Constants.DEFAULT_VERSION.floatValue());
        this.target.setResourceCache((ResourceCache)new DefaultResourceCache());
        this.initBase();
        this.initPages();
    }

    protected void init(File file, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        Objects.requireNonNull(policy, "the policy can not be null");
        this.target = Loader.loadPDF((File)file, (String)password, (InputStream)keyStore, (String)alias, (RandomAccessStreamCache.StreamCacheCreateFunction)policy.getSetting().streamCache);
        this.initLoad();
    }

    protected void init(byte[] bytes, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.initLoad(new RandomAccessReadBuffer(bytes), password, keyStore, alias, policy);
    }

    protected void init(InputStream inputStream, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.initLoad(new RandomAccessReadBuffer(inputStream), password, keyStore, alias, policy);
    }

    protected void initLoad(RandomAccessReadBuffer buffer, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        Objects.requireNonNull(policy, "the policy can not be null");
        this.target = Loader.loadPDF((RandomAccessRead)buffer, (String)password, (InputStream)keyStore, (String)alias, (RandomAccessStreamCache.StreamCacheCreateFunction)policy.getSetting().streamCache);
        this.initLoad();
    }

    protected void initLoad() {
        this.target.setResourceCache((ResourceCache)new DefaultResourceCache());
        this.initBase();
        this.initPages();
        if (!this.pages.isEmpty()) {
            Page page = this.pages.get(this.pages.size() - 1);
            Context context = this.getContext();
            context.setPage(page);
            context.setIsAlreadyPaging(Boolean.FALSE);
            context.getCursor().reset(page.getMarginLeft().floatValue(), page.getHeight().floatValue() - page.getMarginTop().floatValue());
        }
    }

    protected void initPages() {
        int count = this.getTarget().getNumberOfPages();
        this.pages = new ArrayList<Page>(this.getTarget().getNumberOfPages());
        PDPageTree pageTree = this.getTarget().getPages();
        for (int i = 0; i < count; ++i) {
            this.pages.add(new Page(this.getContext(), pageTree.get(i)));
        }
    }

    protected void initBorderParams() {
        super.setBorderStyle(BorderStyle.SOLID);
        super.setBorderWidth(1.0f);
        super.setBorderLineLength(1.0f);
        super.setBorderLineSpacing(1.0f);
        super.setBorderTopColor(Color.BLACK);
        super.setBorderBottomColor(Color.BLACK);
        super.setBorderLeftColor(Color.BLACK);
        super.setBorderRightColor(Color.BLACK);
        super.setIsBorderTop(Boolean.FALSE);
        super.setIsBorderBottom(Boolean.FALSE);
        super.setIsBorderLeft(Boolean.FALSE);
        super.setIsBorderRight(Boolean.FALSE);
    }

    protected void initFontParams() {
        super.setFont(PdfHandler.getFontHandler().getPDFont(this.target, "HarmonyOS_Sans_SC_Medium", true));
        super.setFontSize(12.0f);
        super.setFontColor(Color.BLACK);
        super.setFontAlpha(Float.valueOf(1.0f));
        super.setFontStyle(FontStyle.NORMAL);
        super.setFontSlope(Float.valueOf(0.0f));
        super.setCharacterSpacing(0.0f);
        super.setLeading(0.0f);
        super.getContext().setWrapHeight(this.getFontSize());
    }

    protected void initOtherParams() {
        super.setHorizontalAlignment(HorizontalAlignment.LEFT);
        super.setVerticalAlignment(VerticalAlignment.TOP);
        super.setContentMode(ContentMode.APPEND);
        super.setIsResetContentStream(Boolean.TRUE);
        super.setBackgroundColor(Color.WHITE);
        this.accessPermission = this.target.getCurrentAccessPermission();
        this.version = Float.valueOf(this.target.getVersion());
        this.isFlushMetadata = Boolean.TRUE;
    }

    public AccessPermission getAccessPermission() {
        return this.accessPermission;
    }

    public Float getVersion() {
        return this.version;
    }

    public PDDocument getTarget() {
        return this.target;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public Boolean getIsFlushMetadata() {
        return this.isFlushMetadata;
    }

    public void setAccessPermission(AccessPermission accessPermission) {
        this.accessPermission = accessPermission;
    }

    public void setTarget(PDDocument target) {
        this.target = target;
    }

    public void setPages(List<Page> pages) {
        this.pages = pages;
    }

    public void setTotalPageNumber(Integer totalPageNumber) {
        this.totalPageNumber = totalPageNumber;
    }

    public void setIsFlushMetadata(Boolean isFlushMetadata) {
        this.isFlushMetadata = isFlushMetadata;
    }

    @Override
    public String toString() {
        return "Document(accessPermission=" + this.getAccessPermission() + ", version=" + this.getVersion() + ", target=" + this.getTarget() + ", pages=" + this.getPages() + ", totalPageNumber=" + this.getTotalPageNumber() + ", isFlushMetadata=" + this.getIsFlushMetadata() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$version = this.getVersion();
        Float other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        if (this.getTotalPageNumber() != other.getTotalPageNumber()) {
            return false;
        }
        Boolean this$isFlushMetadata = this.getIsFlushMetadata();
        Boolean other$isFlushMetadata = other.getIsFlushMetadata();
        if (this$isFlushMetadata == null ? other$isFlushMetadata != null : !((Object)this$isFlushMetadata).equals(other$isFlushMetadata)) {
            return false;
        }
        AccessPermission this$accessPermission = this.getAccessPermission();
        AccessPermission other$accessPermission = other.getAccessPermission();
        if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) {
            return false;
        }
        PDDocument this$target = this.getTarget();
        PDDocument other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        List<Page> this$pages = this.getPages();
        List<Page> other$pages = other.getPages();
        return !(this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Document;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        result = result * 59 + this.getTotalPageNumber();
        Boolean $isFlushMetadata = this.getIsFlushMetadata();
        result = result * 59 + ($isFlushMetadata == null ? 43 : ((Object)$isFlushMetadata).hashCode());
        AccessPermission $accessPermission = this.getAccessPermission();
        result = result * 59 + ($accessPermission == null ? 43 : $accessPermission.hashCode());
        PDDocument $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        List<Page> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        return result;
    }

    static {
        Banner.print();
        log = LogFactory.getLog(Document.class);
    }
}

