/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.awt.Color;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseFont;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Cursor;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.enums.RotationAngle;
import org.dromara.pdf.pdfbox.handler.PdfHandler;

public class Page
extends AbstractBaseFont
implements Closeable {
    private String id;
    private PDPage target;
    private PageSize pageSize;
    private Integer index;
    private Page parentPage;
    private Page subPage;

    public Page(Context context, PageSize pageSize) {
        this(context, new PDPage(pageSize.getSize()));
    }

    public Page(Context context, PDPage page) {
        this.init(context, page);
        if (this.getBackgroundColor() != Color.WHITE) {
            this.initBackgroundColor();
        }
        context.reset(this);
        this.index = context.getPageCount();
    }

    @Override
    public void init() {
    }

    @Override
    public void initBase() {
    }

    @Override
    public void setMarginTop(float margin) {
        Float height = this.getContext().getPage().getHeight();
        Float marginTop = this.getMarginTop();
        super.setMarginTop(margin);
        Cursor cursor = this.getContext().getCursor();
        if (Objects.equals(cursor.getY(), Float.valueOf(height.floatValue() - marginTop.floatValue()))) {
            cursor.setY(Float.valueOf(height.floatValue() - margin));
        }
    }

    @Override
    public void setMarginLeft(float margin) {
        Float marginLeft = this.getMarginLeft();
        super.setMarginLeft(margin);
        Cursor cursor = this.getContext().getCursor();
        if (Objects.equals(cursor.getX(), marginLeft)) {
            cursor.setX(Float.valueOf(margin));
        }
    }

    @Override
    public void setFontName(String fontName) {
        super.setFontName(fontName);
        super.setFont(PdfHandler.getFontHandler().getPDFont(this.getContext().getTargetDocument(), fontName, true));
    }

    public Float getWidth() {
        return this.pageSize.getWidth();
    }

    public Float getHeight() {
        return this.pageSize.getHeight();
    }

    public Float getWithoutMarginWidth() {
        return Float.valueOf(this.getWidth().floatValue() - this.getMarginLeft().floatValue() - this.getMarginRight().floatValue());
    }

    public Float getWithoutMarginHeight() {
        return Float.valueOf(this.getHeight().floatValue() - this.getMarginTop().floatValue() - this.getMarginBottom().floatValue());
    }

    public Page getFirstParentPage() {
        Page parent = this.getParentPage();
        if (Objects.nonNull(parent)) {
            while (Objects.nonNull(parent.getParentPage())) {
                parent = parent.getParentPage();
            }
        }
        return parent;
    }

    public Page getLastSubPage() {
        Page subPage = this.getSubPage();
        if (Objects.nonNull(subPage)) {
            while (Objects.nonNull(subPage.getSubPage())) {
                subPage = subPage.getSubPage();
            }
        }
        return subPage;
    }

    public Page getLastPage() {
        return Optional.ofNullable(this.getLastSubPage()).orElse(this);
    }

    public Integer getLastNo() {
        int index = Optional.ofNullable(this.getParentPage()).map(p -> 0).orElse(1);
        Page subPage = Optional.ofNullable(this.getFirstParentPage()).orElse(this.getSubPage());
        if (Objects.nonNull(subPage)) {
            ++index;
            while (Objects.nonNull(subPage.getSubPage())) {
                ++index;
                subPage = subPage.getSubPage();
            }
        }
        return index;
    }

    public String getPlaceholder() {
        return "${CPN}";
    }

    public void rotation(RotationAngle angle) {
        Objects.requireNonNull(angle, "the rotation angle can not be null");
        this.target.setRotation(angle.getAngle().intValue());
    }

    public void scale(PageSize rectangle) {
        Objects.requireNonNull(rectangle, "the rectangle can not be null");
        this.getTarget().setArtBox(this.getPageSize().getSize());
        this.getTarget().setMediaBox(rectangle.getSize());
        this.getTarget().setCropBox(null);
        this.setPageSize(rectangle);
    }

    public void crop(PageSize rectangle) {
        Objects.requireNonNull(rectangle, "the rectangle can not be null");
        this.getTarget().setArtBox(this.getPageSize().getSize());
        this.getTarget().setCropBox(rectangle.getSize());
        this.setPageSize(rectangle);
    }

    public void resetRectangle() {
        COSArray artBox = this.getTarget().getCOSObject().getCOSArray(COSName.ART_BOX);
        if (Objects.nonNull(artBox)) {
            PDRectangle rectangle = new PDRectangle(artBox);
            this.getTarget().setMediaBox(rectangle);
            this.setPageSize(new PageSize(rectangle));
        } else {
            this.setPageSize(new PageSize(this.getTarget().getMediaBox()));
        }
        this.getTarget().setCropBox(null);
        this.getTarget().setArtBox(null);
    }

    public void createSubPage() {
        Page subPage = new Page(this.getContext(), this.getPageSize());
        subPage.init(this, true);
        subPage.setParentPage(this);
        this.setSubPage(subPage);
    }

    @Override
    public void close() {
        super.setContext(null);
        this.setTarget(null);
        this.setParentPage(null);
        this.setSubPage(null);
    }

    private void init(Context context, PDPage target) {
        super.setContext(context);
        super.init(context.getDocument(), true);
        this.id = UUID.randomUUID().toString();
        this.target = target;
        this.pageSize = new PageSize(target.getCropBox());
    }

    private void initBackgroundColor() {
        PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getTarget(), PDPageContentStream.AppendMode.APPEND, true, this.getIsResetContentStream().booleanValue());
        contentStream.addRect(0.0f, 0.0f, this.getWidth().floatValue(), this.getHeight().floatValue());
        contentStream.setNonStrokingColor(this.getBackgroundColor());
        contentStream.fill();
        contentStream.close();
    }

    public String getId() {
        return this.id;
    }

    public PDPage getTarget() {
        return this.target;
    }

    public PageSize getPageSize() {
        return this.pageSize;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Page getParentPage() {
        return this.parentPage;
    }

    public Page getSubPage() {
        return this.subPage;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTarget(PDPage target) {
        this.target = target;
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setParentPage(Page parentPage) {
        this.parentPage = parentPage;
    }

    public void setSubPage(Page subPage) {
        this.subPage = subPage;
    }

    @Override
    public String toString() {
        return "Page(id=" + this.getId() + ", target=" + this.getTarget() + ", pageSize=" + this.getPageSize() + ", index=" + this.getIndex() + ", parentPage=" + this.getParentPage() + ", subPage=" + this.getSubPage() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PDPage this$target = this.getTarget();
        PDPage other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        PageSize this$pageSize = this.getPageSize();
        PageSize other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !this$pageSize.equals(other$pageSize)) {
            return false;
        }
        Page this$parentPage = this.getParentPage();
        Page other$parentPage = other.getParentPage();
        if (this$parentPage == null ? other$parentPage != null : !((Object)this$parentPage).equals(other$parentPage)) {
            return false;
        }
        Page this$subPage = this.getSubPage();
        Page other$subPage = other.getSubPage();
        return !(this$subPage == null ? other$subPage != null : !((Object)this$subPage).equals(other$subPage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PDPage $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        PageSize $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : $pageSize.hashCode());
        Page $parentPage = this.getParentPage();
        result = result * 59 + ($parentPage == null ? 43 : ((Object)$parentPage).hashCode());
        Page $subPage = this.getSubPage();
        result = result * 59 + ($subPage == null ? 43 : ((Object)$subPage).hashCode());
        return result;
    }
}

