/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.awt.Rectangle;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.support.Constants;

public class PageSize {
    private static final Integer POINTS_PER_INCH = Constants.POINTS_PER_INCH;
    private static final Float POINTS_PER_MM = Constants.POINTS_PER_MM;
    private final Float width;
    private final Float height;
    private final PDRectangle size;
    public static final PageSize A0 = new PageSize(841.0f * POINTS_PER_MM.floatValue(), 1189.0f * POINTS_PER_MM.floatValue());
    public static final PageSize A1 = new PageSize(594.0f * POINTS_PER_MM.floatValue(), 841.0f * POINTS_PER_MM.floatValue());
    public static final PageSize A2 = new PageSize(420.0f * POINTS_PER_MM.floatValue(), 594.0f * POINTS_PER_MM.floatValue());
    public static final PageSize A3 = new PageSize(297.0f * POINTS_PER_MM.floatValue(), 420.0f * POINTS_PER_MM.floatValue());
    public static final PageSize A4 = new PageSize(210.0f * POINTS_PER_MM.floatValue(), 297.0f * POINTS_PER_MM.floatValue());
    public static final PageSize A5 = new PageSize(148.0f * POINTS_PER_MM.floatValue(), 210.0f * POINTS_PER_MM.floatValue());
    public static final PageSize A6 = new PageSize(105.0f * POINTS_PER_MM.floatValue(), 148.0f * POINTS_PER_MM.floatValue());
    public static final PageSize A7 = new PageSize(74.0f * POINTS_PER_MM.floatValue(), 105.0f * POINTS_PER_MM.floatValue());
    public static final PageSize A8 = new PageSize(52.0f * POINTS_PER_MM.floatValue(), 74.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B0 = new PageSize(1030.0f * POINTS_PER_MM.floatValue(), 1456.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B1 = new PageSize(728.0f * POINTS_PER_MM.floatValue(), 1030.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B2 = new PageSize(515.0f * POINTS_PER_MM.floatValue(), 728.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B3 = new PageSize(364.0f * POINTS_PER_MM.floatValue(), 515.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B4 = new PageSize(257.0f * POINTS_PER_MM.floatValue(), 364.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B5 = new PageSize(182.0f * POINTS_PER_MM.floatValue(), 257.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B6 = new PageSize(128.0f * POINTS_PER_MM.floatValue(), 182.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B7 = new PageSize(91.0f * POINTS_PER_MM.floatValue(), 128.0f * POINTS_PER_MM.floatValue());
    public static final PageSize B8 = new PageSize(64.0f * POINTS_PER_MM.floatValue(), 91.0f * POINTS_PER_MM.floatValue());

    PageSize(PDRectangle size) {
        this.width = Float.valueOf(size.getWidth());
        this.height = Float.valueOf(size.getHeight());
        this.size = size;
    }

    private PageSize(float width, float height) {
        this.width = Float.valueOf(Math.abs(width));
        this.height = Float.valueOf(Math.abs(height));
        this.size = new PDRectangle(this.width.floatValue(), this.height.floatValue());
    }

    private PageSize(float leftX, float rightX, float bottomY, float topY) {
        this.width = Float.valueOf(Math.abs(rightX - leftX));
        this.height = Float.valueOf(Math.abs(topY - bottomY));
        this.size = new PDRectangle(new BoundingBox(leftX, bottomY, rightX, topY));
    }

    public static PageSize create(float width, float height) {
        return new PageSize(width, height);
    }

    public static PageSize create(float leftX, float rightX, float bottomY, float topY) {
        return new PageSize(leftX, rightX, bottomY, topY);
    }

    public PageSize changeLandscape() {
        return new PageSize(this.height.floatValue(), this.width.floatValue());
    }

    public static float getUnit() {
        return POINTS_PER_MM.floatValue();
    }

    public float getLeftX() {
        return this.size.getLowerLeftX();
    }

    public float getRightX() {
        return this.size.getUpperRightX();
    }

    public float getBottomY() {
        return this.size.getLowerLeftY();
    }

    public float getTopY() {
        return this.size.getUpperRightY();
    }

    public Rectangle toRectangle() {
        return new Rectangle((int)this.getLeftX(), (int)this.getBottomY(), this.getWidth().intValue(), this.getHeight().intValue());
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public PDRectangle getSize() {
        return this.size;
    }
}

