/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class Image
extends AbstractComponent {
    private PDImageXObject image;
    private Integer width;
    private Integer height;
    private Float angle;
    private Float scale;

    public Image(Page page) {
        super(page);
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("the width can not be less than 1");
        }
        this.width = width;
    }

    public void setHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("the height can not be less than 1");
        }
        this.height = height;
    }

    public void setImage(File file) {
        Objects.requireNonNull(file, "the image file can not be null");
        this.setImage(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public void setImage(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "the image input stream can not be null");
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)outputStream);
            this.setImage(outputStream.toByteArray());
        }
    }

    public void setImage(byte[] bytes) {
        Objects.requireNonNull(bytes, "the image bytes can not be null");
        this.image = PDImageXObject.createFromByteArray((PDDocument)this.getContext().getTargetDocument(), (byte[])ImageUtil.resetBytes(bytes), (String)"unknown");
    }

    @Override
    public ComponentType getType() {
        return ComponentType.IMAGE;
    }

    @Override
    public void virtualRender() {
        this.init();
        this.reset();
    }

    @Override
    public void render() {
        this.init();
        this.writeImage();
        this.reset();
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.getImage(), "the image can not be null");
        super.init();
        this.initWidthAndHeight();
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
        if (this.isWrap()) {
            this.wrap();
        }
        super.setBeginY(Float.valueOf(this.getBeginY().floatValue() - (float)this.getHeight().intValue()), false);
        if (!this.getIsCustomY().booleanValue() && this.isPaging(this, this.getBeginY().floatValue())) {
            super.setBeginY(Float.valueOf(this.getBeginY().floatValue() - (float)this.getHeight().intValue()), false);
        }
    }

    protected void initWidthAndHeight() {
        if (Objects.isNull(this.scale)) {
            this.scale = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.width)) {
            this.width = (int)((float)this.image.getWidth() * this.scale.floatValue());
        }
        if (Objects.isNull(this.height)) {
            this.height = (int)((float)this.image.getHeight() * this.scale.floatValue());
        }
    }

    protected void writeImage() {
        float offsetX = 0.5f * (float)this.getWidth().intValue();
        float offsetY = 0.5f * (float)this.getHeight().intValue();
        PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        contentStream.saveGraphicsState();
        contentStream.transform(Matrix.getTranslateInstance((float)(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue() + offsetX), (float)(this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue() + offsetY)));
        contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(this.getAngle().floatValue()), (float)0.0f, (float)0.0f));
        contentStream.transform(Matrix.getTranslateInstance((float)(-offsetX), (float)(-offsetY)));
        contentStream.drawImage(this.getImage(), 0.0f, 0.0f, (float)this.getWidth().intValue(), (float)this.getHeight().intValue());
        BorderUtil.drawNormalBorder(contentStream, this.getRectangle(), this);
        contentStream.close();
    }

    protected PDRectangle getRectangle() {
        PDRectangle rectangle = new PDRectangle();
        rectangle.setLowerLeftX(0.0f);
        rectangle.setUpperRightX((float)this.getWidth().intValue());
        rectangle.setLowerLeftY(0.0f);
        rectangle.setUpperRightY((float)this.getHeight().intValue());
        return rectangle;
    }

    protected void reset() {
        this.getContext().getCursor().setX(Float.valueOf(this.getBeginX().floatValue() + (float)this.getWidth().intValue() + this.getMarginRight().floatValue()));
        super.reset(this.getType());
        this.getContext().setWrapHeight(Float.valueOf(this.getHeight().intValue()));
    }

    public PDImageXObject getImage() {
        return this.image;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Float getAngle() {
        return this.angle;
    }

    public Float getScale() {
        return this.scale;
    }

    public void setAngle(Float angle) {
        this.angle = angle;
    }

    public void setScale(Float scale) {
        this.scale = scale;
    }

    @Override
    public String toString() {
        return "Image(image=" + this.getImage() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", angle=" + this.getAngle() + ", scale=" + this.getScale() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        Float this$scale = this.getScale();
        Float other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        PDImageXObject this$image = this.getImage();
        PDImageXObject other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Image;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        Float $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        PDImageXObject $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }
}

