/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseBorder;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.Watermark;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class ImageWatermark
extends AbstractBaseBorder
implements Watermark {
    private Float beginX;
    private Float beginY;
    private PDImageXObject image;
    private Integer width;
    private Integer height;
    private Integer lines;
    private Integer countOfLine;
    private Float leading;
    private Float spacingOfLine;
    private Float angle;

    public ImageWatermark(Document document) {
        super.setContext(document.getContext());
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("the width can not be less than 1");
        }
        this.width = width;
    }

    public void setHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("the height can not be less than 1");
        }
        this.height = height;
    }

    public void setImage(File file) {
        Objects.requireNonNull(file, "the image file can not be null");
        this.setImage(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public void setImage(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "the image input stream can not be null");
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)outputStream);
            this.setImage(outputStream.toByteArray());
        }
    }

    public void setImage(byte[] bytes) {
        Objects.requireNonNull(bytes, "the image bytes can not be null");
        this.image = PDImageXObject.createFromByteArray((PDDocument)this.getContext().getTargetDocument(), (byte[])ImageUtil.resetBytes(bytes), (String)"unknown");
    }

    @Override
    public ComponentType getType() {
        return ComponentType.WATERMARK;
    }

    @Override
    public void initBase() {
        Objects.requireNonNull(this.image, "the image can not be null");
        if (Objects.isNull((Object)this.getContext().getExecutingComponentType())) {
            this.getContext().setExecutingComponentType(this.getType());
        }
        if (Objects.isNull(this.width)) {
            this.width = this.image.getWidth();
        }
        if (Objects.isNull(this.height)) {
            this.height = this.image.getHeight();
        }
        if (Objects.isNull(this.lines)) {
            this.lines = 1;
        }
        if (Objects.isNull(this.countOfLine)) {
            this.countOfLine = 1;
        }
        if (Objects.isNull(this.leading)) {
            this.leading = Float.valueOf(this.height.intValue());
        }
        if (Objects.isNull(this.spacingOfLine)) {
            this.spacingOfLine = Float.valueOf(this.width.intValue());
        }
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
    }

    @Override
    public void render(Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        this.init(page);
        this.renderImage(page);
    }

    @Override
    public void render(Document document) {
        Objects.requireNonNull(document, "the document can not be null");
        document.getPages().forEach(this::render);
    }

    protected void init(Page page) {
        super.init(page, false);
        this.initBase();
        if (Objects.isNull(this.beginX)) {
            this.beginX = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.beginY)) {
            this.beginY = Float.valueOf(page.getHeight().floatValue() - (float)this.height.intValue());
        }
    }

    protected void renderImage(Page page) {
        float beginX = this.getBeginX().floatValue();
        float beginY = this.getBeginY().floatValue();
        float offsetX = 0.5f * (float)this.getWidth().intValue();
        float offsetY = 0.5f * (float)this.getHeight().intValue();
        for (int i = 0; i < this.getLines(); ++i) {
            for (int j = 0; j < this.getCountOfLine(); ++j) {
                this.writeImage(page, beginX, beginY, offsetX, offsetY);
                beginX = beginX + (float)this.getWidth().intValue() + this.getSpacingOfLine().floatValue();
            }
            beginX = this.getBeginX().floatValue();
            beginY = beginY - (float)this.getHeight().intValue() - this.getLeading().floatValue();
        }
    }

    protected void writeImage(Page page, float beginX, float beginY, float offsetX, float offsetY) {
        PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), page.getTarget(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        contentStream.saveGraphicsState();
        contentStream.transform(Matrix.getTranslateInstance((float)(beginX + offsetX), (float)(beginY + offsetY)));
        contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(this.getAngle().floatValue()), (float)0.0f, (float)0.0f));
        contentStream.transform(Matrix.getTranslateInstance((float)(-offsetX), (float)(-offsetY)));
        contentStream.drawImage(this.getImage(), 0.0f, 0.0f, (float)this.getWidth().intValue(), (float)this.getHeight().intValue());
        contentStream.close();
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public PDImageXObject getImage() {
        return this.image;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getLines() {
        return this.lines;
    }

    public Integer getCountOfLine() {
        return this.countOfLine;
    }

    public Float getLeading() {
        return this.leading;
    }

    public Float getSpacingOfLine() {
        return this.spacingOfLine;
    }

    public Float getAngle() {
        return this.angle;
    }

    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    public void setLines(Integer lines) {
        this.lines = lines;
    }

    public void setCountOfLine(Integer countOfLine) {
        this.countOfLine = countOfLine;
    }

    public void setLeading(Float leading) {
        this.leading = leading;
    }

    public void setSpacingOfLine(Float spacingOfLine) {
        this.spacingOfLine = spacingOfLine;
    }

    public void setAngle(Float angle) {
        this.angle = angle;
    }

    @Override
    public String toString() {
        return "ImageWatermark(beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", image=" + this.getImage() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", lines=" + this.getLines() + ", countOfLine=" + this.getCountOfLine() + ", leading=" + this.getLeading() + ", spacingOfLine=" + this.getSpacingOfLine() + ", angle=" + this.getAngle() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageWatermark)) {
            return false;
        }
        ImageWatermark other = (ImageWatermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$lines = this.getLines();
        Integer other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        Integer this$countOfLine = this.getCountOfLine();
        Integer other$countOfLine = other.getCountOfLine();
        if (this$countOfLine == null ? other$countOfLine != null : !((Object)this$countOfLine).equals(other$countOfLine)) {
            return false;
        }
        Float this$leading = this.getLeading();
        Float other$leading = other.getLeading();
        if (this$leading == null ? other$leading != null : !((Object)this$leading).equals(other$leading)) {
            return false;
        }
        Float this$spacingOfLine = this.getSpacingOfLine();
        Float other$spacingOfLine = other.getSpacingOfLine();
        if (this$spacingOfLine == null ? other$spacingOfLine != null : !((Object)this$spacingOfLine).equals(other$spacingOfLine)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        PDImageXObject this$image = this.getImage();
        PDImageXObject other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImageWatermark;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        Integer $countOfLine = this.getCountOfLine();
        result = result * 59 + ($countOfLine == null ? 43 : ((Object)$countOfLine).hashCode());
        Float $leading = this.getLeading();
        result = result * 59 + ($leading == null ? 43 : ((Object)$leading).hashCode());
        Float $spacingOfLine = this.getSpacingOfLine();
        result = result * 59 + ($spacingOfLine == null ? 43 : ((Object)$spacingOfLine).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        PDImageXObject $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }
}

