/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.handler.PdfHandler;

public class SplitLine
extends AbstractComponent {
    private Color lineColor;
    private LineCapStyle lineCapStyle;
    private Float lineLength;
    private Float lineWidth;
    private Float dottedLength;
    private Float dottedSpacing;

    public SplitLine(Page page) {
        super(page);
    }

    @Override
    public void setFontName(String fontName) {
        super.setFontName(fontName);
        super.setFont(null);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.SPLIT_LINE;
    }

    @Override
    public void virtualRender() {
        this.init();
        if (!this.getIsCustomY().booleanValue()) {
            this.isPaging(this, this.getBeginY().floatValue());
        }
        this.getContext().getCursor().setX(Float.valueOf(this.getBeginX().floatValue() + this.getLineLength().floatValue() + this.getMarginRight().floatValue()));
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getLineWidth());
    }

    @Override
    public void render() {
        this.init();
        if (!this.getIsCustomY().booleanValue()) {
            this.isPaging(this, this.getBeginY().floatValue());
        }
        PDPageContentStream stream = this.initContentStream();
        float beginX = this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue();
        float beginY = this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue();
        if (this.getDottedSpacing().floatValue() == 0.0f) {
            this.renderSolid(stream, beginX, beginY);
        } else {
            this.renderDotted(stream, beginX, beginY);
        }
        stream.stroke();
        stream.close();
        this.getContext().getCursor().setX(Float.valueOf(this.getBeginX().floatValue() + this.getLineLength().floatValue() + this.getMarginRight().floatValue()));
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getLineWidth());
    }

    @Override
    protected void init() {
        super.init();
        if (Objects.nonNull(this.getFontName())) {
            PDFont pdFont = PdfHandler.getFontHandler().getPDFont(this.getContext().getTargetDocument(), this.getFontName(), true);
            super.setFont(pdFont);
        }
        if (Objects.isNull(this.getLineColor())) {
            this.lineColor = Color.BLACK;
        }
        if (Objects.isNull((Object)this.getLineCapStyle())) {
            this.lineCapStyle = LineCapStyle.NORMAL;
        }
        if (Objects.isNull(this.getLineLength())) {
            this.lineLength = Float.valueOf(this.getContext().getPage().getWithoutMarginWidth().floatValue() - this.getMarginLeft().floatValue() - this.getMarginRight().floatValue());
        }
        if (Objects.isNull(this.getLineWidth())) {
            this.lineWidth = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.getDottedLength())) {
            this.dottedLength = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.getDottedSpacing())) {
            this.dottedSpacing = Float.valueOf(0.0f);
        }
        if (this.getContext().isContainerWrap() || !this.getIsCustomY().booleanValue() && this.getContext().isFirstLine()) {
            super.setBeginY(Float.valueOf(this.getBeginY().floatValue() - this.getLineWidth().floatValue()));
        }
    }

    protected PDPageContentStream initContentStream() {
        PDPageContentStream stream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        stream.setFont(this.getFont(), this.getFontSize().floatValue());
        stream.setLineWidth(this.getLineWidth().floatValue());
        stream.setStrokingColor(this.getLineColor());
        stream.setLineCapStyle(this.getLineCapStyle().getType());
        return stream;
    }

    protected void renderSolid(PDPageContentStream stream, float beginX, float beginY) {
        stream.moveTo(beginX, beginY);
        stream.lineTo(beginX + this.getLineLength().floatValue(), beginY);
    }

    protected void renderDotted(PDPageContentStream stream, float beginX, float beginY) {
        float endX = beginX + this.getLineLength().floatValue();
        stream.moveTo(beginX, beginY);
        boolean flag = true;
        while (flag) {
            stream.lineTo(beginX += this.getDottedLength().floatValue(), beginY);
            beginX += this.getDottedSpacing().floatValue();
            if (beginX >= endX) {
                flag = false;
                continue;
            }
            stream.moveTo(beginX, beginY);
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public LineCapStyle getLineCapStyle() {
        return this.lineCapStyle;
    }

    public Float getLineLength() {
        return this.lineLength;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public Float getDottedLength() {
        return this.dottedLength;
    }

    public Float getDottedSpacing() {
        return this.dottedSpacing;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setLineCapStyle(LineCapStyle lineCapStyle) {
        this.lineCapStyle = lineCapStyle;
    }

    public void setLineLength(Float lineLength) {
        this.lineLength = lineLength;
    }

    public void setLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setDottedLength(Float dottedLength) {
        this.dottedLength = dottedLength;
    }

    public void setDottedSpacing(Float dottedSpacing) {
        this.dottedSpacing = dottedSpacing;
    }

    @Override
    public String toString() {
        return "SplitLine(lineColor=" + this.getLineColor() + ", lineCapStyle=" + (Object)((Object)this.getLineCapStyle()) + ", lineLength=" + this.getLineLength() + ", lineWidth=" + this.getLineWidth() + ", dottedLength=" + this.getDottedLength() + ", dottedSpacing=" + this.getDottedSpacing() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitLine)) {
            return false;
        }
        SplitLine other = (SplitLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$lineLength = this.getLineLength();
        Float other$lineLength = other.getLineLength();
        if (this$lineLength == null ? other$lineLength != null : !((Object)this$lineLength).equals(other$lineLength)) {
            return false;
        }
        Float this$lineWidth = this.getLineWidth();
        Float other$lineWidth = other.getLineWidth();
        if (this$lineWidth == null ? other$lineWidth != null : !((Object)this$lineWidth).equals(other$lineWidth)) {
            return false;
        }
        Float this$dottedLength = this.getDottedLength();
        Float other$dottedLength = other.getDottedLength();
        if (this$dottedLength == null ? other$dottedLength != null : !((Object)this$dottedLength).equals(other$dottedLength)) {
            return false;
        }
        Float this$dottedSpacing = this.getDottedSpacing();
        Float other$dottedSpacing = other.getDottedSpacing();
        if (this$dottedSpacing == null ? other$dottedSpacing != null : !((Object)this$dottedSpacing).equals(other$dottedSpacing)) {
            return false;
        }
        Color this$lineColor = this.getLineColor();
        Color other$lineColor = other.getLineColor();
        if (this$lineColor == null ? other$lineColor != null : !((Object)this$lineColor).equals(other$lineColor)) {
            return false;
        }
        LineCapStyle this$lineCapStyle = this.getLineCapStyle();
        LineCapStyle other$lineCapStyle = other.getLineCapStyle();
        return !(this$lineCapStyle == null ? other$lineCapStyle != null : !((Object)((Object)this$lineCapStyle)).equals((Object)other$lineCapStyle));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SplitLine;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $lineLength = this.getLineLength();
        result = result * 59 + ($lineLength == null ? 43 : ((Object)$lineLength).hashCode());
        Float $lineWidth = this.getLineWidth();
        result = result * 59 + ($lineWidth == null ? 43 : ((Object)$lineWidth).hashCode());
        Float $dottedLength = this.getDottedLength();
        result = result * 59 + ($dottedLength == null ? 43 : ((Object)$dottedLength).hashCode());
        Float $dottedSpacing = this.getDottedSpacing();
        result = result * 59 + ($dottedSpacing == null ? 43 : ((Object)$dottedSpacing).hashCode());
        Color $lineColor = this.getLineColor();
        result = result * 59 + ($lineColor == null ? 43 : ((Object)$lineColor).hashCode());
        LineCapStyle $lineCapStyle = this.getLineCapStyle();
        result = result * 59 + ($lineCapStyle == null ? 43 : ((Object)((Object)$lineCapStyle)).hashCode());
        return result;
    }
}

