/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.analyzer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractAnalyzer;
import org.dromara.pdf.pdfbox.core.info.FormFieldInfo;

public abstract class AbstractFormAnalyzer
extends AbstractAnalyzer {
    protected List<PDField> fieldList;
    protected Map<Integer, Set<FormFieldInfo>> infoMap;
    protected final Set<FormFieldInfo> infoSet = new HashSet<FormFieldInfo>(16);
    protected Set<FormFieldInfo> tempSet = new HashSet<FormFieldInfo>(16);

    public AbstractFormAnalyzer(Document document) {
        super(document);
    }

    public abstract void processForm(int var1, PDPage var2);

    protected Set<FormFieldInfo> getFields(int pageIndex) {
        if (Objects.isNull(this.infoMap)) {
            this.initInfoMap();
        }
        Set<FormFieldInfo> infos = Optional.ofNullable(this.infoMap.get(pageIndex)).orElse(Collections.emptySet());
        if (log.isDebugEnabled()) {
            for (FormFieldInfo info : infos) {
                log.debug((Object)("\n********************************************ANALYZE FORM FIELD BEGIN********************************************\npage index: " + info.getPageIndex() + "\npage width: " + info.getPageWidth() + "\npage height: " + info.getPageHeight() + "\nfield type: " + info.getType() + "\nfield name: " + info.getName() + "\nfield value: " + info.getValue() + "\nfield is readOnly: " + info.getIsReadOnly() + "\nfield is required: " + info.getIsRequired() + "\nfield is no export: " + info.getIsNoExport() + "\n*********************************************ANALYZE FORM FIELD END*********************************************"));
            }
        }
        return infos;
    }

    protected void initInfoMap() {
        PDAcroForm form = this.getDocument().getDocumentCatalog().getAcroForm(null);
        if (Objects.isNull(form)) {
            this.infoMap = Collections.emptyMap();
        } else {
            this.infoMap = new HashMap<Integer, Set<FormFieldInfo>>(this.getDocument().getPages().getCount() + 1);
            form.getFields().forEach(this::processField);
        }
        this.processPageInfo();
    }

    protected void processField(PDField field) {
        PDPage page = null;
        List widgets = field.getWidgets();
        if (!widgets.isEmpty()) {
            page = ((PDAnnotationWidget)widgets.get(0)).getPage();
        }
        FormFieldInfo info = FormFieldInfo.builder().type(field.getFieldType()).name(field.getFullyQualifiedName()).value(field.getValueAsString()).isReadOnly(field.isReadOnly()).isRequired(field.isRequired()).isNoExport(field.isNoExport()).page(page).build();
        this.tempSet.add(info);
    }

    protected void processPageInfo() {
        if (!this.tempSet.isEmpty()) {
            int unknownIndex = -1;
            PDPageTree pageTree = this.getDocument().getPages();
            for (FormFieldInfo info : this.tempSet) {
                boolean isUnknown = true;
                for (int index = 0; index < pageTree.getCount(); ++index) {
                    PDPage page = info.getPage();
                    if (!Objects.nonNull(page) || !page.equals((Object)pageTree.get(index))) continue;
                    PDRectangle rectangle = page.getMediaBox();
                    info.setPageIndex(index);
                    info.setPageWidth(Float.valueOf(rectangle.getWidth()));
                    info.setPageHeight(Float.valueOf(rectangle.getHeight()));
                    Set<FormFieldInfo> infos = this.infoMap.get(index);
                    if (Objects.isNull(infos)) {
                        infos = new HashSet<FormFieldInfo>(16);
                        this.infoMap.put(index, infos);
                    }
                    infos.add(info);
                    isUnknown = false;
                    break;
                }
                if (!isUnknown) continue;
                Set<FormFieldInfo> infos = this.infoMap.get(-1);
                if (Objects.isNull(infos)) {
                    infos = new HashSet<FormFieldInfo>(16);
                    this.infoMap.put(-1, infos);
                }
                infos.add(info);
            }
        }
        this.tempSet = new HashSet<FormFieldInfo>(16);
    }

    public List<PDField> getFieldList() {
        return this.fieldList;
    }

    public Map<Integer, Set<FormFieldInfo>> getInfoMap() {
        return this.infoMap;
    }

    public Set<FormFieldInfo> getInfoSet() {
        return this.infoSet;
    }

    public Set<FormFieldInfo> getTempSet() {
        return this.tempSet;
    }
}

