/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.analyzer;

import java.io.Closeable;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractBookmarkAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractCommentAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractFormAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractImageAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractTextAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.BookmarkAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.CommentAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.FormAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.ImageAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.TextAnalyzer;
import org.dromara.pdf.pdfbox.core.info.BookmarkInfo;
import org.dromara.pdf.pdfbox.core.info.CommentInfo;
import org.dromara.pdf.pdfbox.core.info.FormFieldInfo;
import org.dromara.pdf.pdfbox.core.info.ImageInfo;
import org.dromara.pdf.pdfbox.core.info.TextInfo;

public class DocumentAnalyzer
extends AbstractAnalyzer
implements Closeable {
    protected AbstractTextAnalyzer textAnalyzer;
    protected AbstractCommentAnalyzer commentAnalyzer;
    protected AbstractImageAnalyzer imageAnalyzer;
    protected AbstractFormAnalyzer formAnalyzer;
    protected AbstractBookmarkAnalyzer bookmarkAnalyzer;

    public DocumentAnalyzer(Document document) {
        super(document);
    }

    public Set<TextInfo> analyzeText(int ... pageIndexes) {
        if (Objects.isNull(this.textAnalyzer)) {
            this.textAnalyzer = new TextAnalyzer(this.document);
        }
        this.process((index, page) -> this.textAnalyzer.processText((int)index), pageIndexes);
        return this.textAnalyzer.getInfoSet();
    }

    public Set<CommentInfo> analyzeComment(int ... pageIndexes) {
        if (Objects.isNull(this.commentAnalyzer)) {
            this.commentAnalyzer = new CommentAnalyzer(this.document);
        }
        this.process(this.commentAnalyzer::processComment, pageIndexes);
        return this.commentAnalyzer.getInfoSet();
    }

    public Set<ImageInfo> analyzeImage(int ... pageIndexes) {
        if (Objects.isNull(this.imageAnalyzer)) {
            this.imageAnalyzer = new ImageAnalyzer(this.document);
        }
        this.process(this.imageAnalyzer::processImage, pageIndexes);
        return this.imageAnalyzer.getInfoSet();
    }

    public Set<FormFieldInfo> analyzeForm(int ... pageIndexes) {
        if (Objects.isNull(this.formAnalyzer)) {
            this.formAnalyzer = new FormAnalyzer(this.document);
        }
        this.process(this.formAnalyzer::processForm, pageIndexes);
        if (Objects.isNull(pageIndexes) || pageIndexes.length == 0) {
            this.formAnalyzer.processForm(-1, null);
        }
        this.process(this.formAnalyzer::processForm, pageIndexes);
        return this.formAnalyzer.getInfoSet();
    }

    public Set<BookmarkInfo> analyzeBookmark(int ... bookmarkIndexes) {
        if (Objects.isNull(this.bookmarkAnalyzer)) {
            this.bookmarkAnalyzer = new BookmarkAnalyzer(this.document);
        }
        this.bookmarkAnalyzer.processOutlineItem(bookmarkIndexes);
        return this.bookmarkAnalyzer.getInfoSet();
    }

    @Override
    public void close() {
        this.textAnalyzer = null;
        this.commentAnalyzer = null;
        this.imageAnalyzer = null;
        this.formAnalyzer = null;
        this.bookmarkAnalyzer = null;
    }

    protected void process(BiConsumer<Integer, PDPage> consumer, int[] pageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.isNull(pageIndexes) || pageIndexes.length == 0) {
            int count = pageTree.getCount();
            for (int i = 0; i < count; ++i) {
                consumer.accept(i, pageTree.get(i));
            }
        } else {
            for (int index : pageIndexes) {
                if (index < 0) continue;
                consumer.accept(index, pageTree.get(index));
            }
        }
    }

    public void setTextAnalyzer(AbstractTextAnalyzer textAnalyzer) {
        this.textAnalyzer = textAnalyzer;
    }

    public void setCommentAnalyzer(AbstractCommentAnalyzer commentAnalyzer) {
        this.commentAnalyzer = commentAnalyzer;
    }

    public void setImageAnalyzer(AbstractImageAnalyzer imageAnalyzer) {
        this.imageAnalyzer = imageAnalyzer;
    }

    public void setFormAnalyzer(AbstractFormAnalyzer formAnalyzer) {
        this.formAnalyzer = formAnalyzer;
    }

    public void setBookmarkAnalyzer(AbstractBookmarkAnalyzer bookmarkAnalyzer) {
        this.bookmarkAnalyzer = bookmarkAnalyzer;
    }

    public AbstractTextAnalyzer getTextAnalyzer() {
        return this.textAnalyzer;
    }

    public AbstractCommentAnalyzer getCommentAnalyzer() {
        return this.commentAnalyzer;
    }

    public AbstractImageAnalyzer getImageAnalyzer() {
        return this.imageAnalyzer;
    }

    public AbstractFormAnalyzer getFormAnalyzer() {
        return this.formAnalyzer;
    }

    public AbstractBookmarkAnalyzer getBookmarkAnalyzer() {
        return this.bookmarkAnalyzer;
    }
}

