/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.extractor;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractExtractor;

public abstract class AbstractFormExtractor
extends AbstractExtractor {
    public AbstractFormExtractor(Document document) {
        super(document);
    }

    public abstract Map<String, PDField> extractField();

    public abstract Map<String, String> extractText();

    public abstract Map<String, BufferedImage> extractImage();

    protected Map<String, PDField> processField() {
        HashMap<String, PDField> data = new HashMap<String, PDField>(32);
        this.process(data, (container, field) -> container.put(field.getFullyQualifiedName(), field));
        return data;
    }

    protected Map<String, String> processText() {
        HashMap<String, String> data = new HashMap<String, String>(32);
        this.process(data, (container, field) -> container.put(field.getFullyQualifiedName(), field.getValueAsString()));
        return data;
    }

    protected Map<String, BufferedImage> processImage() {
        HashMap<String, BufferedImage> data = new HashMap<String, BufferedImage>(32);
        this.process(data, (container, field) -> {
            PDResources resources;
            PDFormXObject normalIcon;
            PDAppearanceCharacteristicsDictionary appearanceCharacteristics;
            List widgets = field.getWidgets();
            if (!widgets.isEmpty() && Objects.nonNull(appearanceCharacteristics = ((PDAnnotationWidget)field.getWidgets().get(0)).getAppearanceCharacteristics()) && Objects.nonNull(normalIcon = appearanceCharacteristics.getNormalIcon()) && Objects.nonNull(resources = normalIcon.getResources())) {
                Iterable objectNames = resources.getXObjectNames();
                for (COSName objectName : objectNames) {
                    try {
                        PDXObject xObject = resources.getXObject(objectName);
                        if (!(xObject instanceof PDImage)) continue;
                        container.put(field.getFullyQualifiedName(), ((PDImage)xObject).getImage());
                        break;
                    }
                    catch (Exception e) {
                        log.error((Object)("the object name['" + objectName.getName() + "'] is invalid, will be ignored"));
                    }
                }
            }
        });
        return data;
    }

    protected <T> void process(T container, BiConsumer<T, PDField> consumer) {
        PDAcroForm form = this.getDocument().getDocumentCatalog().getAcroForm();
        if (Objects.nonNull(form)) {
            List fields = form.getFields();
            for (PDField field : fields) {
                consumer.accept(container, field);
            }
        }
    }
}

