/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.fixup.AcroFormDefaultFixup;
import org.apache.pdfbox.pdmodel.fixup.PDDocumentFixup;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class FormProcessor
extends AbstractProcessor {
    private static final String NONE_FONT_SIZE_REGEX = "/\\S*";
    private static final String FONT_SIZE_REGEX = "/.*Tf";
    protected PDAcroForm form;

    public FormProcessor(Document document) {
        this(document, true, true);
    }

    public FormProcessor(Document document, boolean isFixForm, boolean isNeedAppearance) {
        super(document);
        this.form = this.initForm(document.getTarget(), isFixForm, isNeedAppearance);
    }

    public List<PDField> getFields() {
        return this.form.getFields();
    }

    public void replaceKey(Map<String, String> keyMap) {
        keyMap.forEach((key, value) -> {
            PDField field = this.form.getField(key);
            if (Objects.nonNull(field)) {
                field.setMappingName(value);
            }
        });
        this.getDocument().getDocumentCatalog().setAcroForm(this.form);
    }

    public void fillText(Map<String, String> formMap, PDFont font) {
        this.fillText(formMap, font, null);
    }

    public void fillText(Map<String, String> formMap, PDFont font, Integer fontSize) {
        Objects.requireNonNull(formMap, "the form map can not be null");
        Objects.requireNonNull(font, "the font can not be null");
        Set<Map.Entry<String, String>> entrySet = formMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            PDField field = this.form.getField(entry.getKey());
            if (Objects.nonNull(field)) {
                if (field instanceof PDTextField) {
                    this.resetText(font, fontSize, (PDTextField)field, entry.getValue());
                    continue;
                }
                log.warn((Object)("the field['" + entry.getKey() + "'] is not text field, will be ignored"));
                continue;
            }
            log.warn((Object)("the field['" + entry.getKey() + "'] is not exist, will be ignored"));
        }
        this.form.refreshAppearances();
        this.getDocument().getDocumentCatalog().setAcroForm(this.form);
    }

    public void fillImage(Map<String, BufferedImage> formMap) {
        Objects.requireNonNull(formMap, "the form map can not be null");
        Set<Map.Entry<String, BufferedImage>> entrySet = formMap.entrySet();
        for (Map.Entry<String, BufferedImage> entry : entrySet) {
            PDAppearanceCharacteristicsDictionary appearanceCharacteristics;
            List widgets;
            PDField field = this.form.getField(entry.getKey());
            if (!Objects.nonNull(field) || !(field instanceof PDPushButton) || (widgets = field.getWidgets()).isEmpty() || !Objects.nonNull(appearanceCharacteristics = ((PDAnnotationWidget)field.getWidgets().get(0)).getAppearanceCharacteristics())) continue;
            BufferedImage image = entry.getValue();
            if (Objects.nonNull(image)) {
                appearanceCharacteristics.getCOSObject().setItem(COSName.I, (COSBase)PDImageXObject.createFromByteArray((PDDocument)this.getDocument(), (byte[])ImageUtil.toBytes(image, ImageType.PNG.getType()), (String)ImageType.PNG.getType()).getCOSObject());
                continue;
            }
            appearanceCharacteristics.getCOSObject().setItem(COSName.I, null);
        }
        this.getDocument().getDocumentCatalog().setAcroForm(this.form);
    }

    public void remove(String ... keys) {
        if (Objects.nonNull(keys) && keys.length > 0) {
            ArrayList<PDField> fields = new ArrayList<PDField>(keys.length);
            for (String key : keys) {
                PDField field = this.form.getField(key);
                if (!Objects.nonNull(field)) continue;
                fields.add(field);
            }
            this.form.flatten(fields, false);
        } else {
            this.form.flatten();
        }
        this.getDocument().getDocumentCatalog().setAcroForm(this.form);
    }

    public void clear() {
        this.form.flatten();
        this.getDocument().getDocumentCatalog().setAcroForm(this.form);
    }

    protected PDAcroForm initForm(PDDocument document, boolean isFixForm, boolean isNeedAppearance) {
        PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
        PDAcroForm acroForm = isFixForm ? documentCatalog.getAcroForm((PDDocumentFixup)new AcroFormDefaultFixup(document)) : documentCatalog.getAcroForm(null);
        if (Objects.isNull(acroForm)) {
            acroForm = new PDAcroForm(document);
        }
        acroForm.setNeedAppearances(Boolean.valueOf(isNeedAppearance));
        acroForm.setCacheFields(true);
        return acroForm;
    }

    protected void resetText(PDFont font, Integer fontSize, PDTextField field, String newValue) {
        if (Objects.nonNull(newValue)) {
            String defaultAppearance = field.getDefaultAppearance();
            if (Objects.isNull(fontSize)) {
                field.setDefaultAppearance(defaultAppearance.replaceFirst(NONE_FONT_SIZE_REGEX, String.join((CharSequence)"", "/", font.getName())));
            } else {
                field.setDefaultAppearance(defaultAppearance.replaceFirst(FONT_SIZE_REGEX, String.join((CharSequence)" ", "/" + font.getName(), String.valueOf(fontSize), "Tf")));
            }
            this.form.getDefaultResources().put(COSName.getPDFName((String)font.getName()), font);
            PdfHandler.getFontHandler().addToSubset(this.getDocument(), font, newValue);
        }
        try {
            field.setValue(newValue);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("the font is not supported, please use an other font");
        }
    }

    public PDAcroForm getForm() {
        return this.form;
    }
}

