/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.RenderingHints;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.PrintOrientation;
import org.dromara.pdf.pdfbox.core.enums.PrintScaling;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.util.RenderingHintUtil;
import sun.print.RasterPrinterJob;

public class PrintProcessor
extends AbstractProcessor {
    protected Integer beginPageNo;
    protected Integer endPageNo;
    protected PrintScaling scaling;
    protected PrintOrientation orientation;
    protected Float dpi;
    protected RenderingHints renderingHints;
    protected Boolean isShowBorder;
    protected Boolean isCenter;
    protected Boolean isMemoryOptimization;
    protected Integer count;

    public PrintProcessor(Document document) {
        super(document);
    }

    public void setBeginPageNo(Integer beginPageNo) {
        if (Objects.nonNull(beginPageNo) && beginPageNo < 1) {
            throw new IllegalArgumentException("the begin page no must be greater than 1");
        }
        this.beginPageNo = beginPageNo;
    }

    public void setEndPageNo(Integer endPageNo) {
        int pages = this.getDocument().getNumberOfPages();
        if (Objects.nonNull(endPageNo) && endPageNo > pages) {
            throw new IllegalArgumentException("the end page no must not be greater than the page num of the document['" + pages + "']");
        }
        if (Objects.nonNull(endPageNo) && endPageNo < Optional.ofNullable(this.beginPageNo).orElse(1)) {
            throw new IllegalArgumentException("the end page no must not be less than begin page num or 1");
        }
        this.endPageNo = endPageNo;
    }

    public void print() {
        this.init();
        RasterPrinterJob job = (RasterPrinterJob)PrinterJob.getPrinterJob();
        job.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
        job.setPageable(this.initPageable());
        job.setCopies(this.count);
        this.initPrintRequestAttribute(job);
        job.print();
    }

    protected void init() {
        if (Objects.isNull(this.beginPageNo)) {
            this.beginPageNo = 1;
        }
        if (Objects.isNull(this.endPageNo)) {
            this.endPageNo = this.getDocument().getNumberOfPages();
        }
        if (Objects.isNull((Object)this.scaling)) {
            this.scaling = PrintScaling.ACTUAL_SIZE;
        }
        if (Objects.isNull((Object)this.orientation)) {
            this.orientation = PrintOrientation.PORTRAIT;
        }
        if (Objects.isNull(this.dpi)) {
            this.dpi = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.renderingHints)) {
            this.renderingHints = RenderingHintUtil.createDefaultRenderingHints();
        }
        if (Objects.isNull(this.isShowBorder)) {
            this.isShowBorder = Boolean.FALSE;
        }
        if (Objects.isNull(this.isCenter)) {
            this.isCenter = Boolean.TRUE;
        }
        if (Objects.isNull(this.isMemoryOptimization)) {
            this.isMemoryOptimization = Boolean.FALSE;
        }
        if (Objects.isNull(this.count)) {
            this.count = 1;
        }
    }

    protected PDFPrintable initPrintable() {
        PDFPrintable printable = new PDFPrintable(this.getDocument(), this.scaling.getScaling(), this.isShowBorder.booleanValue(), this.dpi.floatValue(), this.isCenter.booleanValue(), new PDFRenderer(this.getDocument()));
        printable.setSubsamplingAllowed(this.isMemoryOptimization.booleanValue());
        printable.setRenderingHints(this.renderingHints);
        return printable;
    }

    protected DefaultPageable initPageable() {
        return new DefaultPageable(this.getDocument(), this.orientation.getOrientation(), (Printable)this.initPrintable());
    }

    protected void initPrintRequestAttribute(RasterPrinterJob job) {
        String methodName = "setAttributes";
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet(new PageRanges(this.beginPageNo, this.endPageNo));
        Method method = RasterPrinterJob.class.getDeclaredMethod("setAttributes", PrintRequestAttributeSet.class);
        method.setAccessible(true);
        method.invoke((Object)job, attributes);
    }

    public void setScaling(PrintScaling scaling) {
        this.scaling = scaling;
    }

    public void setOrientation(PrintOrientation orientation) {
        this.orientation = orientation;
    }

    public void setDpi(Float dpi) {
        this.dpi = dpi;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
    }

    public void setIsShowBorder(Boolean isShowBorder) {
        this.isShowBorder = isShowBorder;
    }

    public void setIsCenter(Boolean isCenter) {
        this.isCenter = isCenter;
    }

    public void setIsMemoryOptimization(Boolean isMemoryOptimization) {
        this.isMemoryOptimization = isMemoryOptimization;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public static class DefaultPageable
    extends Book {
        private final PDDocument document;
        private final int numberOfPages;
        private final Orientation orientation;
        private final Printable printable;

        public DefaultPageable(PDDocument document, Orientation orientation, Printable printable) {
            this.document = document;
            this.orientation = orientation;
            this.printable = printable;
            this.numberOfPages = document.getNumberOfPages();
        }

        @Override
        public int getNumberOfPages() {
            return this.numberOfPages;
        }

        @Override
        public PageFormat getPageFormat(int pageIndex) {
            boolean isLandscape;
            Paper paper;
            PDPage page = this.document.getPage(pageIndex);
            PDRectangle mediaBox = this.getRotatedMediaBox(page);
            PDRectangle cropBox = this.getRotatedCropBox(page);
            if (mediaBox.getWidth() > mediaBox.getHeight()) {
                paper = new Paper();
                paper.setSize(mediaBox.getHeight(), mediaBox.getWidth());
                paper.setImageableArea(cropBox.getLowerLeftY(), cropBox.getLowerLeftX(), cropBox.getHeight(), cropBox.getWidth());
                isLandscape = true;
            } else {
                paper = new Paper();
                paper.setSize(mediaBox.getWidth(), mediaBox.getHeight());
                paper.setImageableArea(cropBox.getLowerLeftX(), cropBox.getLowerLeftY(), cropBox.getWidth(), cropBox.getHeight());
                isLandscape = false;
            }
            PageFormat format = new PageFormat();
            format.setPaper(paper);
            switch (this.orientation) {
                case AUTO: {
                    format.setOrientation(isLandscape ? 0 : 1);
                    break;
                }
                case LANDSCAPE: {
                    format.setOrientation(0);
                    break;
                }
                case PORTRAIT: {
                    format.setOrientation(1);
                    break;
                }
            }
            return format;
        }

        @Override
        public Printable getPrintable(int i) {
            if (i >= this.numberOfPages) {
                throw new IndexOutOfBoundsException(i + " >= " + this.numberOfPages);
            }
            return this.printable;
        }

        protected PDRectangle getRotatedCropBox(PDPage page) {
            PDRectangle cropBox = page.getCropBox();
            int rotationAngle = page.getRotation();
            if (rotationAngle == 90 || rotationAngle == 270) {
                return new PDRectangle(cropBox.getLowerLeftY(), cropBox.getLowerLeftX(), cropBox.getHeight(), cropBox.getWidth());
            }
            return cropBox;
        }

        protected PDRectangle getRotatedMediaBox(PDPage page) {
            PDRectangle mediaBox = page.getMediaBox();
            int rotationAngle = page.getRotation();
            if (rotationAngle == 90 || rotationAngle == 270) {
                return new PDRectangle(mediaBox.getLowerLeftY(), mediaBox.getLowerLeftX(), mediaBox.getHeight(), mediaBox.getWidth());
            }
            return mediaBox;
        }
    }
}

