/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.support.COSBaseInfo;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class ReplaceProcessor
extends AbstractProcessor {
    public ReplaceProcessor(Document document) {
        super(document);
    }

    public void replaceText(PDFont font, Map<String, String> replaceMap, int ... pageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceText(pageTree.get(pageIndex), font, replaceMap);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceText(page, font, replaceMap);
            }
        }
    }

    public void replaceComment(Map<String, String> replaceMap, int ... pageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceComment(pageTree.get(pageIndex), replaceMap);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceComment(page, replaceMap);
            }
        }
    }

    public void replaceImage(BufferedImage image, List<Integer> pageIndexes, int ... imageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceImage(pageTree.get(pageIndex), image, imageIndexes);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceImage(page, image, imageIndexes);
            }
        }
    }

    public void replaceBookmark(Map<String, String> replaceMap, int ... bookmarkIndexes) {
        block7: {
            PDDocumentCatalog documentCatalog = this.getDocument().getDocumentCatalog();
            PDDocumentOutline documentOutline = documentCatalog.getDocumentOutline();
            if (!Objects.nonNull(documentOutline)) break block7;
            int index = 0;
            Iterable items = documentOutline.children();
            if (Objects.nonNull(bookmarkIndexes) && bookmarkIndexes.length > 0) {
                PrimitiveIterator.OfInt iterator = Arrays.stream(bookmarkIndexes).sorted().iterator();
                int bookmarkIndex = 0;
                for (PDOutlineItem outlineItem : items) {
                    if (index < bookmarkIndex) {
                        ++index;
                        continue;
                    }
                    if (iterator.hasNext()) {
                        bookmarkIndex = iterator.next();
                        if (index == bookmarkIndex) {
                            this.replaceBookmark(outlineItem, replaceMap);
                        }
                        ++index;
                        continue;
                    }
                    break;
                }
            } else {
                for (PDOutlineItem outlineItem : items) {
                    this.replaceBookmark(outlineItem, replaceMap);
                    ++index;
                }
            }
        }
    }

    protected void replaceText(PDPage page, PDFont font, Map<String, String> replaceMap) {
        block14: {
            PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
            List tokens = parser.parse();
            if (!this.replaceTextToken(font, page.getResources(), tokens, replaceMap)) break block14;
            PDStream updatedStream = new PDStream(this.getDocument());
            try (OutputStream outputStream = updatedStream.createOutputStream(COSName.FLATE_DECODE);){
                ContentStreamWriter tokenWriter = new ContentStreamWriter(outputStream);
                tokenWriter.writeTokens(tokens);
                page.setContents(updatedStream);
            }
        }
    }

    protected void replaceComment(PDPage page, Map<String, String> replaceMap) {
        List pdAnnotations = page.getAnnotations();
        for (PDAnnotation annotation : pdAnnotations) {
            PDAnnotationText text;
            String comment;
            String replaceString;
            if (!(annotation instanceof PDAnnotationText) || Objects.equals(replaceString = this.getReplaceString(comment = (text = (PDAnnotationText)annotation).getContents(), replaceMap), comment)) continue;
            text.setContents(replaceString);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("replace comment from \"" + comment + "\" to \"" + replaceString + "\""));
        }
    }

    protected void replaceImage(PDPage page, BufferedImage image, int ... imageIndexes) {
        block8: {
            PDImageXObject imageObject = null;
            if (Objects.nonNull(image)) {
                imageObject = PDImageXObject.createFromByteArray((PDDocument)this.getDocument(), (byte[])ImageUtil.toBytes(image, ImageType.PNG.getType()), (String)ImageType.PNG.getType());
            }
            PDResources resources = page.getResources();
            Iterable objectNames = resources.getXObjectNames();
            if (Objects.isNull(imageIndexes) || imageIndexes.length == 0) {
                for (COSName cosName : objectNames) {
                    if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                    resources.put(cosName, (PDXObject)imageObject);
                }
                break block8;
            }
            PrimitiveIterator.OfInt iterator = Arrays.stream(imageIndexes).sorted().iterator();
            int index = 0;
            int replaceIndex = (Integer)iterator.next();
            for (COSName cosName : objectNames) {
                if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                if (index == replaceIndex) {
                    resources.put(cosName, (PDXObject)imageObject);
                    if (!iterator.hasNext()) break;
                    replaceIndex = (Integer)iterator.next();
                }
                ++index;
            }
        }
    }

    protected void replaceBookmark(PDOutlineItem outlineItem, Map<String, String> replaceMap) {
        String title = this.getReplaceString(outlineItem.getTitle(), replaceMap);
        if (Objects.nonNull(title)) {
            outlineItem.setTitle(title);
        }
        Iterable children = outlineItem.children();
        for (PDOutlineItem child : children) {
            this.replaceBookmark(child, replaceMap);
        }
    }

    protected boolean replaceTextToken(PDFont font, PDResources resources, List<Object> tokens, Map<String, String> replaceMap) {
        Map<COSName, PDFont> resourceFontMap = this.initResourceFontMap(resources);
        COSName replaceFontName = COSName.getPDFName((String)font.getName());
        Integer resourceFontIndex = null;
        COSName resourceFontName = null;
        PDFont resourceFont = null;
        LinkedHashMap cosBaseMap = new LinkedHashMap(10);
        for (int i = 0; i < tokens.size(); ++i) {
            List list;
            Object token = tokens.get(i);
            if (token instanceof COSName) {
                if (resourceFontMap.get(token) == null) continue;
                resourceFont = resourceFontMap.get(token);
                resourceFontIndex = i;
                resourceFontName = (COSName)token;
                if (cosBaseMap.containsKey(resourceFontName)) continue;
                cosBaseMap.put(resourceFontName, new ArrayList(64));
                continue;
            }
            if (!(token instanceof COSArray) && !(token instanceof COSString) || (list = (List)cosBaseMap.get(resourceFontName)) == null) continue;
            list.add(new COSBaseInfo((COSBase)token, resourceFontIndex, resourceFontName, resourceFont));
        }
        boolean flag = false;
        Collection values = cosBaseMap.values();
        for (List cosBases : values) {
            if (cosBases.isEmpty()) continue;
            for (COSBaseInfo info : cosBases) {
                if (!this.getReplaceString(info.getCosBase(), replaceMap, resourceFont, font)) continue;
                tokens.set(info.getFontIndex(), replaceFontName);
                if (Objects.isNull(resources.getFont(replaceFontName))) {
                    resources.put(replaceFontName, font);
                }
                flag = true;
            }
        }
        return flag;
    }

    protected boolean getReplaceString(COSBase cosBase, Map<String, String> replaceMap, PDFont resourceFont, PDFont replaceFont) {
        if (cosBase instanceof COSArray || cosBase instanceof COSString) {
            String source = this.readFromToken(cosBase, resourceFont);
            String replaceString = this.getReplaceString(source, replaceMap);
            if (Objects.isNull(replaceString) || Objects.equals(replaceString, source)) {
                return false;
            }
            PdfHandler.getFontHandler().addToSubset(this.getDocument(), replaceFont, replaceString);
            if (cosBase instanceof COSArray) {
                COSArray array = (COSArray)cosBase;
                array.clear();
                array.add((COSBase)new COSString(replaceFont.encode(replaceString)));
            } else {
                byte[] array = replaceFont.encode(replaceString);
                COSString cosString = (COSString)cosBase;
                cosString.setValue(array);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("replace string from \"" + source + "\" to \"" + replaceString + "\""));
            }
            return true;
        }
        return false;
    }

    protected String getReplaceString(String content, Map<String, String> replaceMap) {
        if (Objects.isNull(content)) {
            return null;
        }
        if (!content.trim().isEmpty()) {
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                Matcher matcher = Pattern.compile(entry.getKey(), 16).matcher(content);
                if (!matcher.find()) continue;
                content = matcher.replaceAll(entry.getValue());
            }
        }
        return content;
    }

    protected String readFromToken(Object token, PDFont resourceFont) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (token instanceof COSArray) {
            COSArray array = (COSArray)token;
            for (COSBase cosBase : array) {
                COSInteger cosInteger;
                if (cosBase instanceof COSString) {
                    COSString cosString = (COSString)cosBase;
                    ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());
                    Throwable throwable = null;
                    try {
                        while (((InputStream)in).available() > 0) {
                            builder.append(resourceFont.toUnicode(resourceFont.readCode((InputStream)in)));
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)in).close();
                        continue;
                    }
                }
                if (!(cosBase instanceof COSInteger) || (cosInteger = (COSInteger)cosBase).intValue() > -199) continue;
                builder.append(" ");
            }
        } else if (token instanceof COSString) {
            COSString cosString = (COSString)token;
            try (ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());){
                while (((InputStream)in).available() > 0) {
                    builder.append(resourceFont.toUnicode(resourceFont.readCode((InputStream)in)));
                }
            }
        }
        return builder.toString();
    }

    protected Map<COSName, PDFont> initResourceFontMap(PDResources resources) {
        HashMap<COSName, PDFont> resourceFontMap = new HashMap<COSName, PDFont>(16);
        if (Objects.nonNull(resources)) {
            for (COSName cosName : resources.getFontNames()) {
                resourceFontMap.put(cosName, resources.getFont(cosName));
            }
        }
        return resourceFontMap;
    }
}

