/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support;

import java.util.Objects;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDFreeTextAppearanceHandler;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.handler.PdfHandler;

public class DefaultFreeTextAppearanceHandler
extends PDFreeTextAppearanceHandler {
    private Document document;
    private PDAnnotation annotation;
    private PDFont font;

    public DefaultFreeTextAppearanceHandler(Document document, PDAnnotation annotation) {
        this(document, annotation, null);
    }

    public DefaultFreeTextAppearanceHandler(Document document, PDAnnotation annotation, PDFont font) {
        super(annotation, document.getTarget());
        this.document = document;
        this.annotation = annotation;
        this.font = font;
    }

    protected PDFont getDefaultFont() {
        if (Objects.isNull(this.font)) {
            this.font = this.document.getFont();
        }
        return this.font;
    }

    public void generateNormalAppearance() {
        super.generateNormalAppearance();
        PdfHandler.getFontHandler().addToSubset(this.document.getTarget(), this.font, this.annotation.getContents());
        this.release();
    }

    protected void release() {
        this.document = null;
        this.annotation = null;
        this.font = null;
    }
}

