/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.AbstractPageHeaderOrFooter;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;

public class PageFooter
extends AbstractPageHeaderOrFooter {
    protected Float originalY;

    public PageFooter(Page page) {
        super(page);
        page.getContext().setPageFooter(this);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.PAGE_FOOTER;
    }

    @Override
    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    @Override
    public void reset() {
        super.reset();
        this.getContext().getCursor().reset(this.getBeginX().floatValue(), this.originalY.floatValue());
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.getHeight(), "the height can not be null");
        if (Objects.isNull(this.getBeginX())) {
            this.setBeginX(Float.valueOf(this.getContext().getPage().getMarginLeft().floatValue() + this.getMarginLeft().floatValue()));
        }
        if (Objects.isNull(this.getBeginY())) {
            this.setBeginY(Float.valueOf(this.getHeight().floatValue() + this.getContext().getPage().getMarginBottom().floatValue()));
        }
        this.initWidth();
        this.initBackgroundColor(this.getBeginX().floatValue(), this.getBeginY().floatValue());
        this.originalY = this.getContext().getCursor().getY();
        this.getContext().getCursor().reset(this.getBeginX().floatValue(), this.getBeginY().floatValue());
        this.getContext().resetHeight(this.getHeight());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageFooter)) {
            return false;
        }
        PageFooter other = (PageFooter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$originalY = this.originalY;
        Float other$originalY = other.originalY;
        return !(this$originalY == null ? other$originalY != null : !((Object)this$originalY).equals(other$originalY));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageFooter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $originalY = this.originalY;
        result = result * 59 + ($originalY == null ? 43 : ((Object)$originalY).hashCode());
        return result;
    }
}

