/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.AbstractPageHeaderOrFooter;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;

public class PageHeader
extends AbstractPageHeaderOrFooter {
    public PageHeader(Page page) {
        super(page);
        this.getContext().setPageHeader(this);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.PAGE_HEADER;
    }

    @Override
    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.getHeight(), "the height can not be null");
        if (Objects.isNull(this.getBeginX())) {
            this.setBeginX(Float.valueOf(this.getContext().getPage().getMarginLeft().floatValue() + this.getMarginLeft().floatValue()));
        }
        if (Objects.isNull(this.getBeginY())) {
            this.setBeginY(Float.valueOf(this.getContext().getPage().getHeight().floatValue() - this.getContext().getPage().getMarginTop().floatValue()));
        }
        this.initWidth();
        this.initBackgroundColor(this.getBeginX().floatValue(), this.getBeginY().floatValue());
        this.getContext().getCursor().reset(this.getBeginX().floatValue(), this.getBeginY().floatValue());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageHeader)) {
            return false;
        }
        PageHeader other = (PageHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageHeader;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

